<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VoorraadArtikelRecV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Voorraad artikel
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class VoorraadArtikelRecV5 extends AbstractStructBase
{
    /**
     * The nummer
     * Meta informations extracted from the WSDL
     * - documentation: Het nummer van het artikel
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $nummer;
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - documentation: De code van het artikel
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $code;
    /**
     * The artikelGroep
     * Meta informations extracted from the WSDL
     * - documentation: De artikelgroep van het artikel
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \VoorraadApiV5\StructType\ArtikelgroepRecV5
     */
    public $artikelGroep;
    /**
     * The naam
     * Meta informations extracted from the WSDL
     * - documentation: De naam van het artikel (Bij een publicatie: de titel)
     * - base: xsd:string
     * - maxLength: 500
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $naam;
    /**
     * The prijs
     * Meta informations extracted from the WSDL
     * - documentation: De prijs van het artikel (ex BTW) - Het gebruik van dit veld wordt afgeraden en is vervangen door prijsExclBtw. In een volgende versie van de webservice zal dit veld niet meer bestaan.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $prijs;
    /**
     * The prijsExclBtw
     * Meta informations extracted from the WSDL
     * - documentation: De prijs van het artikel exclusief BTW
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $prijsExclBtw;
    /**
     * The prijsInclBtw
     * Meta informations extracted from the WSDL
     * - documentation: De prijs van het artikel inclusief BTW
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $prijsInclBtw;
    /**
     * The btwCode
     * Meta informations extracted from the WSDL
     * - documentation: De BTW-code die op het artikel van toepassing is
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $btwCode;
    /**
     * The btwPercentage
     * Meta informations extracted from the WSDL
     * - documentation: Het BTW-percentage dat op het artikel van toepassing is
     * - base: xsd:decimal
     * - fractionDigits: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 16
     * @var float
     */
    public $btwPercentage;
    /**
     * The isbnNummer
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) Het ISBN-nummer
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $isbnNummer;
    /**
     * The geplandeVerschDatum
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) Geplande verschijningsdatum
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $geplandeVerschDatum;
    /**
     * The leverbaarVanaf
     * Meta informations extracted from the WSDL
     * - documentation: Datum vanaf wanneer het artikel leverbaar is
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $leverbaarVanaf;
    /**
     * The leverbaarTm
     * Meta informations extracted from the WSDL
     * - documentation: Datum tot en met wanneer het artikel leverbaar is
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $leverbaarTm;
    /**
     * The omschrijving
     * Meta informations extracted from the WSDL
     * - documentation: Omschrijving van het artikel
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $omschrijving;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - documentation: (Artikel) Actief. 0=Niet actief, 1=Actief. (Publicatie) status. 0=Afgesloten, 1=Aktueel, 2=Productie, 3=Gepland, 4=Niet leverbaar
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $status;
    /**
     * The verschijningsvorm
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) de verschijningsvorm
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \VoorraadApiV5\StructType\VerschijningsvormRecV5
     */
    public $verschijningsvorm;
    /**
     * The vrijeVelden
     * Meta informations extracted from the WSDL
     * - documentation: De vrije velden van het artikel
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \VoorraadApiV5\StructType\ArtikelVrijeVeldenRecV5
     */
    public $vrijeVelden;
    /**
     * The druk
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) De druk van de publicatie.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $druk;
    /**
     * The aantalPaginas
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) Het aantal paginas van de publicatie
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $aantalPaginas;
    /**
     * The subtitel
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) De subtitel van de publicatie
     * - base: xsd:string
     * - maxLength: 500
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $subtitel;
    /**
     * The hoogte
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) De hoogte van de publicatie.
     * - base: xsd:decimal
     * - fractionDigits: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 16
     * @var float
     */
    public $hoogte;
    /**
     * The breedte
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) De breedte van de publicatie.
     * - base: xsd:decimal
     * - fractionDigits: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 16
     * @var float
     */
    public $breedte;
    /**
     * The dikte
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) De dikte van de publicatie.
     * - base: xsd:decimal
     * - fractionDigits: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 16
     * @var float
     */
    public $dikte;
    /**
     * The gewicht
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) Gewicht van de publiatie in gram.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $gewicht;
    /**
     * The pod
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) Indicatie of het boek beschikbaar via Printing on Demand. Deze publicaties zijn altijd leverbaar
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $pod;
    /**
     * The fondsCode
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) De code van het fonds van de publicatie.
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $fondsCode;
    /**
     * The fondsNaam
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) De naam van het fonds van de publicatie.
     * - base: xsd:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $fondsNaam;
    /**
     * The aanleveringCode
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) De aanlever code van de publicatie.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aanleveringCode;
    /**
     * The aanleveringNaam
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) De aanlever naam van de publicatie.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $aanleveringNaam;
    /**
     * The serieCode
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) De serie code van de publicatie.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $serieCode;
    /**
     * The serieNaam
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) De serie naam van de publicatie.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $serieNaam;
    /**
     * The taalCode
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) De taal van de publicatie
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $taalCode;
    /**
     * The auteurs
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) De rechthebbende auteurs van de publicatie.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \VoorraadApiV5\StructType\RechthebbendeTableV5
     */
    public $auteurs;
    /**
     * The vertalers
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) De rechthebbende vertalers van de publicatie.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \VoorraadApiV5\StructType\RechthebbendeTableV5
     */
    public $vertalers;
    /**
     * The illustrators
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) De rechthebbende illustrators van de publicatie.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \VoorraadApiV5\StructType\RechthebbendeTableV5
     */
    public $illustrators;
    /**
     * The redacteuren
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) De rechthebbende redacteuren van de publicatie.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \VoorraadApiV5\StructType\RechthebbendeTableV5
     */
    public $redacteuren;
    /**
     * The link
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) Link van de publicatie naar een site
     * - base: xsd:string
     * - maxLength: 250
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $link;
    /**
     * The korteInhoud
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) De korte inhoud (flaptekst) van het artikel
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $korteInhoud;
    /**
     * The eigenaarRelatieNr
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) Relatienummer van de eigenaar.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $eigenaarRelatieNr;
    /**
     * The eigenaarNaam
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) Naam van de eigenaar.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $eigenaarNaam;
    /**
     * The volgArtikel
     * Meta informations extracted from the WSDL
     * - documentation: Artikelnummer van het volgartikel indien dit artikel op is.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $volgArtikel;
    /**
     * The projectCode
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) Code van het project (financieel) van de publicatie
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $projectCode;
    /**
     * The projectNaam
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) Naam van het project (financieel) van de publicatie
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $projectNaam;
    /**
     * The werkTitel
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) Werktitel (projectnaam) van de publicatie.
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $werkTitel;
    /**
     * The afwerkingCode
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) Code van de afwerking van de publicatie
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $afwerkingCode;
    /**
     * The afwerkingNaam
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) Omschrijving van de afwerking van de publicatie
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $afwerkingNaam;
    /**
     * The gelamineerdCode
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) Code van de manier van lamineren van de publicatie
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $gelamineerdCode;
    /**
     * The gelamineerdNaam
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) Omschrijving van de manier van lamineren van de publicatie
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $gelamineerdNaam;
    /**
     * The illustraties
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) Informatie over illustraties
     * - base: xsd:string
     * - maxLength: 1000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $illustraties;
    /**
     * The coderingen
     * Meta informations extracted from the WSDL
     * - documentation: (Publicatie) Coderingen die aan de publicatie zijn gekoppeld (o.a. NUR coderingen)
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \VoorraadApiV5\StructType\PublicatieCoderingenTableV5
     */
    public $coderingen;
    /**
     * The prijzen
     * Meta informations extracted from the WSDL
     * - documentation: Alle prijzen die van toepassing zijn op het artikel
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \VoorraadApiV5\StructType\ArtikelPrijzenTableV5
     */
    public $prijzen;
    /**
     * The staffels
     * Meta informations extracted from the WSDL
     * - documentation: Alle Staffelprijzen die van toepassing zijn op het artikel
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \VoorraadApiV5\StructType\ArtikelStaffelTableV5
     */
    public $staffels;
    /**
     * The actie
     * Meta informations extracted from the WSDL
     * - documentation: Geeft aan of het een actie artikel is.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $actie;
    /**
     * The artikelSamenstelling
     * Meta informations extracted from the WSDL
     * - documentation: Indien het artikel een samenstelling is uit 1 of meerdere andere artikelen, wordt dat hier gespecificeerd
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \VoorraadApiV5\StructType\ArtikelSamenstellingTableV5
     */
    public $artikelSamenstelling;
    /**
     * The fysiek
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of het artikel een fysiek te leven artikel is
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $fysiek;
    /**
     * The opIsOp
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of er nog voorraad komt als de huidige voorraad van het artikel 0 is
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $opIsOp;
    /**
     * Constructor method for VoorraadArtikelRecV5
     * @uses VoorraadArtikelRecV5::setNummer()
     * @uses VoorraadArtikelRecV5::setCode()
     * @uses VoorraadArtikelRecV5::setArtikelGroep()
     * @uses VoorraadArtikelRecV5::setNaam()
     * @uses VoorraadArtikelRecV5::setPrijs()
     * @uses VoorraadArtikelRecV5::setPrijsExclBtw()
     * @uses VoorraadArtikelRecV5::setPrijsInclBtw()
     * @uses VoorraadArtikelRecV5::setBtwCode()
     * @uses VoorraadArtikelRecV5::setBtwPercentage()
     * @uses VoorraadArtikelRecV5::setIsbnNummer()
     * @uses VoorraadArtikelRecV5::setGeplandeVerschDatum()
     * @uses VoorraadArtikelRecV5::setLeverbaarVanaf()
     * @uses VoorraadArtikelRecV5::setLeverbaarTm()
     * @uses VoorraadArtikelRecV5::setOmschrijving()
     * @uses VoorraadArtikelRecV5::setStatus()
     * @uses VoorraadArtikelRecV5::setVerschijningsvorm()
     * @uses VoorraadArtikelRecV5::setVrijeVelden()
     * @uses VoorraadArtikelRecV5::setDruk()
     * @uses VoorraadArtikelRecV5::setAantalPaginas()
     * @uses VoorraadArtikelRecV5::setSubtitel()
     * @uses VoorraadArtikelRecV5::setHoogte()
     * @uses VoorraadArtikelRecV5::setBreedte()
     * @uses VoorraadArtikelRecV5::setDikte()
     * @uses VoorraadArtikelRecV5::setGewicht()
     * @uses VoorraadArtikelRecV5::setPod()
     * @uses VoorraadArtikelRecV5::setFondsCode()
     * @uses VoorraadArtikelRecV5::setFondsNaam()
     * @uses VoorraadArtikelRecV5::setAanleveringCode()
     * @uses VoorraadArtikelRecV5::setAanleveringNaam()
     * @uses VoorraadArtikelRecV5::setSerieCode()
     * @uses VoorraadArtikelRecV5::setSerieNaam()
     * @uses VoorraadArtikelRecV5::setTaalCode()
     * @uses VoorraadArtikelRecV5::setAuteurs()
     * @uses VoorraadArtikelRecV5::setVertalers()
     * @uses VoorraadArtikelRecV5::setIllustrators()
     * @uses VoorraadArtikelRecV5::setRedacteuren()
     * @uses VoorraadArtikelRecV5::setLink()
     * @uses VoorraadArtikelRecV5::setKorteInhoud()
     * @uses VoorraadArtikelRecV5::setEigenaarRelatieNr()
     * @uses VoorraadArtikelRecV5::setEigenaarNaam()
     * @uses VoorraadArtikelRecV5::setVolgArtikel()
     * @uses VoorraadArtikelRecV5::setProjectCode()
     * @uses VoorraadArtikelRecV5::setProjectNaam()
     * @uses VoorraadArtikelRecV5::setWerkTitel()
     * @uses VoorraadArtikelRecV5::setAfwerkingCode()
     * @uses VoorraadArtikelRecV5::setAfwerkingNaam()
     * @uses VoorraadArtikelRecV5::setGelamineerdCode()
     * @uses VoorraadArtikelRecV5::setGelamineerdNaam()
     * @uses VoorraadArtikelRecV5::setIllustraties()
     * @uses VoorraadArtikelRecV5::setCoderingen()
     * @uses VoorraadArtikelRecV5::setPrijzen()
     * @uses VoorraadArtikelRecV5::setStaffels()
     * @uses VoorraadArtikelRecV5::setActie()
     * @uses VoorraadArtikelRecV5::setArtikelSamenstelling()
     * @uses VoorraadArtikelRecV5::setFysiek()
     * @uses VoorraadArtikelRecV5::setOpIsOp()
     * @param int $nummer
     * @param string $code
     * @param \VoorraadApiV5\StructType\ArtikelgroepRecV5 $artikelGroep
     * @param string $naam
     * @param float $prijs
     * @param float $prijsExclBtw
     * @param float $prijsInclBtw
     * @param string $btwCode
     * @param float $btwPercentage
     * @param string $isbnNummer
     * @param string $geplandeVerschDatum
     * @param string $leverbaarVanaf
     * @param string $leverbaarTm
     * @param string $omschrijving
     * @param float $status
     * @param \VoorraadApiV5\StructType\VerschijningsvormRecV5 $verschijningsvorm
     * @param \VoorraadApiV5\StructType\ArtikelVrijeVeldenRecV5 $vrijeVelden
     * @param int $druk
     * @param int $aantalPaginas
     * @param string $subtitel
     * @param float $hoogte
     * @param float $breedte
     * @param float $dikte
     * @param float $gewicht
     * @param bool $pod
     * @param string $fondsCode
     * @param string $fondsNaam
     * @param string $aanleveringCode
     * @param string $aanleveringNaam
     * @param string $serieCode
     * @param string $serieNaam
     * @param string $taalCode
     * @param \VoorraadApiV5\StructType\RechthebbendeTableV5 $auteurs
     * @param \VoorraadApiV5\StructType\RechthebbendeTableV5 $vertalers
     * @param \VoorraadApiV5\StructType\RechthebbendeTableV5 $illustrators
     * @param \VoorraadApiV5\StructType\RechthebbendeTableV5 $redacteuren
     * @param string $link
     * @param string $korteInhoud
     * @param float $eigenaarRelatieNr
     * @param string $eigenaarNaam
     * @param float $volgArtikel
     * @param string $projectCode
     * @param string $projectNaam
     * @param string $werkTitel
     * @param string $afwerkingCode
     * @param string $afwerkingNaam
     * @param string $gelamineerdCode
     * @param string $gelamineerdNaam
     * @param string $illustraties
     * @param \VoorraadApiV5\StructType\PublicatieCoderingenTableV5 $coderingen
     * @param \VoorraadApiV5\StructType\ArtikelPrijzenTableV5 $prijzen
     * @param \VoorraadApiV5\StructType\ArtikelStaffelTableV5 $staffels
     * @param bool $actie
     * @param \VoorraadApiV5\StructType\ArtikelSamenstellingTableV5 $artikelSamenstelling
     * @param bool $fysiek
     * @param bool $opIsOp
     */
    public function __construct($nummer = null, $code = null, \VoorraadApiV5\StructType\ArtikelgroepRecV5 $artikelGroep = null, $naam = null, $prijs = null, $prijsExclBtw = null, $prijsInclBtw = null, $btwCode = null, $btwPercentage = null, $isbnNummer = null, $geplandeVerschDatum = null, $leverbaarVanaf = null, $leverbaarTm = null, $omschrijving = null, $status = null, \VoorraadApiV5\StructType\VerschijningsvormRecV5 $verschijningsvorm = null, \VoorraadApiV5\StructType\ArtikelVrijeVeldenRecV5 $vrijeVelden = null, $druk = null, $aantalPaginas = null, $subtitel = null, $hoogte = null, $breedte = null, $dikte = null, $gewicht = null, $pod = null, $fondsCode = null, $fondsNaam = null, $aanleveringCode = null, $aanleveringNaam = null, $serieCode = null, $serieNaam = null, $taalCode = null, \VoorraadApiV5\StructType\RechthebbendeTableV5 $auteurs = null, \VoorraadApiV5\StructType\RechthebbendeTableV5 $vertalers = null, \VoorraadApiV5\StructType\RechthebbendeTableV5 $illustrators = null, \VoorraadApiV5\StructType\RechthebbendeTableV5 $redacteuren = null, $link = null, $korteInhoud = null, $eigenaarRelatieNr = null, $eigenaarNaam = null, $volgArtikel = null, $projectCode = null, $projectNaam = null, $werkTitel = null, $afwerkingCode = null, $afwerkingNaam = null, $gelamineerdCode = null, $gelamineerdNaam = null, $illustraties = null, \VoorraadApiV5\StructType\PublicatieCoderingenTableV5 $coderingen = null, \VoorraadApiV5\StructType\ArtikelPrijzenTableV5 $prijzen = null, \VoorraadApiV5\StructType\ArtikelStaffelTableV5 $staffels = null, $actie = null, \VoorraadApiV5\StructType\ArtikelSamenstellingTableV5 $artikelSamenstelling = null, $fysiek = null, $opIsOp = null)
    {
        $this
            ->setNummer($nummer)
            ->setCode($code)
            ->setArtikelGroep($artikelGroep)
            ->setNaam($naam)
            ->setPrijs($prijs)
            ->setPrijsExclBtw($prijsExclBtw)
            ->setPrijsInclBtw($prijsInclBtw)
            ->setBtwCode($btwCode)
            ->setBtwPercentage($btwPercentage)
            ->setIsbnNummer($isbnNummer)
            ->setGeplandeVerschDatum($geplandeVerschDatum)
            ->setLeverbaarVanaf($leverbaarVanaf)
            ->setLeverbaarTm($leverbaarTm)
            ->setOmschrijving($omschrijving)
            ->setStatus($status)
            ->setVerschijningsvorm($verschijningsvorm)
            ->setVrijeVelden($vrijeVelden)
            ->setDruk($druk)
            ->setAantalPaginas($aantalPaginas)
            ->setSubtitel($subtitel)
            ->setHoogte($hoogte)
            ->setBreedte($breedte)
            ->setDikte($dikte)
            ->setGewicht($gewicht)
            ->setPod($pod)
            ->setFondsCode($fondsCode)
            ->setFondsNaam($fondsNaam)
            ->setAanleveringCode($aanleveringCode)
            ->setAanleveringNaam($aanleveringNaam)
            ->setSerieCode($serieCode)
            ->setSerieNaam($serieNaam)
            ->setTaalCode($taalCode)
            ->setAuteurs($auteurs)
            ->setVertalers($vertalers)
            ->setIllustrators($illustrators)
            ->setRedacteuren($redacteuren)
            ->setLink($link)
            ->setKorteInhoud($korteInhoud)
            ->setEigenaarRelatieNr($eigenaarRelatieNr)
            ->setEigenaarNaam($eigenaarNaam)
            ->setVolgArtikel($volgArtikel)
            ->setProjectCode($projectCode)
            ->setProjectNaam($projectNaam)
            ->setWerkTitel($werkTitel)
            ->setAfwerkingCode($afwerkingCode)
            ->setAfwerkingNaam($afwerkingNaam)
            ->setGelamineerdCode($gelamineerdCode)
            ->setGelamineerdNaam($gelamineerdNaam)
            ->setIllustraties($illustraties)
            ->setCoderingen($coderingen)
            ->setPrijzen($prijzen)
            ->setStaffels($staffels)
            ->setActie($actie)
            ->setArtikelSamenstelling($artikelSamenstelling)
            ->setFysiek($fysiek)
            ->setOpIsOp($opIsOp);
    }
    /**
     * Get nummer value
     * @return int
     */
    public function getNummer()
    {
        return $this->nummer;
    }
    /**
     * Set nummer value
     * @param int $nummer
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setNummer($nummer = null)
    {
        // validation for constraint: int
        if (!is_null($nummer) && !(is_int($nummer) || ctype_digit($nummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nummer, true), gettype($nummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($nummer) && mb_strlen(preg_replace('/(\D)/', '', $nummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($nummer, true), mb_strlen(preg_replace('/(\D)/', '', $nummer))), __LINE__);
        }
        $this->nummer = $nummer;
        return $this;
    }
    /**
     * Get code value
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($code) && mb_strlen($code) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($code)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($code) && mb_strlen($code) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get artikelGroep value
     * @return \VoorraadApiV5\StructType\ArtikelgroepRecV5
     */
    public function getArtikelGroep()
    {
        return $this->artikelGroep;
    }
    /**
     * Set artikelGroep value
     * @param \VoorraadApiV5\StructType\ArtikelgroepRecV5 $artikelGroep
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setArtikelGroep(\VoorraadApiV5\StructType\ArtikelgroepRecV5 $artikelGroep = null)
    {
        $this->artikelGroep = $artikelGroep;
        return $this;
    }
    /**
     * Get naam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaam()
    {
        return isset($this->naam) ? $this->naam : null;
    }
    /**
     * Set naam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naam
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setNaam($naam = null)
    {
        // validation for constraint: string
        if (!is_null($naam) && !is_string($naam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naam, true), gettype($naam)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($naam) && mb_strlen($naam) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($naam)), __LINE__);
        }
        if (is_null($naam) || (is_array($naam) && empty($naam))) {
            unset($this->naam);
        } else {
            $this->naam = $naam;
        }
        return $this;
    }
    /**
     * Get prijs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrijs()
    {
        return isset($this->prijs) ? $this->prijs : null;
    }
    /**
     * Set prijs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prijs
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setPrijs($prijs = null)
    {
        // validation for constraint: float
        if (!is_null($prijs) && !(is_float($prijs) || is_numeric($prijs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prijs, true), gettype($prijs)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($prijs) && mb_strlen(preg_replace('/(\D)/', '', $prijs)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($prijs, true), mb_strlen(preg_replace('/(\D)/', '', $prijs))), __LINE__);
        }
        if (is_null($prijs) || (is_array($prijs) && empty($prijs))) {
            unset($this->prijs);
        } else {
            $this->prijs = $prijs;
        }
        return $this;
    }
    /**
     * Get prijsExclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrijsExclBtw()
    {
        return isset($this->prijsExclBtw) ? $this->prijsExclBtw : null;
    }
    /**
     * Set prijsExclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prijsExclBtw
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setPrijsExclBtw($prijsExclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($prijsExclBtw) && !(is_float($prijsExclBtw) || is_numeric($prijsExclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prijsExclBtw, true), gettype($prijsExclBtw)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($prijsExclBtw) && mb_strlen(preg_replace('/(\D)/', '', $prijsExclBtw)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($prijsExclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $prijsExclBtw))), __LINE__);
        }
        if (is_null($prijsExclBtw) || (is_array($prijsExclBtw) && empty($prijsExclBtw))) {
            unset($this->prijsExclBtw);
        } else {
            $this->prijsExclBtw = $prijsExclBtw;
        }
        return $this;
    }
    /**
     * Get prijsInclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrijsInclBtw()
    {
        return isset($this->prijsInclBtw) ? $this->prijsInclBtw : null;
    }
    /**
     * Set prijsInclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prijsInclBtw
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setPrijsInclBtw($prijsInclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($prijsInclBtw) && !(is_float($prijsInclBtw) || is_numeric($prijsInclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prijsInclBtw, true), gettype($prijsInclBtw)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($prijsInclBtw) && mb_strlen(mb_substr($prijsInclBtw, mb_strpos($prijsInclBtw, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($prijsInclBtw, true), mb_strlen(mb_substr($prijsInclBtw, mb_strpos($prijsInclBtw, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($prijsInclBtw) && mb_strlen(preg_replace('/(\D)/', '', $prijsInclBtw)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($prijsInclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $prijsInclBtw))), __LINE__);
        }
        if (is_null($prijsInclBtw) || (is_array($prijsInclBtw) && empty($prijsInclBtw))) {
            unset($this->prijsInclBtw);
        } else {
            $this->prijsInclBtw = $prijsInclBtw;
        }
        return $this;
    }
    /**
     * Get btwCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBtwCode()
    {
        return isset($this->btwCode) ? $this->btwCode : null;
    }
    /**
     * Set btwCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $btwCode
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setBtwCode($btwCode = null)
    {
        // validation for constraint: string
        if (!is_null($btwCode) && !is_string($btwCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($btwCode, true), gettype($btwCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($btwCode) && mb_strlen($btwCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($btwCode)), __LINE__);
        }
        if (is_null($btwCode) || (is_array($btwCode) && empty($btwCode))) {
            unset($this->btwCode);
        } else {
            $this->btwCode = $btwCode;
        }
        return $this;
    }
    /**
     * Get btwPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBtwPercentage()
    {
        return isset($this->btwPercentage) ? $this->btwPercentage : null;
    }
    /**
     * Set btwPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $btwPercentage
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setBtwPercentage($btwPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($btwPercentage) && !(is_float($btwPercentage) || is_numeric($btwPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($btwPercentage, true), gettype($btwPercentage)), __LINE__);
        }
        // validation for constraint: fractionDigits(1)
        if (!is_null($btwPercentage) && mb_strlen(mb_substr($btwPercentage, mb_strpos($btwPercentage, '.') + 1)) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 1 fraction digits, %d given', var_export($btwPercentage, true), mb_strlen(mb_substr($btwPercentage, mb_strpos($btwPercentage, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(16)
        if (!is_null($btwPercentage) && mb_strlen(preg_replace('/(\D)/', '', $btwPercentage)) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 16 digits, "%d" given', var_export($btwPercentage, true), mb_strlen(preg_replace('/(\D)/', '', $btwPercentage))), __LINE__);
        }
        if (is_null($btwPercentage) || (is_array($btwPercentage) && empty($btwPercentage))) {
            unset($this->btwPercentage);
        } else {
            $this->btwPercentage = $btwPercentage;
        }
        return $this;
    }
    /**
     * Get isbnNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIsbnNummer()
    {
        return isset($this->isbnNummer) ? $this->isbnNummer : null;
    }
    /**
     * Set isbnNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $isbnNummer
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setIsbnNummer($isbnNummer = null)
    {
        // validation for constraint: string
        if (!is_null($isbnNummer) && !is_string($isbnNummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isbnNummer, true), gettype($isbnNummer)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($isbnNummer) && mb_strlen($isbnNummer) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($isbnNummer)), __LINE__);
        }
        if (is_null($isbnNummer) || (is_array($isbnNummer) && empty($isbnNummer))) {
            unset($this->isbnNummer);
        } else {
            $this->isbnNummer = $isbnNummer;
        }
        return $this;
    }
    /**
     * Get geplandeVerschDatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeplandeVerschDatum()
    {
        return isset($this->geplandeVerschDatum) ? $this->geplandeVerschDatum : null;
    }
    /**
     * Set geplandeVerschDatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $geplandeVerschDatum
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setGeplandeVerschDatum($geplandeVerschDatum = null)
    {
        // validation for constraint: string
        if (!is_null($geplandeVerschDatum) && !is_string($geplandeVerschDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geplandeVerschDatum, true), gettype($geplandeVerschDatum)), __LINE__);
        }
        if (is_null($geplandeVerschDatum) || (is_array($geplandeVerschDatum) && empty($geplandeVerschDatum))) {
            unset($this->geplandeVerschDatum);
        } else {
            $this->geplandeVerschDatum = $geplandeVerschDatum;
        }
        return $this;
    }
    /**
     * Get leverbaarVanaf value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLeverbaarVanaf()
    {
        return isset($this->leverbaarVanaf) ? $this->leverbaarVanaf : null;
    }
    /**
     * Set leverbaarVanaf value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $leverbaarVanaf
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setLeverbaarVanaf($leverbaarVanaf = null)
    {
        // validation for constraint: string
        if (!is_null($leverbaarVanaf) && !is_string($leverbaarVanaf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leverbaarVanaf, true), gettype($leverbaarVanaf)), __LINE__);
        }
        if (is_null($leverbaarVanaf) || (is_array($leverbaarVanaf) && empty($leverbaarVanaf))) {
            unset($this->leverbaarVanaf);
        } else {
            $this->leverbaarVanaf = $leverbaarVanaf;
        }
        return $this;
    }
    /**
     * Get leverbaarTm value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLeverbaarTm()
    {
        return isset($this->leverbaarTm) ? $this->leverbaarTm : null;
    }
    /**
     * Set leverbaarTm value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $leverbaarTm
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setLeverbaarTm($leverbaarTm = null)
    {
        // validation for constraint: string
        if (!is_null($leverbaarTm) && !is_string($leverbaarTm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leverbaarTm, true), gettype($leverbaarTm)), __LINE__);
        }
        if (is_null($leverbaarTm) || (is_array($leverbaarTm) && empty($leverbaarTm))) {
            unset($this->leverbaarTm);
        } else {
            $this->leverbaarTm = $leverbaarTm;
        }
        return $this;
    }
    /**
     * Get omschrijving value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOmschrijving()
    {
        return isset($this->omschrijving) ? $this->omschrijving : null;
    }
    /**
     * Set omschrijving value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $omschrijving
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setOmschrijving($omschrijving = null)
    {
        // validation for constraint: string
        if (!is_null($omschrijving) && !is_string($omschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($omschrijving, true), gettype($omschrijving)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($omschrijving) && mb_strlen($omschrijving) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($omschrijving)), __LINE__);
        }
        if (is_null($omschrijving) || (is_array($omschrijving) && empty($omschrijving))) {
            unset($this->omschrijving);
        } else {
            $this->omschrijving = $omschrijving;
        }
        return $this;
    }
    /**
     * Get status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getStatus()
    {
        return isset($this->status) ? $this->status : null;
    }
    /**
     * Set status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $status
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setStatus($status = null)
    {
        // validation for constraint: float
        if (!is_null($status) && !(is_float($status) || is_numeric($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($status) && mb_strlen(preg_replace('/(\D)/', '', $status)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($status, true), mb_strlen(preg_replace('/(\D)/', '', $status))), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->status);
        } else {
            $this->status = $status;
        }
        return $this;
    }
    /**
     * Get verschijningsvorm value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \VoorraadApiV5\StructType\VerschijningsvormRecV5|null
     */
    public function getVerschijningsvorm()
    {
        return isset($this->verschijningsvorm) ? $this->verschijningsvorm : null;
    }
    /**
     * Set verschijningsvorm value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \VoorraadApiV5\StructType\VerschijningsvormRecV5 $verschijningsvorm
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setVerschijningsvorm(\VoorraadApiV5\StructType\VerschijningsvormRecV5 $verschijningsvorm = null)
    {
        if (is_null($verschijningsvorm) || (is_array($verschijningsvorm) && empty($verschijningsvorm))) {
            unset($this->verschijningsvorm);
        } else {
            $this->verschijningsvorm = $verschijningsvorm;
        }
        return $this;
    }
    /**
     * Get vrijeVelden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \VoorraadApiV5\StructType\ArtikelVrijeVeldenRecV5|null
     */
    public function getVrijeVelden()
    {
        return isset($this->vrijeVelden) ? $this->vrijeVelden : null;
    }
    /**
     * Set vrijeVelden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \VoorraadApiV5\StructType\ArtikelVrijeVeldenRecV5 $vrijeVelden
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setVrijeVelden(\VoorraadApiV5\StructType\ArtikelVrijeVeldenRecV5 $vrijeVelden = null)
    {
        if (is_null($vrijeVelden) || (is_array($vrijeVelden) && empty($vrijeVelden))) {
            unset($this->vrijeVelden);
        } else {
            $this->vrijeVelden = $vrijeVelden;
        }
        return $this;
    }
    /**
     * Get druk value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDruk()
    {
        return isset($this->druk) ? $this->druk : null;
    }
    /**
     * Set druk value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $druk
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setDruk($druk = null)
    {
        // validation for constraint: int
        if (!is_null($druk) && !(is_int($druk) || ctype_digit($druk))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($druk, true), gettype($druk)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($druk) && mb_strlen(preg_replace('/(\D)/', '', $druk)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($druk, true), mb_strlen(preg_replace('/(\D)/', '', $druk))), __LINE__);
        }
        if (is_null($druk) || (is_array($druk) && empty($druk))) {
            unset($this->druk);
        } else {
            $this->druk = $druk;
        }
        return $this;
    }
    /**
     * Get aantalPaginas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAantalPaginas()
    {
        return isset($this->aantalPaginas) ? $this->aantalPaginas : null;
    }
    /**
     * Set aantalPaginas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aantalPaginas
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setAantalPaginas($aantalPaginas = null)
    {
        // validation for constraint: int
        if (!is_null($aantalPaginas) && !(is_int($aantalPaginas) || ctype_digit($aantalPaginas))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aantalPaginas, true), gettype($aantalPaginas)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($aantalPaginas) && mb_strlen(preg_replace('/(\D)/', '', $aantalPaginas)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($aantalPaginas, true), mb_strlen(preg_replace('/(\D)/', '', $aantalPaginas))), __LINE__);
        }
        if (is_null($aantalPaginas) || (is_array($aantalPaginas) && empty($aantalPaginas))) {
            unset($this->aantalPaginas);
        } else {
            $this->aantalPaginas = $aantalPaginas;
        }
        return $this;
    }
    /**
     * Get subtitel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubtitel()
    {
        return isset($this->subtitel) ? $this->subtitel : null;
    }
    /**
     * Set subtitel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subtitel
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setSubtitel($subtitel = null)
    {
        // validation for constraint: string
        if (!is_null($subtitel) && !is_string($subtitel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subtitel, true), gettype($subtitel)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($subtitel) && mb_strlen($subtitel) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($subtitel)), __LINE__);
        }
        if (is_null($subtitel) || (is_array($subtitel) && empty($subtitel))) {
            unset($this->subtitel);
        } else {
            $this->subtitel = $subtitel;
        }
        return $this;
    }
    /**
     * Get hoogte value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getHoogte()
    {
        return isset($this->hoogte) ? $this->hoogte : null;
    }
    /**
     * Set hoogte value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $hoogte
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setHoogte($hoogte = null)
    {
        // validation for constraint: float
        if (!is_null($hoogte) && !(is_float($hoogte) || is_numeric($hoogte))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($hoogte, true), gettype($hoogte)), __LINE__);
        }
        // validation for constraint: fractionDigits(1)
        if (!is_null($hoogte) && mb_strlen(mb_substr($hoogte, mb_strpos($hoogte, '.') + 1)) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 1 fraction digits, %d given', var_export($hoogte, true), mb_strlen(mb_substr($hoogte, mb_strpos($hoogte, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(16)
        if (!is_null($hoogte) && mb_strlen(preg_replace('/(\D)/', '', $hoogte)) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 16 digits, "%d" given', var_export($hoogte, true), mb_strlen(preg_replace('/(\D)/', '', $hoogte))), __LINE__);
        }
        if (is_null($hoogte) || (is_array($hoogte) && empty($hoogte))) {
            unset($this->hoogte);
        } else {
            $this->hoogte = $hoogte;
        }
        return $this;
    }
    /**
     * Get breedte value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBreedte()
    {
        return isset($this->breedte) ? $this->breedte : null;
    }
    /**
     * Set breedte value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $breedte
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setBreedte($breedte = null)
    {
        // validation for constraint: float
        if (!is_null($breedte) && !(is_float($breedte) || is_numeric($breedte))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($breedte, true), gettype($breedte)), __LINE__);
        }
        // validation for constraint: fractionDigits(1)
        if (!is_null($breedte) && mb_strlen(mb_substr($breedte, mb_strpos($breedte, '.') + 1)) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 1 fraction digits, %d given', var_export($breedte, true), mb_strlen(mb_substr($breedte, mb_strpos($breedte, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(16)
        if (!is_null($breedte) && mb_strlen(preg_replace('/(\D)/', '', $breedte)) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 16 digits, "%d" given', var_export($breedte, true), mb_strlen(preg_replace('/(\D)/', '', $breedte))), __LINE__);
        }
        if (is_null($breedte) || (is_array($breedte) && empty($breedte))) {
            unset($this->breedte);
        } else {
            $this->breedte = $breedte;
        }
        return $this;
    }
    /**
     * Get dikte value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDikte()
    {
        return isset($this->dikte) ? $this->dikte : null;
    }
    /**
     * Set dikte value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $dikte
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setDikte($dikte = null)
    {
        // validation for constraint: float
        if (!is_null($dikte) && !(is_float($dikte) || is_numeric($dikte))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dikte, true), gettype($dikte)), __LINE__);
        }
        // validation for constraint: fractionDigits(1)
        if (!is_null($dikte) && mb_strlen(mb_substr($dikte, mb_strpos($dikte, '.') + 1)) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 1 fraction digits, %d given', var_export($dikte, true), mb_strlen(mb_substr($dikte, mb_strpos($dikte, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(16)
        if (!is_null($dikte) && mb_strlen(preg_replace('/(\D)/', '', $dikte)) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 16 digits, "%d" given', var_export($dikte, true), mb_strlen(preg_replace('/(\D)/', '', $dikte))), __LINE__);
        }
        if (is_null($dikte) || (is_array($dikte) && empty($dikte))) {
            unset($this->dikte);
        } else {
            $this->dikte = $dikte;
        }
        return $this;
    }
    /**
     * Get gewicht value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getGewicht()
    {
        return isset($this->gewicht) ? $this->gewicht : null;
    }
    /**
     * Set gewicht value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $gewicht
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setGewicht($gewicht = null)
    {
        // validation for constraint: float
        if (!is_null($gewicht) && !(is_float($gewicht) || is_numeric($gewicht))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gewicht, true), gettype($gewicht)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($gewicht) && mb_strlen(preg_replace('/(\D)/', '', $gewicht)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($gewicht, true), mb_strlen(preg_replace('/(\D)/', '', $gewicht))), __LINE__);
        }
        if (is_null($gewicht) || (is_array($gewicht) && empty($gewicht))) {
            unset($this->gewicht);
        } else {
            $this->gewicht = $gewicht;
        }
        return $this;
    }
    /**
     * Get pod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPod()
    {
        return isset($this->pod) ? $this->pod : null;
    }
    /**
     * Set pod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $pod
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setPod($pod = null)
    {
        // validation for constraint: boolean
        if (!is_null($pod) && !is_bool($pod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pod, true), gettype($pod)), __LINE__);
        }
        if (is_null($pod) || (is_array($pod) && empty($pod))) {
            unset($this->pod);
        } else {
            $this->pod = $pod;
        }
        return $this;
    }
    /**
     * Get fondsCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFondsCode()
    {
        return isset($this->fondsCode) ? $this->fondsCode : null;
    }
    /**
     * Set fondsCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fondsCode
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setFondsCode($fondsCode = null)
    {
        // validation for constraint: string
        if (!is_null($fondsCode) && !is_string($fondsCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fondsCode, true), gettype($fondsCode)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($fondsCode) && mb_strlen($fondsCode) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($fondsCode)), __LINE__);
        }
        if (is_null($fondsCode) || (is_array($fondsCode) && empty($fondsCode))) {
            unset($this->fondsCode);
        } else {
            $this->fondsCode = $fondsCode;
        }
        return $this;
    }
    /**
     * Get fondsNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFondsNaam()
    {
        return isset($this->fondsNaam) ? $this->fondsNaam : null;
    }
    /**
     * Set fondsNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fondsNaam
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setFondsNaam($fondsNaam = null)
    {
        // validation for constraint: string
        if (!is_null($fondsNaam) && !is_string($fondsNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fondsNaam, true), gettype($fondsNaam)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($fondsNaam) && mb_strlen($fondsNaam) > 200) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen($fondsNaam)), __LINE__);
        }
        if (is_null($fondsNaam) || (is_array($fondsNaam) && empty($fondsNaam))) {
            unset($this->fondsNaam);
        } else {
            $this->fondsNaam = $fondsNaam;
        }
        return $this;
    }
    /**
     * Get aanleveringCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAanleveringCode()
    {
        return isset($this->aanleveringCode) ? $this->aanleveringCode : null;
    }
    /**
     * Set aanleveringCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aanleveringCode
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setAanleveringCode($aanleveringCode = null)
    {
        // validation for constraint: string
        if (!is_null($aanleveringCode) && !is_string($aanleveringCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aanleveringCode, true), gettype($aanleveringCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($aanleveringCode) && mb_strlen($aanleveringCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($aanleveringCode)), __LINE__);
        }
        if (is_null($aanleveringCode) || (is_array($aanleveringCode) && empty($aanleveringCode))) {
            unset($this->aanleveringCode);
        } else {
            $this->aanleveringCode = $aanleveringCode;
        }
        return $this;
    }
    /**
     * Get aanleveringNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAanleveringNaam()
    {
        return isset($this->aanleveringNaam) ? $this->aanleveringNaam : null;
    }
    /**
     * Set aanleveringNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aanleveringNaam
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setAanleveringNaam($aanleveringNaam = null)
    {
        // validation for constraint: string
        if (!is_null($aanleveringNaam) && !is_string($aanleveringNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aanleveringNaam, true), gettype($aanleveringNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($aanleveringNaam) && mb_strlen($aanleveringNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($aanleveringNaam)), __LINE__);
        }
        if (is_null($aanleveringNaam) || (is_array($aanleveringNaam) && empty($aanleveringNaam))) {
            unset($this->aanleveringNaam);
        } else {
            $this->aanleveringNaam = $aanleveringNaam;
        }
        return $this;
    }
    /**
     * Get serieCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSerieCode()
    {
        return isset($this->serieCode) ? $this->serieCode : null;
    }
    /**
     * Set serieCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serieCode
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setSerieCode($serieCode = null)
    {
        // validation for constraint: string
        if (!is_null($serieCode) && !is_string($serieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serieCode, true), gettype($serieCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($serieCode) && mb_strlen($serieCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($serieCode)), __LINE__);
        }
        if (is_null($serieCode) || (is_array($serieCode) && empty($serieCode))) {
            unset($this->serieCode);
        } else {
            $this->serieCode = $serieCode;
        }
        return $this;
    }
    /**
     * Get serieNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSerieNaam()
    {
        return isset($this->serieNaam) ? $this->serieNaam : null;
    }
    /**
     * Set serieNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serieNaam
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setSerieNaam($serieNaam = null)
    {
        // validation for constraint: string
        if (!is_null($serieNaam) && !is_string($serieNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serieNaam, true), gettype($serieNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($serieNaam) && mb_strlen($serieNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($serieNaam)), __LINE__);
        }
        if (is_null($serieNaam) || (is_array($serieNaam) && empty($serieNaam))) {
            unset($this->serieNaam);
        } else {
            $this->serieNaam = $serieNaam;
        }
        return $this;
    }
    /**
     * Get taalCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaalCode()
    {
        return isset($this->taalCode) ? $this->taalCode : null;
    }
    /**
     * Set taalCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taalCode
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setTaalCode($taalCode = null)
    {
        // validation for constraint: string
        if (!is_null($taalCode) && !is_string($taalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taalCode, true), gettype($taalCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($taalCode) && mb_strlen($taalCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($taalCode)), __LINE__);
        }
        if (is_null($taalCode) || (is_array($taalCode) && empty($taalCode))) {
            unset($this->taalCode);
        } else {
            $this->taalCode = $taalCode;
        }
        return $this;
    }
    /**
     * Get auteurs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \VoorraadApiV5\StructType\RechthebbendeTableV5|null
     */
    public function getAuteurs()
    {
        return isset($this->auteurs) ? $this->auteurs : null;
    }
    /**
     * Set auteurs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \VoorraadApiV5\StructType\RechthebbendeTableV5 $auteurs
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setAuteurs(\VoorraadApiV5\StructType\RechthebbendeTableV5 $auteurs = null)
    {
        if (is_null($auteurs) || (is_array($auteurs) && empty($auteurs))) {
            unset($this->auteurs);
        } else {
            $this->auteurs = $auteurs;
        }
        return $this;
    }
    /**
     * Get vertalers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \VoorraadApiV5\StructType\RechthebbendeTableV5|null
     */
    public function getVertalers()
    {
        return isset($this->vertalers) ? $this->vertalers : null;
    }
    /**
     * Set vertalers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \VoorraadApiV5\StructType\RechthebbendeTableV5 $vertalers
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setVertalers(\VoorraadApiV5\StructType\RechthebbendeTableV5 $vertalers = null)
    {
        if (is_null($vertalers) || (is_array($vertalers) && empty($vertalers))) {
            unset($this->vertalers);
        } else {
            $this->vertalers = $vertalers;
        }
        return $this;
    }
    /**
     * Get illustrators value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \VoorraadApiV5\StructType\RechthebbendeTableV5|null
     */
    public function getIllustrators()
    {
        return isset($this->illustrators) ? $this->illustrators : null;
    }
    /**
     * Set illustrators value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \VoorraadApiV5\StructType\RechthebbendeTableV5 $illustrators
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setIllustrators(\VoorraadApiV5\StructType\RechthebbendeTableV5 $illustrators = null)
    {
        if (is_null($illustrators) || (is_array($illustrators) && empty($illustrators))) {
            unset($this->illustrators);
        } else {
            $this->illustrators = $illustrators;
        }
        return $this;
    }
    /**
     * Get redacteuren value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \VoorraadApiV5\StructType\RechthebbendeTableV5|null
     */
    public function getRedacteuren()
    {
        return isset($this->redacteuren) ? $this->redacteuren : null;
    }
    /**
     * Set redacteuren value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \VoorraadApiV5\StructType\RechthebbendeTableV5 $redacteuren
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setRedacteuren(\VoorraadApiV5\StructType\RechthebbendeTableV5 $redacteuren = null)
    {
        if (is_null($redacteuren) || (is_array($redacteuren) && empty($redacteuren))) {
            unset($this->redacteuren);
        } else {
            $this->redacteuren = $redacteuren;
        }
        return $this;
    }
    /**
     * Get link value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLink()
    {
        return isset($this->link) ? $this->link : null;
    }
    /**
     * Set link value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $link
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setLink($link = null)
    {
        // validation for constraint: string
        if (!is_null($link) && !is_string($link)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($link, true), gettype($link)), __LINE__);
        }
        // validation for constraint: maxLength(250)
        if (!is_null($link) && mb_strlen($link) > 250) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 250', mb_strlen($link)), __LINE__);
        }
        if (is_null($link) || (is_array($link) && empty($link))) {
            unset($this->link);
        } else {
            $this->link = $link;
        }
        return $this;
    }
    /**
     * Get korteInhoud value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKorteInhoud()
    {
        return isset($this->korteInhoud) ? $this->korteInhoud : null;
    }
    /**
     * Set korteInhoud value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $korteInhoud
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setKorteInhoud($korteInhoud = null)
    {
        // validation for constraint: string
        if (!is_null($korteInhoud) && !is_string($korteInhoud)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($korteInhoud, true), gettype($korteInhoud)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($korteInhoud) && mb_strlen($korteInhoud) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($korteInhoud)), __LINE__);
        }
        if (is_null($korteInhoud) || (is_array($korteInhoud) && empty($korteInhoud))) {
            unset($this->korteInhoud);
        } else {
            $this->korteInhoud = $korteInhoud;
        }
        return $this;
    }
    /**
     * Get eigenaarRelatieNr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getEigenaarRelatieNr()
    {
        return isset($this->eigenaarRelatieNr) ? $this->eigenaarRelatieNr : null;
    }
    /**
     * Set eigenaarRelatieNr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $eigenaarRelatieNr
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setEigenaarRelatieNr($eigenaarRelatieNr = null)
    {
        // validation for constraint: float
        if (!is_null($eigenaarRelatieNr) && !(is_float($eigenaarRelatieNr) || is_numeric($eigenaarRelatieNr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($eigenaarRelatieNr, true), gettype($eigenaarRelatieNr)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($eigenaarRelatieNr) && mb_strlen(preg_replace('/(\D)/', '', $eigenaarRelatieNr)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($eigenaarRelatieNr, true), mb_strlen(preg_replace('/(\D)/', '', $eigenaarRelatieNr))), __LINE__);
        }
        if (is_null($eigenaarRelatieNr) || (is_array($eigenaarRelatieNr) && empty($eigenaarRelatieNr))) {
            unset($this->eigenaarRelatieNr);
        } else {
            $this->eigenaarRelatieNr = $eigenaarRelatieNr;
        }
        return $this;
    }
    /**
     * Get eigenaarNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEigenaarNaam()
    {
        return isset($this->eigenaarNaam) ? $this->eigenaarNaam : null;
    }
    /**
     * Set eigenaarNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eigenaarNaam
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setEigenaarNaam($eigenaarNaam = null)
    {
        // validation for constraint: string
        if (!is_null($eigenaarNaam) && !is_string($eigenaarNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eigenaarNaam, true), gettype($eigenaarNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($eigenaarNaam) && mb_strlen($eigenaarNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($eigenaarNaam)), __LINE__);
        }
        if (is_null($eigenaarNaam) || (is_array($eigenaarNaam) && empty($eigenaarNaam))) {
            unset($this->eigenaarNaam);
        } else {
            $this->eigenaarNaam = $eigenaarNaam;
        }
        return $this;
    }
    /**
     * Get volgArtikel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getVolgArtikel()
    {
        return isset($this->volgArtikel) ? $this->volgArtikel : null;
    }
    /**
     * Set volgArtikel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $volgArtikel
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setVolgArtikel($volgArtikel = null)
    {
        // validation for constraint: float
        if (!is_null($volgArtikel) && !(is_float($volgArtikel) || is_numeric($volgArtikel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($volgArtikel, true), gettype($volgArtikel)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($volgArtikel) && mb_strlen(preg_replace('/(\D)/', '', $volgArtikel)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($volgArtikel, true), mb_strlen(preg_replace('/(\D)/', '', $volgArtikel))), __LINE__);
        }
        if (is_null($volgArtikel) || (is_array($volgArtikel) && empty($volgArtikel))) {
            unset($this->volgArtikel);
        } else {
            $this->volgArtikel = $volgArtikel;
        }
        return $this;
    }
    /**
     * Get projectCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProjectCode()
    {
        return isset($this->projectCode) ? $this->projectCode : null;
    }
    /**
     * Set projectCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $projectCode
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setProjectCode($projectCode = null)
    {
        // validation for constraint: string
        if (!is_null($projectCode) && !is_string($projectCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($projectCode, true), gettype($projectCode)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($projectCode) && mb_strlen($projectCode) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($projectCode)), __LINE__);
        }
        if (is_null($projectCode) || (is_array($projectCode) && empty($projectCode))) {
            unset($this->projectCode);
        } else {
            $this->projectCode = $projectCode;
        }
        return $this;
    }
    /**
     * Get projectNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProjectNaam()
    {
        return isset($this->projectNaam) ? $this->projectNaam : null;
    }
    /**
     * Set projectNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $projectNaam
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setProjectNaam($projectNaam = null)
    {
        // validation for constraint: string
        if (!is_null($projectNaam) && !is_string($projectNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($projectNaam, true), gettype($projectNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($projectNaam) && mb_strlen($projectNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($projectNaam)), __LINE__);
        }
        if (is_null($projectNaam) || (is_array($projectNaam) && empty($projectNaam))) {
            unset($this->projectNaam);
        } else {
            $this->projectNaam = $projectNaam;
        }
        return $this;
    }
    /**
     * Get werkTitel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWerkTitel()
    {
        return isset($this->werkTitel) ? $this->werkTitel : null;
    }
    /**
     * Set werkTitel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $werkTitel
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setWerkTitel($werkTitel = null)
    {
        // validation for constraint: string
        if (!is_null($werkTitel) && !is_string($werkTitel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($werkTitel, true), gettype($werkTitel)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($werkTitel) && mb_strlen($werkTitel) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($werkTitel)), __LINE__);
        }
        if (is_null($werkTitel) || (is_array($werkTitel) && empty($werkTitel))) {
            unset($this->werkTitel);
        } else {
            $this->werkTitel = $werkTitel;
        }
        return $this;
    }
    /**
     * Get afwerkingCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAfwerkingCode()
    {
        return isset($this->afwerkingCode) ? $this->afwerkingCode : null;
    }
    /**
     * Set afwerkingCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $afwerkingCode
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setAfwerkingCode($afwerkingCode = null)
    {
        // validation for constraint: string
        if (!is_null($afwerkingCode) && !is_string($afwerkingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($afwerkingCode, true), gettype($afwerkingCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($afwerkingCode) && mb_strlen($afwerkingCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($afwerkingCode)), __LINE__);
        }
        if (is_null($afwerkingCode) || (is_array($afwerkingCode) && empty($afwerkingCode))) {
            unset($this->afwerkingCode);
        } else {
            $this->afwerkingCode = $afwerkingCode;
        }
        return $this;
    }
    /**
     * Get afwerkingNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAfwerkingNaam()
    {
        return isset($this->afwerkingNaam) ? $this->afwerkingNaam : null;
    }
    /**
     * Set afwerkingNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $afwerkingNaam
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setAfwerkingNaam($afwerkingNaam = null)
    {
        // validation for constraint: string
        if (!is_null($afwerkingNaam) && !is_string($afwerkingNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($afwerkingNaam, true), gettype($afwerkingNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($afwerkingNaam) && mb_strlen($afwerkingNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($afwerkingNaam)), __LINE__);
        }
        if (is_null($afwerkingNaam) || (is_array($afwerkingNaam) && empty($afwerkingNaam))) {
            unset($this->afwerkingNaam);
        } else {
            $this->afwerkingNaam = $afwerkingNaam;
        }
        return $this;
    }
    /**
     * Get gelamineerdCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGelamineerdCode()
    {
        return isset($this->gelamineerdCode) ? $this->gelamineerdCode : null;
    }
    /**
     * Set gelamineerdCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gelamineerdCode
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setGelamineerdCode($gelamineerdCode = null)
    {
        // validation for constraint: string
        if (!is_null($gelamineerdCode) && !is_string($gelamineerdCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gelamineerdCode, true), gettype($gelamineerdCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($gelamineerdCode) && mb_strlen($gelamineerdCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($gelamineerdCode)), __LINE__);
        }
        if (is_null($gelamineerdCode) || (is_array($gelamineerdCode) && empty($gelamineerdCode))) {
            unset($this->gelamineerdCode);
        } else {
            $this->gelamineerdCode = $gelamineerdCode;
        }
        return $this;
    }
    /**
     * Get gelamineerdNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGelamineerdNaam()
    {
        return isset($this->gelamineerdNaam) ? $this->gelamineerdNaam : null;
    }
    /**
     * Set gelamineerdNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gelamineerdNaam
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setGelamineerdNaam($gelamineerdNaam = null)
    {
        // validation for constraint: string
        if (!is_null($gelamineerdNaam) && !is_string($gelamineerdNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gelamineerdNaam, true), gettype($gelamineerdNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($gelamineerdNaam) && mb_strlen($gelamineerdNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($gelamineerdNaam)), __LINE__);
        }
        if (is_null($gelamineerdNaam) || (is_array($gelamineerdNaam) && empty($gelamineerdNaam))) {
            unset($this->gelamineerdNaam);
        } else {
            $this->gelamineerdNaam = $gelamineerdNaam;
        }
        return $this;
    }
    /**
     * Get illustraties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIllustraties()
    {
        return isset($this->illustraties) ? $this->illustraties : null;
    }
    /**
     * Set illustraties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $illustraties
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setIllustraties($illustraties = null)
    {
        // validation for constraint: string
        if (!is_null($illustraties) && !is_string($illustraties)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($illustraties, true), gettype($illustraties)), __LINE__);
        }
        // validation for constraint: maxLength(1000)
        if (!is_null($illustraties) && mb_strlen($illustraties) > 1000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1000', mb_strlen($illustraties)), __LINE__);
        }
        if (is_null($illustraties) || (is_array($illustraties) && empty($illustraties))) {
            unset($this->illustraties);
        } else {
            $this->illustraties = $illustraties;
        }
        return $this;
    }
    /**
     * Get coderingen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \VoorraadApiV5\StructType\PublicatieCoderingenTableV5|null
     */
    public function getCoderingen()
    {
        return isset($this->coderingen) ? $this->coderingen : null;
    }
    /**
     * Set coderingen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \VoorraadApiV5\StructType\PublicatieCoderingenTableV5 $coderingen
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setCoderingen(\VoorraadApiV5\StructType\PublicatieCoderingenTableV5 $coderingen = null)
    {
        if (is_null($coderingen) || (is_array($coderingen) && empty($coderingen))) {
            unset($this->coderingen);
        } else {
            $this->coderingen = $coderingen;
        }
        return $this;
    }
    /**
     * Get prijzen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \VoorraadApiV5\StructType\ArtikelPrijzenTableV5|null
     */
    public function getPrijzen()
    {
        return isset($this->prijzen) ? $this->prijzen : null;
    }
    /**
     * Set prijzen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \VoorraadApiV5\StructType\ArtikelPrijzenTableV5 $prijzen
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setPrijzen(\VoorraadApiV5\StructType\ArtikelPrijzenTableV5 $prijzen = null)
    {
        if (is_null($prijzen) || (is_array($prijzen) && empty($prijzen))) {
            unset($this->prijzen);
        } else {
            $this->prijzen = $prijzen;
        }
        return $this;
    }
    /**
     * Get staffels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \VoorraadApiV5\StructType\ArtikelStaffelTableV5|null
     */
    public function getStaffels()
    {
        return isset($this->staffels) ? $this->staffels : null;
    }
    /**
     * Set staffels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \VoorraadApiV5\StructType\ArtikelStaffelTableV5 $staffels
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setStaffels(\VoorraadApiV5\StructType\ArtikelStaffelTableV5 $staffels = null)
    {
        if (is_null($staffels) || (is_array($staffels) && empty($staffels))) {
            unset($this->staffels);
        } else {
            $this->staffels = $staffels;
        }
        return $this;
    }
    /**
     * Get actie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getActie()
    {
        return isset($this->actie) ? $this->actie : null;
    }
    /**
     * Set actie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $actie
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setActie($actie = null)
    {
        // validation for constraint: boolean
        if (!is_null($actie) && !is_bool($actie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($actie, true), gettype($actie)), __LINE__);
        }
        if (is_null($actie) || (is_array($actie) && empty($actie))) {
            unset($this->actie);
        } else {
            $this->actie = $actie;
        }
        return $this;
    }
    /**
     * Get artikelSamenstelling value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \VoorraadApiV5\StructType\ArtikelSamenstellingTableV5|null
     */
    public function getArtikelSamenstelling()
    {
        return isset($this->artikelSamenstelling) ? $this->artikelSamenstelling : null;
    }
    /**
     * Set artikelSamenstelling value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \VoorraadApiV5\StructType\ArtikelSamenstellingTableV5 $artikelSamenstelling
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setArtikelSamenstelling(\VoorraadApiV5\StructType\ArtikelSamenstellingTableV5 $artikelSamenstelling = null)
    {
        if (is_null($artikelSamenstelling) || (is_array($artikelSamenstelling) && empty($artikelSamenstelling))) {
            unset($this->artikelSamenstelling);
        } else {
            $this->artikelSamenstelling = $artikelSamenstelling;
        }
        return $this;
    }
    /**
     * Get fysiek value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getFysiek()
    {
        return isset($this->fysiek) ? $this->fysiek : null;
    }
    /**
     * Set fysiek value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $fysiek
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setFysiek($fysiek = null)
    {
        // validation for constraint: boolean
        if (!is_null($fysiek) && !is_bool($fysiek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fysiek, true), gettype($fysiek)), __LINE__);
        }
        if (is_null($fysiek) || (is_array($fysiek) && empty($fysiek))) {
            unset($this->fysiek);
        } else {
            $this->fysiek = $fysiek;
        }
        return $this;
    }
    /**
     * Get opIsOp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOpIsOp()
    {
        return isset($this->opIsOp) ? $this->opIsOp : null;
    }
    /**
     * Set opIsOp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $opIsOp
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public function setOpIsOp($opIsOp = null)
    {
        // validation for constraint: boolean
        if (!is_null($opIsOp) && !is_bool($opIsOp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($opIsOp, true), gettype($opIsOp)), __LINE__);
        }
        if (is_null($opIsOp) || (is_array($opIsOp) && empty($opIsOp))) {
            unset($this->opIsOp);
        } else {
            $this->opIsOp = $opIsOp;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
