<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerkooporderregelLevRecV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Leveranties behorende bij een verkooporder
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class VerkooporderregelLevRecV5 extends AbstractStructBase
{
    /**
     * The leverantieNummer
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van de leverantie waarin de orderregel geleverd is
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $leverantieNummer;
    /**
     * The datum
     * Meta informations extracted from the WSDL
     * - documentation: Datum van de leverantie
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $datum;
    /**
     * The aantal
     * Meta informations extracted from the WSDL
     * - documentation: Geleverd aantal
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $aantal;
    /**
     * The trackAndTrace
     * Meta informations extracted from the WSDL
     * - documentation: Track and trace code, indien beschikbaar
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $trackAndTrace;
    /**
     * Constructor method for VerkooporderregelLevRecV5
     * @uses VerkooporderregelLevRecV5::setLeverantieNummer()
     * @uses VerkooporderregelLevRecV5::setDatum()
     * @uses VerkooporderregelLevRecV5::setAantal()
     * @uses VerkooporderregelLevRecV5::setTrackAndTrace()
     * @param int $leverantieNummer
     * @param string $datum
     * @param float $aantal
     * @param string $trackAndTrace
     */
    public function __construct($leverantieNummer = null, $datum = null, $aantal = null, $trackAndTrace = null)
    {
        $this
            ->setLeverantieNummer($leverantieNummer)
            ->setDatum($datum)
            ->setAantal($aantal)
            ->setTrackAndTrace($trackAndTrace);
    }
    /**
     * Get leverantieNummer value
     * @return int
     */
    public function getLeverantieNummer()
    {
        return $this->leverantieNummer;
    }
    /**
     * Set leverantieNummer value
     * @param int $leverantieNummer
     * @return \VoorraadApiV5\StructType\VerkooporderregelLevRecV5
     */
    public function setLeverantieNummer($leverantieNummer = null)
    {
        // validation for constraint: int
        if (!is_null($leverantieNummer) && !(is_int($leverantieNummer) || ctype_digit($leverantieNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($leverantieNummer, true), gettype($leverantieNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($leverantieNummer) && mb_strlen(preg_replace('/(\D)/', '', $leverantieNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($leverantieNummer, true), mb_strlen(preg_replace('/(\D)/', '', $leverantieNummer))), __LINE__);
        }
        $this->leverantieNummer = $leverantieNummer;
        return $this;
    }
    /**
     * Get datum value
     * @return string
     */
    public function getDatum()
    {
        return $this->datum;
    }
    /**
     * Set datum value
     * @param string $datum
     * @return \VoorraadApiV5\StructType\VerkooporderregelLevRecV5
     */
    public function setDatum($datum = null)
    {
        // validation for constraint: string
        if (!is_null($datum) && !is_string($datum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datum, true), gettype($datum)), __LINE__);
        }
        $this->datum = $datum;
        return $this;
    }
    /**
     * Get aantal value
     * @return float
     */
    public function getAantal()
    {
        return $this->aantal;
    }
    /**
     * Set aantal value
     * @param float $aantal
     * @return \VoorraadApiV5\StructType\VerkooporderregelLevRecV5
     */
    public function setAantal($aantal = null)
    {
        // validation for constraint: float
        if (!is_null($aantal) && !(is_float($aantal) || is_numeric($aantal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aantal, true), gettype($aantal)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($aantal) && mb_strlen(preg_replace('/(\D)/', '', $aantal)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($aantal, true), mb_strlen(preg_replace('/(\D)/', '', $aantal))), __LINE__);
        }
        $this->aantal = $aantal;
        return $this;
    }
    /**
     * Get trackAndTrace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrackAndTrace()
    {
        return isset($this->trackAndTrace) ? $this->trackAndTrace : null;
    }
    /**
     * Set trackAndTrace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trackAndTrace
     * @return \VoorraadApiV5\StructType\VerkooporderregelLevRecV5
     */
    public function setTrackAndTrace($trackAndTrace = null)
    {
        // validation for constraint: string
        if (!is_null($trackAndTrace) && !is_string($trackAndTrace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackAndTrace, true), gettype($trackAndTrace)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($trackAndTrace) && mb_strlen($trackAndTrace) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($trackAndTrace)), __LINE__);
        }
        if (is_null($trackAndTrace) || (is_array($trackAndTrace) && empty($trackAndTrace))) {
            unset($this->trackAndTrace);
        } else {
            $this->trackAndTrace = $trackAndTrace;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\VerkooporderregelLevRecV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
