<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerkooporderregelInfoTabV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met orderregels in een order
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class VerkooporderregelInfoTabV5 extends AbstractStructBase
{
    /**
     * The orderregel
     * Meta informations extracted from the WSDL
     * - documentation: verkooporderregel
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - nillable: false
     * @var \VoorraadApiV5\StructType\VerkooporderregelInfoRecV5[]
     */
    public $orderregel;
    /**
     * Constructor method for VerkooporderregelInfoTabV5
     * @uses VerkooporderregelInfoTabV5::setOrderregel()
     * @param \VoorraadApiV5\StructType\VerkooporderregelInfoRecV5[] $orderregel
     */
    public function __construct(array $orderregel = array())
    {
        $this
            ->setOrderregel($orderregel);
    }
    /**
     * Get orderregel value
     * @return \VoorraadApiV5\StructType\VerkooporderregelInfoRecV5[]
     */
    public function getOrderregel()
    {
        return $this->orderregel;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderregel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderregel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderregelForArrayConstraintsFromSetOrderregel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $verkooporderregelInfoTabV5OrderregelItem) {
            // validation for constraint: itemType
            if (!$verkooporderregelInfoTabV5OrderregelItem instanceof \VoorraadApiV5\StructType\VerkooporderregelInfoRecV5) {
                $invalidValues[] = is_object($verkooporderregelInfoTabV5OrderregelItem) ? get_class($verkooporderregelInfoTabV5OrderregelItem) : sprintf('%s(%s)', gettype($verkooporderregelInfoTabV5OrderregelItem), var_export($verkooporderregelInfoTabV5OrderregelItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The orderregel property can only contain items of type \VoorraadApiV5\StructType\VerkooporderregelInfoRecV5, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set orderregel value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\VerkooporderregelInfoRecV5[] $orderregel
     * @return \VoorraadApiV5\StructType\VerkooporderregelInfoTabV5
     */
    public function setOrderregel(array $orderregel = array())
    {
        // validation for constraint: array
        if ('' !== ($orderregelArrayErrorMessage = self::validateOrderregelForArrayConstraintsFromSetOrderregel($orderregel))) {
            throw new \InvalidArgumentException($orderregelArrayErrorMessage, __LINE__);
        }
        $this->orderregel = $orderregel;
        return $this;
    }
    /**
     * Add item to orderregel value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\VerkooporderregelInfoRecV5 $item
     * @return \VoorraadApiV5\StructType\VerkooporderregelInfoTabV5
     */
    public function addToOrderregel(\VoorraadApiV5\StructType\VerkooporderregelInfoRecV5 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \VoorraadApiV5\StructType\VerkooporderregelInfoRecV5) {
            throw new \InvalidArgumentException(sprintf('The orderregel property can only contain items of type \VoorraadApiV5\StructType\VerkooporderregelInfoRecV5, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->orderregel[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\VerkooporderregelInfoTabV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
