<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerkooporderregelInfoRecV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Informatie van een regel binnen een verkooporder
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class VerkooporderregelInfoRecV5 extends AbstractStructBase
{
    /**
     * The artikelNummer
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van het bestelde artikel
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $artikelNummer;
    /**
     * The besteldAantal
     * Meta informations extracted from the WSDL
     * - documentation: Aantal artikelen dat besteld is
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $besteldAantal;
    /**
     * The bedragPerStukExclBtw
     * Meta informations extracted from the WSDL
     * - documentation: Bruto bedrag per stuk excl. BTW voor de orderregel
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $bedragPerStukExclBtw;
    /**
     * The bedragExclBtw
     * Meta informations extracted from the WSDL
     * - documentation: Bruto bedrag excl. BTW voor de orderregel
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $bedragExclBtw;
    /**
     * The geannuleerd
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie die aangeeft of de orderregel geannuleerd is
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var bool
     */
    public $geannuleerd;
    /**
     * The kortingBedragExclBtw
     * Meta informations extracted from the WSDL
     * - documentation: Bedrag aan korting excl. BTW
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $kortingBedragExclBtw;
    /**
     * The kortingPercentage
     * Meta informations extracted from the WSDL
     * - documentation: Kortingspercentage (=korting_bedrag/bedrag)*100
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $kortingPercentage;
    /**
     * The kortingStaffelExclBtw
     * Meta informations extracted from the WSDL
     * - documentation: Kortingsbedrag volgens staffelkaart excl. BTW
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $kortingStaffelExclBtw;
    /**
     * The kortingStaffelPercentage
     * Meta informations extracted from the WSDL
     * - documentation: Percentage korting volgens staffelkaart
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $kortingStaffelPercentage;
    /**
     * The kortingPrijsmatrixExclBtw
     * Meta informations extracted from the WSDL
     * - documentation: Kortingsbedrag volgens prijsmatrix excl. BTW
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $kortingPrijsmatrixExclBtw;
    /**
     * The kortingPrijsmatrixPercentage
     * Meta informations extracted from the WSDL
     * - documentation: Percentage korting volgens prijsmatrix
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $kortingPrijsmatrixPercentage;
    /**
     * The kortingPrijsmatrixOmschr
     * Meta informations extracted from the WSDL
     * - documentation: Omschrijving volgens de prijsmatrix
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $kortingPrijsmatrixOmschr;
    /**
     * The kortingOrdersoortExclBtw
     * Meta informations extracted from the WSDL
     * - documentation: Korting volgens ordersoort excl. BTW
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $kortingOrdersoortExclBtw;
    /**
     * The kortingOrdersoortPercentage
     * Meta informations extracted from the WSDL
     * - documentation: Percentage korting volgens ordersoort
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $kortingOrdersoortPercentage;
    /**
     * The kortingOrdersoortOmschr
     * Meta informations extracted from the WSDL
     * - documentation: Omschrijving ordersoort
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $kortingOrdersoortOmschr;
    /**
     * The totaalExclBtw
     * Meta informations extracted from the WSDL
     * - documentation: Totaalbedrag orderregel excl. BTW
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $totaalExclBtw;
    /**
     * The totaalInclBtw
     * Meta informations extracted from the WSDL
     * - documentation: Totaalbedrag orderregel incl. BTW
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $totaalInclBtw;
    /**
     * The magazijn
     * Meta informations extracted from the WSDL
     * - documentation: Het magazijn waaruit het artikel geleverd wordt
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \VoorraadApiV5\StructType\MagazijnRecV5
     */
    public $magazijn;
    /**
     * The toelichting
     * Meta informations extracted from the WSDL
     * - documentation: Aanvullende toelichting, kan evt. op een pakbon of factuur geprint worden
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $toelichting;
    /**
     * The leveringen
     * Meta informations extracted from the WSDL
     * - documentation: Informatie over leveringen van de orderregel
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \VoorraadApiV5\StructType\VerkooporderregelLevTabV5
     */
    public $leveringen;
    /**
     * Constructor method for VerkooporderregelInfoRecV5
     * @uses VerkooporderregelInfoRecV5::setArtikelNummer()
     * @uses VerkooporderregelInfoRecV5::setBesteldAantal()
     * @uses VerkooporderregelInfoRecV5::setBedragPerStukExclBtw()
     * @uses VerkooporderregelInfoRecV5::setBedragExclBtw()
     * @uses VerkooporderregelInfoRecV5::setGeannuleerd()
     * @uses VerkooporderregelInfoRecV5::setKortingBedragExclBtw()
     * @uses VerkooporderregelInfoRecV5::setKortingPercentage()
     * @uses VerkooporderregelInfoRecV5::setKortingStaffelExclBtw()
     * @uses VerkooporderregelInfoRecV5::setKortingStaffelPercentage()
     * @uses VerkooporderregelInfoRecV5::setKortingPrijsmatrixExclBtw()
     * @uses VerkooporderregelInfoRecV5::setKortingPrijsmatrixPercentage()
     * @uses VerkooporderregelInfoRecV5::setKortingPrijsmatrixOmschr()
     * @uses VerkooporderregelInfoRecV5::setKortingOrdersoortExclBtw()
     * @uses VerkooporderregelInfoRecV5::setKortingOrdersoortPercentage()
     * @uses VerkooporderregelInfoRecV5::setKortingOrdersoortOmschr()
     * @uses VerkooporderregelInfoRecV5::setTotaalExclBtw()
     * @uses VerkooporderregelInfoRecV5::setTotaalInclBtw()
     * @uses VerkooporderregelInfoRecV5::setMagazijn()
     * @uses VerkooporderregelInfoRecV5::setToelichting()
     * @uses VerkooporderregelInfoRecV5::setLeveringen()
     * @param int $artikelNummer
     * @param int $besteldAantal
     * @param float $bedragPerStukExclBtw
     * @param float $bedragExclBtw
     * @param bool $geannuleerd
     * @param float $kortingBedragExclBtw
     * @param float $kortingPercentage
     * @param float $kortingStaffelExclBtw
     * @param float $kortingStaffelPercentage
     * @param float $kortingPrijsmatrixExclBtw
     * @param float $kortingPrijsmatrixPercentage
     * @param string $kortingPrijsmatrixOmschr
     * @param float $kortingOrdersoortExclBtw
     * @param float $kortingOrdersoortPercentage
     * @param string $kortingOrdersoortOmschr
     * @param float $totaalExclBtw
     * @param float $totaalInclBtw
     * @param \VoorraadApiV5\StructType\MagazijnRecV5 $magazijn
     * @param string $toelichting
     * @param \VoorraadApiV5\StructType\VerkooporderregelLevTabV5 $leveringen
     */
    public function __construct($artikelNummer = null, $besteldAantal = null, $bedragPerStukExclBtw = null, $bedragExclBtw = null, $geannuleerd = null, $kortingBedragExclBtw = null, $kortingPercentage = null, $kortingStaffelExclBtw = null, $kortingStaffelPercentage = null, $kortingPrijsmatrixExclBtw = null, $kortingPrijsmatrixPercentage = null, $kortingPrijsmatrixOmschr = null, $kortingOrdersoortExclBtw = null, $kortingOrdersoortPercentage = null, $kortingOrdersoortOmschr = null, $totaalExclBtw = null, $totaalInclBtw = null, \VoorraadApiV5\StructType\MagazijnRecV5 $magazijn = null, $toelichting = null, \VoorraadApiV5\StructType\VerkooporderregelLevTabV5 $leveringen = null)
    {
        $this
            ->setArtikelNummer($artikelNummer)
            ->setBesteldAantal($besteldAantal)
            ->setBedragPerStukExclBtw($bedragPerStukExclBtw)
            ->setBedragExclBtw($bedragExclBtw)
            ->setGeannuleerd($geannuleerd)
            ->setKortingBedragExclBtw($kortingBedragExclBtw)
            ->setKortingPercentage($kortingPercentage)
            ->setKortingStaffelExclBtw($kortingStaffelExclBtw)
            ->setKortingStaffelPercentage($kortingStaffelPercentage)
            ->setKortingPrijsmatrixExclBtw($kortingPrijsmatrixExclBtw)
            ->setKortingPrijsmatrixPercentage($kortingPrijsmatrixPercentage)
            ->setKortingPrijsmatrixOmschr($kortingPrijsmatrixOmschr)
            ->setKortingOrdersoortExclBtw($kortingOrdersoortExclBtw)
            ->setKortingOrdersoortPercentage($kortingOrdersoortPercentage)
            ->setKortingOrdersoortOmschr($kortingOrdersoortOmschr)
            ->setTotaalExclBtw($totaalExclBtw)
            ->setTotaalInclBtw($totaalInclBtw)
            ->setMagazijn($magazijn)
            ->setToelichting($toelichting)
            ->setLeveringen($leveringen);
    }
    /**
     * Get artikelNummer value
     * @return int
     */
    public function getArtikelNummer()
    {
        return $this->artikelNummer;
    }
    /**
     * Set artikelNummer value
     * @param int $artikelNummer
     * @return \VoorraadApiV5\StructType\VerkooporderregelInfoRecV5
     */
    public function setArtikelNummer($artikelNummer = null)
    {
        // validation for constraint: int
        if (!is_null($artikelNummer) && !(is_int($artikelNummer) || ctype_digit($artikelNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($artikelNummer, true), gettype($artikelNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($artikelNummer) && mb_strlen(preg_replace('/(\D)/', '', $artikelNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($artikelNummer, true), mb_strlen(preg_replace('/(\D)/', '', $artikelNummer))), __LINE__);
        }
        $this->artikelNummer = $artikelNummer;
        return $this;
    }
    /**
     * Get besteldAantal value
     * @return int
     */
    public function getBesteldAantal()
    {
        return $this->besteldAantal;
    }
    /**
     * Set besteldAantal value
     * @param int $besteldAantal
     * @return \VoorraadApiV5\StructType\VerkooporderregelInfoRecV5
     */
    public function setBesteldAantal($besteldAantal = null)
    {
        // validation for constraint: int
        if (!is_null($besteldAantal) && !(is_int($besteldAantal) || ctype_digit($besteldAantal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($besteldAantal, true), gettype($besteldAantal)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($besteldAantal) && mb_strlen(preg_replace('/(\D)/', '', $besteldAantal)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($besteldAantal, true), mb_strlen(preg_replace('/(\D)/', '', $besteldAantal))), __LINE__);
        }
        $this->besteldAantal = $besteldAantal;
        return $this;
    }
    /**
     * Get bedragPerStukExclBtw value
     * @return float
     */
    public function getBedragPerStukExclBtw()
    {
        return $this->bedragPerStukExclBtw;
    }
    /**
     * Set bedragPerStukExclBtw value
     * @param float $bedragPerStukExclBtw
     * @return \VoorraadApiV5\StructType\VerkooporderregelInfoRecV5
     */
    public function setBedragPerStukExclBtw($bedragPerStukExclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($bedragPerStukExclBtw) && !(is_float($bedragPerStukExclBtw) || is_numeric($bedragPerStukExclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bedragPerStukExclBtw, true), gettype($bedragPerStukExclBtw)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($bedragPerStukExclBtw) && mb_strlen(preg_replace('/(\D)/', '', $bedragPerStukExclBtw)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($bedragPerStukExclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $bedragPerStukExclBtw))), __LINE__);
        }
        $this->bedragPerStukExclBtw = $bedragPerStukExclBtw;
        return $this;
    }
    /**
     * Get bedragExclBtw value
     * @return float
     */
    public function getBedragExclBtw()
    {
        return $this->bedragExclBtw;
    }
    /**
     * Set bedragExclBtw value
     * @param float $bedragExclBtw
     * @return \VoorraadApiV5\StructType\VerkooporderregelInfoRecV5
     */
    public function setBedragExclBtw($bedragExclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($bedragExclBtw) && !(is_float($bedragExclBtw) || is_numeric($bedragExclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bedragExclBtw, true), gettype($bedragExclBtw)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($bedragExclBtw) && mb_strlen(preg_replace('/(\D)/', '', $bedragExclBtw)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($bedragExclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $bedragExclBtw))), __LINE__);
        }
        $this->bedragExclBtw = $bedragExclBtw;
        return $this;
    }
    /**
     * Get geannuleerd value
     * @return bool
     */
    public function getGeannuleerd()
    {
        return $this->geannuleerd;
    }
    /**
     * Set geannuleerd value
     * @param bool $geannuleerd
     * @return \VoorraadApiV5\StructType\VerkooporderregelInfoRecV5
     */
    public function setGeannuleerd($geannuleerd = null)
    {
        // validation for constraint: boolean
        if (!is_null($geannuleerd) && !is_bool($geannuleerd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($geannuleerd, true), gettype($geannuleerd)), __LINE__);
        }
        $this->geannuleerd = $geannuleerd;
        return $this;
    }
    /**
     * Get kortingBedragExclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKortingBedragExclBtw()
    {
        return isset($this->kortingBedragExclBtw) ? $this->kortingBedragExclBtw : null;
    }
    /**
     * Set kortingBedragExclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kortingBedragExclBtw
     * @return \VoorraadApiV5\StructType\VerkooporderregelInfoRecV5
     */
    public function setKortingBedragExclBtw($kortingBedragExclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($kortingBedragExclBtw) && !(is_float($kortingBedragExclBtw) || is_numeric($kortingBedragExclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kortingBedragExclBtw, true), gettype($kortingBedragExclBtw)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($kortingBedragExclBtw) && mb_strlen(preg_replace('/(\D)/', '', $kortingBedragExclBtw)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($kortingBedragExclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $kortingBedragExclBtw))), __LINE__);
        }
        if (is_null($kortingBedragExclBtw) || (is_array($kortingBedragExclBtw) && empty($kortingBedragExclBtw))) {
            unset($this->kortingBedragExclBtw);
        } else {
            $this->kortingBedragExclBtw = $kortingBedragExclBtw;
        }
        return $this;
    }
    /**
     * Get kortingPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKortingPercentage()
    {
        return isset($this->kortingPercentage) ? $this->kortingPercentage : null;
    }
    /**
     * Set kortingPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kortingPercentage
     * @return \VoorraadApiV5\StructType\VerkooporderregelInfoRecV5
     */
    public function setKortingPercentage($kortingPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($kortingPercentage) && !(is_float($kortingPercentage) || is_numeric($kortingPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kortingPercentage, true), gettype($kortingPercentage)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($kortingPercentage) && mb_strlen(preg_replace('/(\D)/', '', $kortingPercentage)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($kortingPercentage, true), mb_strlen(preg_replace('/(\D)/', '', $kortingPercentage))), __LINE__);
        }
        if (is_null($kortingPercentage) || (is_array($kortingPercentage) && empty($kortingPercentage))) {
            unset($this->kortingPercentage);
        } else {
            $this->kortingPercentage = $kortingPercentage;
        }
        return $this;
    }
    /**
     * Get kortingStaffelExclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKortingStaffelExclBtw()
    {
        return isset($this->kortingStaffelExclBtw) ? $this->kortingStaffelExclBtw : null;
    }
    /**
     * Set kortingStaffelExclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kortingStaffelExclBtw
     * @return \VoorraadApiV5\StructType\VerkooporderregelInfoRecV5
     */
    public function setKortingStaffelExclBtw($kortingStaffelExclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($kortingStaffelExclBtw) && !(is_float($kortingStaffelExclBtw) || is_numeric($kortingStaffelExclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kortingStaffelExclBtw, true), gettype($kortingStaffelExclBtw)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($kortingStaffelExclBtw) && mb_strlen(preg_replace('/(\D)/', '', $kortingStaffelExclBtw)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($kortingStaffelExclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $kortingStaffelExclBtw))), __LINE__);
        }
        if (is_null($kortingStaffelExclBtw) || (is_array($kortingStaffelExclBtw) && empty($kortingStaffelExclBtw))) {
            unset($this->kortingStaffelExclBtw);
        } else {
            $this->kortingStaffelExclBtw = $kortingStaffelExclBtw;
        }
        return $this;
    }
    /**
     * Get kortingStaffelPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKortingStaffelPercentage()
    {
        return isset($this->kortingStaffelPercentage) ? $this->kortingStaffelPercentage : null;
    }
    /**
     * Set kortingStaffelPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kortingStaffelPercentage
     * @return \VoorraadApiV5\StructType\VerkooporderregelInfoRecV5
     */
    public function setKortingStaffelPercentage($kortingStaffelPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($kortingStaffelPercentage) && !(is_float($kortingStaffelPercentage) || is_numeric($kortingStaffelPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kortingStaffelPercentage, true), gettype($kortingStaffelPercentage)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($kortingStaffelPercentage) && mb_strlen(preg_replace('/(\D)/', '', $kortingStaffelPercentage)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($kortingStaffelPercentage, true), mb_strlen(preg_replace('/(\D)/', '', $kortingStaffelPercentage))), __LINE__);
        }
        if (is_null($kortingStaffelPercentage) || (is_array($kortingStaffelPercentage) && empty($kortingStaffelPercentage))) {
            unset($this->kortingStaffelPercentage);
        } else {
            $this->kortingStaffelPercentage = $kortingStaffelPercentage;
        }
        return $this;
    }
    /**
     * Get kortingPrijsmatrixExclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKortingPrijsmatrixExclBtw()
    {
        return isset($this->kortingPrijsmatrixExclBtw) ? $this->kortingPrijsmatrixExclBtw : null;
    }
    /**
     * Set kortingPrijsmatrixExclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kortingPrijsmatrixExclBtw
     * @return \VoorraadApiV5\StructType\VerkooporderregelInfoRecV5
     */
    public function setKortingPrijsmatrixExclBtw($kortingPrijsmatrixExclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($kortingPrijsmatrixExclBtw) && !(is_float($kortingPrijsmatrixExclBtw) || is_numeric($kortingPrijsmatrixExclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kortingPrijsmatrixExclBtw, true), gettype($kortingPrijsmatrixExclBtw)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($kortingPrijsmatrixExclBtw) && mb_strlen(preg_replace('/(\D)/', '', $kortingPrijsmatrixExclBtw)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($kortingPrijsmatrixExclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $kortingPrijsmatrixExclBtw))), __LINE__);
        }
        if (is_null($kortingPrijsmatrixExclBtw) || (is_array($kortingPrijsmatrixExclBtw) && empty($kortingPrijsmatrixExclBtw))) {
            unset($this->kortingPrijsmatrixExclBtw);
        } else {
            $this->kortingPrijsmatrixExclBtw = $kortingPrijsmatrixExclBtw;
        }
        return $this;
    }
    /**
     * Get kortingPrijsmatrixPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKortingPrijsmatrixPercentage()
    {
        return isset($this->kortingPrijsmatrixPercentage) ? $this->kortingPrijsmatrixPercentage : null;
    }
    /**
     * Set kortingPrijsmatrixPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kortingPrijsmatrixPercentage
     * @return \VoorraadApiV5\StructType\VerkooporderregelInfoRecV5
     */
    public function setKortingPrijsmatrixPercentage($kortingPrijsmatrixPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($kortingPrijsmatrixPercentage) && !(is_float($kortingPrijsmatrixPercentage) || is_numeric($kortingPrijsmatrixPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kortingPrijsmatrixPercentage, true), gettype($kortingPrijsmatrixPercentage)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($kortingPrijsmatrixPercentage) && mb_strlen(mb_substr($kortingPrijsmatrixPercentage, mb_strpos($kortingPrijsmatrixPercentage, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($kortingPrijsmatrixPercentage, true), mb_strlen(mb_substr($kortingPrijsmatrixPercentage, mb_strpos($kortingPrijsmatrixPercentage, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($kortingPrijsmatrixPercentage) && mb_strlen(preg_replace('/(\D)/', '', $kortingPrijsmatrixPercentage)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($kortingPrijsmatrixPercentage, true), mb_strlen(preg_replace('/(\D)/', '', $kortingPrijsmatrixPercentage))), __LINE__);
        }
        if (is_null($kortingPrijsmatrixPercentage) || (is_array($kortingPrijsmatrixPercentage) && empty($kortingPrijsmatrixPercentage))) {
            unset($this->kortingPrijsmatrixPercentage);
        } else {
            $this->kortingPrijsmatrixPercentage = $kortingPrijsmatrixPercentage;
        }
        return $this;
    }
    /**
     * Get kortingPrijsmatrixOmschr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKortingPrijsmatrixOmschr()
    {
        return isset($this->kortingPrijsmatrixOmschr) ? $this->kortingPrijsmatrixOmschr : null;
    }
    /**
     * Set kortingPrijsmatrixOmschr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kortingPrijsmatrixOmschr
     * @return \VoorraadApiV5\StructType\VerkooporderregelInfoRecV5
     */
    public function setKortingPrijsmatrixOmschr($kortingPrijsmatrixOmschr = null)
    {
        // validation for constraint: string
        if (!is_null($kortingPrijsmatrixOmschr) && !is_string($kortingPrijsmatrixOmschr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kortingPrijsmatrixOmschr, true), gettype($kortingPrijsmatrixOmschr)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($kortingPrijsmatrixOmschr) && mb_strlen($kortingPrijsmatrixOmschr) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($kortingPrijsmatrixOmschr)), __LINE__);
        }
        if (is_null($kortingPrijsmatrixOmschr) || (is_array($kortingPrijsmatrixOmschr) && empty($kortingPrijsmatrixOmschr))) {
            unset($this->kortingPrijsmatrixOmschr);
        } else {
            $this->kortingPrijsmatrixOmschr = $kortingPrijsmatrixOmschr;
        }
        return $this;
    }
    /**
     * Get kortingOrdersoortExclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKortingOrdersoortExclBtw()
    {
        return isset($this->kortingOrdersoortExclBtw) ? $this->kortingOrdersoortExclBtw : null;
    }
    /**
     * Set kortingOrdersoortExclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kortingOrdersoortExclBtw
     * @return \VoorraadApiV5\StructType\VerkooporderregelInfoRecV5
     */
    public function setKortingOrdersoortExclBtw($kortingOrdersoortExclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($kortingOrdersoortExclBtw) && !(is_float($kortingOrdersoortExclBtw) || is_numeric($kortingOrdersoortExclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kortingOrdersoortExclBtw, true), gettype($kortingOrdersoortExclBtw)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($kortingOrdersoortExclBtw) && mb_strlen(preg_replace('/(\D)/', '', $kortingOrdersoortExclBtw)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($kortingOrdersoortExclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $kortingOrdersoortExclBtw))), __LINE__);
        }
        if (is_null($kortingOrdersoortExclBtw) || (is_array($kortingOrdersoortExclBtw) && empty($kortingOrdersoortExclBtw))) {
            unset($this->kortingOrdersoortExclBtw);
        } else {
            $this->kortingOrdersoortExclBtw = $kortingOrdersoortExclBtw;
        }
        return $this;
    }
    /**
     * Get kortingOrdersoortPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKortingOrdersoortPercentage()
    {
        return isset($this->kortingOrdersoortPercentage) ? $this->kortingOrdersoortPercentage : null;
    }
    /**
     * Set kortingOrdersoortPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kortingOrdersoortPercentage
     * @return \VoorraadApiV5\StructType\VerkooporderregelInfoRecV5
     */
    public function setKortingOrdersoortPercentage($kortingOrdersoortPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($kortingOrdersoortPercentage) && !(is_float($kortingOrdersoortPercentage) || is_numeric($kortingOrdersoortPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kortingOrdersoortPercentage, true), gettype($kortingOrdersoortPercentage)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($kortingOrdersoortPercentage) && mb_strlen(mb_substr($kortingOrdersoortPercentage, mb_strpos($kortingOrdersoortPercentage, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($kortingOrdersoortPercentage, true), mb_strlen(mb_substr($kortingOrdersoortPercentage, mb_strpos($kortingOrdersoortPercentage, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($kortingOrdersoortPercentage) && mb_strlen(preg_replace('/(\D)/', '', $kortingOrdersoortPercentage)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($kortingOrdersoortPercentage, true), mb_strlen(preg_replace('/(\D)/', '', $kortingOrdersoortPercentage))), __LINE__);
        }
        if (is_null($kortingOrdersoortPercentage) || (is_array($kortingOrdersoortPercentage) && empty($kortingOrdersoortPercentage))) {
            unset($this->kortingOrdersoortPercentage);
        } else {
            $this->kortingOrdersoortPercentage = $kortingOrdersoortPercentage;
        }
        return $this;
    }
    /**
     * Get kortingOrdersoortOmschr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKortingOrdersoortOmschr()
    {
        return isset($this->kortingOrdersoortOmschr) ? $this->kortingOrdersoortOmschr : null;
    }
    /**
     * Set kortingOrdersoortOmschr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kortingOrdersoortOmschr
     * @return \VoorraadApiV5\StructType\VerkooporderregelInfoRecV5
     */
    public function setKortingOrdersoortOmschr($kortingOrdersoortOmschr = null)
    {
        // validation for constraint: string
        if (!is_null($kortingOrdersoortOmschr) && !is_string($kortingOrdersoortOmschr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kortingOrdersoortOmschr, true), gettype($kortingOrdersoortOmschr)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($kortingOrdersoortOmschr) && mb_strlen($kortingOrdersoortOmschr) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($kortingOrdersoortOmschr)), __LINE__);
        }
        if (is_null($kortingOrdersoortOmschr) || (is_array($kortingOrdersoortOmschr) && empty($kortingOrdersoortOmschr))) {
            unset($this->kortingOrdersoortOmschr);
        } else {
            $this->kortingOrdersoortOmschr = $kortingOrdersoortOmschr;
        }
        return $this;
    }
    /**
     * Get totaalExclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotaalExclBtw()
    {
        return isset($this->totaalExclBtw) ? $this->totaalExclBtw : null;
    }
    /**
     * Set totaalExclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totaalExclBtw
     * @return \VoorraadApiV5\StructType\VerkooporderregelInfoRecV5
     */
    public function setTotaalExclBtw($totaalExclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($totaalExclBtw) && !(is_float($totaalExclBtw) || is_numeric($totaalExclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totaalExclBtw, true), gettype($totaalExclBtw)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($totaalExclBtw) && mb_strlen(preg_replace('/(\D)/', '', $totaalExclBtw)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($totaalExclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $totaalExclBtw))), __LINE__);
        }
        if (is_null($totaalExclBtw) || (is_array($totaalExclBtw) && empty($totaalExclBtw))) {
            unset($this->totaalExclBtw);
        } else {
            $this->totaalExclBtw = $totaalExclBtw;
        }
        return $this;
    }
    /**
     * Get totaalInclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotaalInclBtw()
    {
        return isset($this->totaalInclBtw) ? $this->totaalInclBtw : null;
    }
    /**
     * Set totaalInclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totaalInclBtw
     * @return \VoorraadApiV5\StructType\VerkooporderregelInfoRecV5
     */
    public function setTotaalInclBtw($totaalInclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($totaalInclBtw) && !(is_float($totaalInclBtw) || is_numeric($totaalInclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totaalInclBtw, true), gettype($totaalInclBtw)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($totaalInclBtw) && mb_strlen(mb_substr($totaalInclBtw, mb_strpos($totaalInclBtw, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($totaalInclBtw, true), mb_strlen(mb_substr($totaalInclBtw, mb_strpos($totaalInclBtw, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($totaalInclBtw) && mb_strlen(preg_replace('/(\D)/', '', $totaalInclBtw)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($totaalInclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $totaalInclBtw))), __LINE__);
        }
        if (is_null($totaalInclBtw) || (is_array($totaalInclBtw) && empty($totaalInclBtw))) {
            unset($this->totaalInclBtw);
        } else {
            $this->totaalInclBtw = $totaalInclBtw;
        }
        return $this;
    }
    /**
     * Get magazijn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \VoorraadApiV5\StructType\MagazijnRecV5|null
     */
    public function getMagazijn()
    {
        return isset($this->magazijn) ? $this->magazijn : null;
    }
    /**
     * Set magazijn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \VoorraadApiV5\StructType\MagazijnRecV5 $magazijn
     * @return \VoorraadApiV5\StructType\VerkooporderregelInfoRecV5
     */
    public function setMagazijn(\VoorraadApiV5\StructType\MagazijnRecV5 $magazijn = null)
    {
        if (is_null($magazijn) || (is_array($magazijn) && empty($magazijn))) {
            unset($this->magazijn);
        } else {
            $this->magazijn = $magazijn;
        }
        return $this;
    }
    /**
     * Get toelichting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToelichting()
    {
        return isset($this->toelichting) ? $this->toelichting : null;
    }
    /**
     * Set toelichting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toelichting
     * @return \VoorraadApiV5\StructType\VerkooporderregelInfoRecV5
     */
    public function setToelichting($toelichting = null)
    {
        // validation for constraint: string
        if (!is_null($toelichting) && !is_string($toelichting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toelichting, true), gettype($toelichting)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($toelichting) && mb_strlen($toelichting) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($toelichting)), __LINE__);
        }
        if (is_null($toelichting) || (is_array($toelichting) && empty($toelichting))) {
            unset($this->toelichting);
        } else {
            $this->toelichting = $toelichting;
        }
        return $this;
    }
    /**
     * Get leveringen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \VoorraadApiV5\StructType\VerkooporderregelLevTabV5|null
     */
    public function getLeveringen()
    {
        return isset($this->leveringen) ? $this->leveringen : null;
    }
    /**
     * Set leveringen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \VoorraadApiV5\StructType\VerkooporderregelLevTabV5 $leveringen
     * @return \VoorraadApiV5\StructType\VerkooporderregelInfoRecV5
     */
    public function setLeveringen(\VoorraadApiV5\StructType\VerkooporderregelLevTabV5 $leveringen = null)
    {
        if (is_null($leveringen) || (is_array($leveringen) && empty($leveringen))) {
            unset($this->leveringen);
        } else {
            $this->leveringen = $leveringen;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\VerkooporderregelInfoRecV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
