<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateArtikelRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Bijwerken van de prijs van een artikel <br/><u>Let op:</u> bij wijzigingen van een bestaand artikel dienen alle elementen opnieuw te worden meegegeven. Lege elementen of niet meegegeven (groepen) elementen worden leeg gemaakt door de
 * update.
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class UpdateArtikelRequest extends AbstractStructBase
{
    /**
     * The artikelCode
     * Meta informations extracted from the WSDL
     * - documentation: De code van het bij te werken artikel
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $artikelCode;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The prijs
     * Meta informations extracted from the WSDL
     * - documentation: De nieuwe prijs van het artikel
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $prijs;
    /**
     * The prijsIsInclBtw
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of de meegegeven prijs inclusief btw is. true: De prijs is inclusief BTW, false (Default): De prijs is exclusief btw
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $prijsIsInclBtw;
    /**
     * Constructor method for updateArtikelRequest
     * @uses UpdateArtikelRequest::setArtikelCode()
     * @uses UpdateArtikelRequest::setRequestTag()
     * @uses UpdateArtikelRequest::setPrijs()
     * @uses UpdateArtikelRequest::setPrijsIsInclBtw()
     * @param string $artikelCode
     * @param string $requestTag
     * @param float $prijs
     * @param float $prijsIsInclBtw
     */
    public function __construct($artikelCode = null, $requestTag = null, $prijs = null, $prijsIsInclBtw = null)
    {
        $this
            ->setArtikelCode($artikelCode)
            ->setRequestTag($requestTag)
            ->setPrijs($prijs)
            ->setPrijsIsInclBtw($prijsIsInclBtw);
    }
    /**
     * Get artikelCode value
     * @return string
     */
    public function getArtikelCode()
    {
        return $this->artikelCode;
    }
    /**
     * Set artikelCode value
     * @param string $artikelCode
     * @return \VoorraadApiV5\StructType\UpdateArtikelRequest
     */
    public function setArtikelCode($artikelCode = null)
    {
        // validation for constraint: string
        if (!is_null($artikelCode) && !is_string($artikelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($artikelCode, true), gettype($artikelCode)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($artikelCode) && mb_strlen($artikelCode) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($artikelCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($artikelCode) && mb_strlen($artikelCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($artikelCode)), __LINE__);
        }
        $this->artikelCode = $artikelCode;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \VoorraadApiV5\StructType\UpdateArtikelRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get prijs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrijs()
    {
        return isset($this->prijs) ? $this->prijs : null;
    }
    /**
     * Set prijs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prijs
     * @return \VoorraadApiV5\StructType\UpdateArtikelRequest
     */
    public function setPrijs($prijs = null)
    {
        // validation for constraint: float
        if (!is_null($prijs) && !(is_float($prijs) || is_numeric($prijs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prijs, true), gettype($prijs)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($prijs) && mb_strlen(preg_replace('/(\D)/', '', $prijs)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($prijs, true), mb_strlen(preg_replace('/(\D)/', '', $prijs))), __LINE__);
        }
        if (is_null($prijs) || (is_array($prijs) && empty($prijs))) {
            unset($this->prijs);
        } else {
            $this->prijs = $prijs;
        }
        return $this;
    }
    /**
     * Get prijsIsInclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrijsIsInclBtw()
    {
        return isset($this->prijsIsInclBtw) ? $this->prijsIsInclBtw : null;
    }
    /**
     * Set prijsIsInclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prijsIsInclBtw
     * @return \VoorraadApiV5\StructType\UpdateArtikelRequest
     */
    public function setPrijsIsInclBtw($prijsIsInclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($prijsIsInclBtw) && !(is_float($prijsIsInclBtw) || is_numeric($prijsIsInclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prijsIsInclBtw, true), gettype($prijsIsInclBtw)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($prijsIsInclBtw) && mb_strlen(preg_replace('/(\D)/', '', $prijsIsInclBtw)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($prijsIsInclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $prijsIsInclBtw))), __LINE__);
        }
        if (is_null($prijsIsInclBtw) || (is_array($prijsIsInclBtw) && empty($prijsIsInclBtw))) {
            unset($this->prijsIsInclBtw);
        } else {
            $this->prijsIsInclBtw = $prijsIsInclBtw;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\UpdateArtikelRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
