<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatieLeverantieregelRecV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Leverantieregels
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class RelatieLeverantieregelRecV5 extends AbstractStructBase
{
    /**
     * The leverantienummer
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van de leverantie waar de leverantieregel bij hoort
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $leverantienummer;
    /**
     * The leverantiedatum
     * Meta informations extracted from the WSDL
     * - documentation: Leverantiedatum van de leverantie
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $leverantiedatum;
    /**
     * The aantal
     * Meta informations extracted from the WSDL
     * - documentation: Aantal bestelde artikelen op de leverantieregel
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $aantal;
    /**
     * The prijs
     * Meta informations extracted from the WSDL
     * - documentation: Prijs van de leverantieregel
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $prijs;
    /**
     * The korting
     * Meta informations extracted from the WSDL
     * - documentation: Totaalbedrag van de korting(en) op de leverantieregel
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $korting;
    /**
     * The trackEnTraceInfo
     * Meta informations extracted from the WSDL
     * - documentation: Informatie mbt tracktrace (indien beschikbaar en opgegeven door de verzender)
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $trackEnTraceInfo;
    /**
     * The artikel
     * Meta informations extracted from the WSDL
     * - documentation: De gegevens van het artikel op de leverantieregel
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public $artikel;
    /**
     * Constructor method for RelatieLeverantieregelRecV5
     * @uses RelatieLeverantieregelRecV5::setLeverantienummer()
     * @uses RelatieLeverantieregelRecV5::setLeverantiedatum()
     * @uses RelatieLeverantieregelRecV5::setAantal()
     * @uses RelatieLeverantieregelRecV5::setPrijs()
     * @uses RelatieLeverantieregelRecV5::setKorting()
     * @uses RelatieLeverantieregelRecV5::setTrackEnTraceInfo()
     * @uses RelatieLeverantieregelRecV5::setArtikel()
     * @param int $leverantienummer
     * @param string $leverantiedatum
     * @param int $aantal
     * @param float $prijs
     * @param float $korting
     * @param string $trackEnTraceInfo
     * @param \VoorraadApiV5\StructType\VoorraadArtikelRecV5 $artikel
     */
    public function __construct($leverantienummer = null, $leverantiedatum = null, $aantal = null, $prijs = null, $korting = null, $trackEnTraceInfo = null, \VoorraadApiV5\StructType\VoorraadArtikelRecV5 $artikel = null)
    {
        $this
            ->setLeverantienummer($leverantienummer)
            ->setLeverantiedatum($leverantiedatum)
            ->setAantal($aantal)
            ->setPrijs($prijs)
            ->setKorting($korting)
            ->setTrackEnTraceInfo($trackEnTraceInfo)
            ->setArtikel($artikel);
    }
    /**
     * Get leverantienummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLeverantienummer()
    {
        return isset($this->leverantienummer) ? $this->leverantienummer : null;
    }
    /**
     * Set leverantienummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $leverantienummer
     * @return \VoorraadApiV5\StructType\RelatieLeverantieregelRecV5
     */
    public function setLeverantienummer($leverantienummer = null)
    {
        // validation for constraint: int
        if (!is_null($leverantienummer) && !(is_int($leverantienummer) || ctype_digit($leverantienummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($leverantienummer, true), gettype($leverantienummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($leverantienummer) && mb_strlen(preg_replace('/(\D)/', '', $leverantienummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($leverantienummer, true), mb_strlen(preg_replace('/(\D)/', '', $leverantienummer))), __LINE__);
        }
        if (is_null($leverantienummer) || (is_array($leverantienummer) && empty($leverantienummer))) {
            unset($this->leverantienummer);
        } else {
            $this->leverantienummer = $leverantienummer;
        }
        return $this;
    }
    /**
     * Get leverantiedatum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLeverantiedatum()
    {
        return isset($this->leverantiedatum) ? $this->leverantiedatum : null;
    }
    /**
     * Set leverantiedatum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $leverantiedatum
     * @return \VoorraadApiV5\StructType\RelatieLeverantieregelRecV5
     */
    public function setLeverantiedatum($leverantiedatum = null)
    {
        // validation for constraint: string
        if (!is_null($leverantiedatum) && !is_string($leverantiedatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leverantiedatum, true), gettype($leverantiedatum)), __LINE__);
        }
        if (is_null($leverantiedatum) || (is_array($leverantiedatum) && empty($leverantiedatum))) {
            unset($this->leverantiedatum);
        } else {
            $this->leverantiedatum = $leverantiedatum;
        }
        return $this;
    }
    /**
     * Get aantal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAantal()
    {
        return isset($this->aantal) ? $this->aantal : null;
    }
    /**
     * Set aantal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aantal
     * @return \VoorraadApiV5\StructType\RelatieLeverantieregelRecV5
     */
    public function setAantal($aantal = null)
    {
        // validation for constraint: int
        if (!is_null($aantal) && !(is_int($aantal) || ctype_digit($aantal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aantal, true), gettype($aantal)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($aantal) && mb_strlen(preg_replace('/(\D)/', '', $aantal)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($aantal, true), mb_strlen(preg_replace('/(\D)/', '', $aantal))), __LINE__);
        }
        if (is_null($aantal) || (is_array($aantal) && empty($aantal))) {
            unset($this->aantal);
        } else {
            $this->aantal = $aantal;
        }
        return $this;
    }
    /**
     * Get prijs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrijs()
    {
        return isset($this->prijs) ? $this->prijs : null;
    }
    /**
     * Set prijs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prijs
     * @return \VoorraadApiV5\StructType\RelatieLeverantieregelRecV5
     */
    public function setPrijs($prijs = null)
    {
        // validation for constraint: float
        if (!is_null($prijs) && !(is_float($prijs) || is_numeric($prijs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prijs, true), gettype($prijs)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($prijs) && mb_strlen(mb_substr($prijs, mb_strpos($prijs, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($prijs, true), mb_strlen(mb_substr($prijs, mb_strpos($prijs, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($prijs) && mb_strlen(preg_replace('/(\D)/', '', $prijs)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($prijs, true), mb_strlen(preg_replace('/(\D)/', '', $prijs))), __LINE__);
        }
        if (is_null($prijs) || (is_array($prijs) && empty($prijs))) {
            unset($this->prijs);
        } else {
            $this->prijs = $prijs;
        }
        return $this;
    }
    /**
     * Get korting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKorting()
    {
        return isset($this->korting) ? $this->korting : null;
    }
    /**
     * Set korting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $korting
     * @return \VoorraadApiV5\StructType\RelatieLeverantieregelRecV5
     */
    public function setKorting($korting = null)
    {
        // validation for constraint: float
        if (!is_null($korting) && !(is_float($korting) || is_numeric($korting))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($korting, true), gettype($korting)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($korting) && mb_strlen(mb_substr($korting, mb_strpos($korting, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($korting, true), mb_strlen(mb_substr($korting, mb_strpos($korting, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($korting) && mb_strlen(preg_replace('/(\D)/', '', $korting)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($korting, true), mb_strlen(preg_replace('/(\D)/', '', $korting))), __LINE__);
        }
        if (is_null($korting) || (is_array($korting) && empty($korting))) {
            unset($this->korting);
        } else {
            $this->korting = $korting;
        }
        return $this;
    }
    /**
     * Get trackEnTraceInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrackEnTraceInfo()
    {
        return isset($this->trackEnTraceInfo) ? $this->trackEnTraceInfo : null;
    }
    /**
     * Set trackEnTraceInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trackEnTraceInfo
     * @return \VoorraadApiV5\StructType\RelatieLeverantieregelRecV5
     */
    public function setTrackEnTraceInfo($trackEnTraceInfo = null)
    {
        // validation for constraint: string
        if (!is_null($trackEnTraceInfo) && !is_string($trackEnTraceInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackEnTraceInfo, true), gettype($trackEnTraceInfo)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($trackEnTraceInfo) && mb_strlen($trackEnTraceInfo) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($trackEnTraceInfo)), __LINE__);
        }
        if (is_null($trackEnTraceInfo) || (is_array($trackEnTraceInfo) && empty($trackEnTraceInfo))) {
            unset($this->trackEnTraceInfo);
        } else {
            $this->trackEnTraceInfo = $trackEnTraceInfo;
        }
        return $this;
    }
    /**
     * Get artikel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5|null
     */
    public function getArtikel()
    {
        return isset($this->artikel) ? $this->artikel : null;
    }
    /**
     * Set artikel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \VoorraadApiV5\StructType\VoorraadArtikelRecV5 $artikel
     * @return \VoorraadApiV5\StructType\RelatieLeverantieregelRecV5
     */
    public function setArtikel(\VoorraadApiV5\StructType\VoorraadArtikelRecV5 $artikel = null)
    {
        if (is_null($artikel) || (is_array($artikel) && empty($artikel))) {
            unset($this->artikel);
        } else {
            $this->artikel = $artikel;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\RelatieLeverantieregelRecV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
