<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatieArtikeltableV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met bij de relatie aanwezige artikelen
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class RelatieArtikeltableV5 extends AbstractStructBase
{
    /**
     * The relatieArtikel
     * Meta informations extracted from the WSDL
     * - documentation: RelatieArtikelRec
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - nillable: false
     * @var \VoorraadApiV5\StructType\RelatieArtikelRecV5[]
     */
    public $relatieArtikel;
    /**
     * Constructor method for RelatieArtikeltableV5
     * @uses RelatieArtikeltableV5::setRelatieArtikel()
     * @param \VoorraadApiV5\StructType\RelatieArtikelRecV5[] $relatieArtikel
     */
    public function __construct(array $relatieArtikel = array())
    {
        $this
            ->setRelatieArtikel($relatieArtikel);
    }
    /**
     * Get relatieArtikel value
     * @return \VoorraadApiV5\StructType\RelatieArtikelRecV5[]
     */
    public function getRelatieArtikel()
    {
        return $this->relatieArtikel;
    }
    /**
     * This method is responsible for validating the values passed to the setRelatieArtikel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelatieArtikel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelatieArtikelForArrayConstraintsFromSetRelatieArtikel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $relatieArtikeltableV5RelatieArtikelItem) {
            // validation for constraint: itemType
            if (!$relatieArtikeltableV5RelatieArtikelItem instanceof \VoorraadApiV5\StructType\RelatieArtikelRecV5) {
                $invalidValues[] = is_object($relatieArtikeltableV5RelatieArtikelItem) ? get_class($relatieArtikeltableV5RelatieArtikelItem) : sprintf('%s(%s)', gettype($relatieArtikeltableV5RelatieArtikelItem), var_export($relatieArtikeltableV5RelatieArtikelItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The relatieArtikel property can only contain items of type \VoorraadApiV5\StructType\RelatieArtikelRecV5, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set relatieArtikel value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\RelatieArtikelRecV5[] $relatieArtikel
     * @return \VoorraadApiV5\StructType\RelatieArtikeltableV5
     */
    public function setRelatieArtikel(array $relatieArtikel = array())
    {
        // validation for constraint: array
        if ('' !== ($relatieArtikelArrayErrorMessage = self::validateRelatieArtikelForArrayConstraintsFromSetRelatieArtikel($relatieArtikel))) {
            throw new \InvalidArgumentException($relatieArtikelArrayErrorMessage, __LINE__);
        }
        $this->relatieArtikel = $relatieArtikel;
        return $this;
    }
    /**
     * Add item to relatieArtikel value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\RelatieArtikelRecV5 $item
     * @return \VoorraadApiV5\StructType\RelatieArtikeltableV5
     */
    public function addToRelatieArtikel(\VoorraadApiV5\StructType\RelatieArtikelRecV5 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \VoorraadApiV5\StructType\RelatieArtikelRecV5) {
            throw new \InvalidArgumentException(sprintf('The relatieArtikel property can only contain items of type \VoorraadApiV5\StructType\RelatieArtikelRecV5, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->relatieArtikel[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\RelatieArtikeltableV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
