<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RechthebbendeTableV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met rechthebbenden.
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class RechthebbendeTableV5 extends AbstractStructBase
{
    /**
     * The rechthebbende
     * Meta informations extracted from the WSDL
     * - documentation: Rechthebbende (auteur en/of redacteur)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \VoorraadApiV5\StructType\RechthebbendeRecV5[]
     */
    public $rechthebbende;
    /**
     * Constructor method for RechthebbendeTableV5
     * @uses RechthebbendeTableV5::setRechthebbende()
     * @param \VoorraadApiV5\StructType\RechthebbendeRecV5[] $rechthebbende
     */
    public function __construct(array $rechthebbende = array())
    {
        $this
            ->setRechthebbende($rechthebbende);
    }
    /**
     * Get rechthebbende value
     * @return \VoorraadApiV5\StructType\RechthebbendeRecV5[]|null
     */
    public function getRechthebbende()
    {
        return $this->rechthebbende;
    }
    /**
     * This method is responsible for validating the values passed to the setRechthebbende method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRechthebbende method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRechthebbendeForArrayConstraintsFromSetRechthebbende(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $rechthebbendeTableV5RechthebbendeItem) {
            // validation for constraint: itemType
            if (!$rechthebbendeTableV5RechthebbendeItem instanceof \VoorraadApiV5\StructType\RechthebbendeRecV5) {
                $invalidValues[] = is_object($rechthebbendeTableV5RechthebbendeItem) ? get_class($rechthebbendeTableV5RechthebbendeItem) : sprintf('%s(%s)', gettype($rechthebbendeTableV5RechthebbendeItem), var_export($rechthebbendeTableV5RechthebbendeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The rechthebbende property can only contain items of type \VoorraadApiV5\StructType\RechthebbendeRecV5, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set rechthebbende value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\RechthebbendeRecV5[] $rechthebbende
     * @return \VoorraadApiV5\StructType\RechthebbendeTableV5
     */
    public function setRechthebbende(array $rechthebbende = array())
    {
        // validation for constraint: array
        if ('' !== ($rechthebbendeArrayErrorMessage = self::validateRechthebbendeForArrayConstraintsFromSetRechthebbende($rechthebbende))) {
            throw new \InvalidArgumentException($rechthebbendeArrayErrorMessage, __LINE__);
        }
        $this->rechthebbende = $rechthebbende;
        return $this;
    }
    /**
     * Add item to rechthebbende value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\RechthebbendeRecV5 $item
     * @return \VoorraadApiV5\StructType\RechthebbendeTableV5
     */
    public function addToRechthebbende(\VoorraadApiV5\StructType\RechthebbendeRecV5 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \VoorraadApiV5\StructType\RechthebbendeRecV5) {
            throw new \InvalidArgumentException(sprintf('The rechthebbende property can only contain items of type \VoorraadApiV5\StructType\RechthebbendeRecV5, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->rechthebbende[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\RechthebbendeTableV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
