<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PublicatieCoderingenRecV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Coderingen van publicaties
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class PublicatieCoderingenRecV5 extends AbstractStructBase
{
    /**
     * The coderingsGroepCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de coderingsgroep
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $coderingsGroepCode;
    /**
     * The coderingsGroepOmschrijving
     * Meta informations extracted from the WSDL
     * - documentation: Omschrijving van de coderingsgroep
     * - base: xsd:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $coderingsGroepOmschrijving;
    /**
     * The coderingsGroepIsNur
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of de coderingen in de groep NUR coderingen zijn.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $coderingsGroepIsNur;
    /**
     * The coderingCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de codering
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $coderingCode;
    /**
     * The coderingOmschrijving
     * Meta informations extracted from the WSDL
     * - documentation: Omschrijving van de coderinb
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $coderingOmschrijving;
    /**
     * The coderingIsHoofdNur
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of de codering de hoofd codering is in geval van NUR.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $coderingIsHoofdNur;
    /**
     * Constructor method for PublicatieCoderingenRecV5
     * @uses PublicatieCoderingenRecV5::setCoderingsGroepCode()
     * @uses PublicatieCoderingenRecV5::setCoderingsGroepOmschrijving()
     * @uses PublicatieCoderingenRecV5::setCoderingsGroepIsNur()
     * @uses PublicatieCoderingenRecV5::setCoderingCode()
     * @uses PublicatieCoderingenRecV5::setCoderingOmschrijving()
     * @uses PublicatieCoderingenRecV5::setCoderingIsHoofdNur()
     * @param string $coderingsGroepCode
     * @param string $coderingsGroepOmschrijving
     * @param bool $coderingsGroepIsNur
     * @param string $coderingCode
     * @param string $coderingOmschrijving
     * @param bool $coderingIsHoofdNur
     */
    public function __construct($coderingsGroepCode = null, $coderingsGroepOmschrijving = null, $coderingsGroepIsNur = null, $coderingCode = null, $coderingOmschrijving = null, $coderingIsHoofdNur = null)
    {
        $this
            ->setCoderingsGroepCode($coderingsGroepCode)
            ->setCoderingsGroepOmschrijving($coderingsGroepOmschrijving)
            ->setCoderingsGroepIsNur($coderingsGroepIsNur)
            ->setCoderingCode($coderingCode)
            ->setCoderingOmschrijving($coderingOmschrijving)
            ->setCoderingIsHoofdNur($coderingIsHoofdNur);
    }
    /**
     * Get coderingsGroepCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoderingsGroepCode()
    {
        return isset($this->coderingsGroepCode) ? $this->coderingsGroepCode : null;
    }
    /**
     * Set coderingsGroepCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coderingsGroepCode
     * @return \VoorraadApiV5\StructType\PublicatieCoderingenRecV5
     */
    public function setCoderingsGroepCode($coderingsGroepCode = null)
    {
        // validation for constraint: string
        if (!is_null($coderingsGroepCode) && !is_string($coderingsGroepCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coderingsGroepCode, true), gettype($coderingsGroepCode)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($coderingsGroepCode) && mb_strlen($coderingsGroepCode) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($coderingsGroepCode)), __LINE__);
        }
        if (is_null($coderingsGroepCode) || (is_array($coderingsGroepCode) && empty($coderingsGroepCode))) {
            unset($this->coderingsGroepCode);
        } else {
            $this->coderingsGroepCode = $coderingsGroepCode;
        }
        return $this;
    }
    /**
     * Get coderingsGroepOmschrijving value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoderingsGroepOmschrijving()
    {
        return isset($this->coderingsGroepOmschrijving) ? $this->coderingsGroepOmschrijving : null;
    }
    /**
     * Set coderingsGroepOmschrijving value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coderingsGroepOmschrijving
     * @return \VoorraadApiV5\StructType\PublicatieCoderingenRecV5
     */
    public function setCoderingsGroepOmschrijving($coderingsGroepOmschrijving = null)
    {
        // validation for constraint: string
        if (!is_null($coderingsGroepOmschrijving) && !is_string($coderingsGroepOmschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coderingsGroepOmschrijving, true), gettype($coderingsGroepOmschrijving)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($coderingsGroepOmschrijving) && mb_strlen($coderingsGroepOmschrijving) > 200) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen($coderingsGroepOmschrijving)), __LINE__);
        }
        if (is_null($coderingsGroepOmschrijving) || (is_array($coderingsGroepOmschrijving) && empty($coderingsGroepOmschrijving))) {
            unset($this->coderingsGroepOmschrijving);
        } else {
            $this->coderingsGroepOmschrijving = $coderingsGroepOmschrijving;
        }
        return $this;
    }
    /**
     * Get coderingsGroepIsNur value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCoderingsGroepIsNur()
    {
        return isset($this->coderingsGroepIsNur) ? $this->coderingsGroepIsNur : null;
    }
    /**
     * Set coderingsGroepIsNur value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $coderingsGroepIsNur
     * @return \VoorraadApiV5\StructType\PublicatieCoderingenRecV5
     */
    public function setCoderingsGroepIsNur($coderingsGroepIsNur = null)
    {
        // validation for constraint: boolean
        if (!is_null($coderingsGroepIsNur) && !is_bool($coderingsGroepIsNur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($coderingsGroepIsNur, true), gettype($coderingsGroepIsNur)), __LINE__);
        }
        if (is_null($coderingsGroepIsNur) || (is_array($coderingsGroepIsNur) && empty($coderingsGroepIsNur))) {
            unset($this->coderingsGroepIsNur);
        } else {
            $this->coderingsGroepIsNur = $coderingsGroepIsNur;
        }
        return $this;
    }
    /**
     * Get coderingCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoderingCode()
    {
        return isset($this->coderingCode) ? $this->coderingCode : null;
    }
    /**
     * Set coderingCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coderingCode
     * @return \VoorraadApiV5\StructType\PublicatieCoderingenRecV5
     */
    public function setCoderingCode($coderingCode = null)
    {
        // validation for constraint: string
        if (!is_null($coderingCode) && !is_string($coderingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coderingCode, true), gettype($coderingCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($coderingCode) && mb_strlen($coderingCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($coderingCode)), __LINE__);
        }
        if (is_null($coderingCode) || (is_array($coderingCode) && empty($coderingCode))) {
            unset($this->coderingCode);
        } else {
            $this->coderingCode = $coderingCode;
        }
        return $this;
    }
    /**
     * Get coderingOmschrijving value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCoderingOmschrijving()
    {
        return isset($this->coderingOmschrijving) ? $this->coderingOmschrijving : null;
    }
    /**
     * Set coderingOmschrijving value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $coderingOmschrijving
     * @return \VoorraadApiV5\StructType\PublicatieCoderingenRecV5
     */
    public function setCoderingOmschrijving($coderingOmschrijving = null)
    {
        // validation for constraint: string
        if (!is_null($coderingOmschrijving) && !is_string($coderingOmschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($coderingOmschrijving, true), gettype($coderingOmschrijving)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($coderingOmschrijving) && mb_strlen($coderingOmschrijving) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($coderingOmschrijving)), __LINE__);
        }
        if (is_null($coderingOmschrijving) || (is_array($coderingOmschrijving) && empty($coderingOmschrijving))) {
            unset($this->coderingOmschrijving);
        } else {
            $this->coderingOmschrijving = $coderingOmschrijving;
        }
        return $this;
    }
    /**
     * Get coderingIsHoofdNur value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCoderingIsHoofdNur()
    {
        return isset($this->coderingIsHoofdNur) ? $this->coderingIsHoofdNur : null;
    }
    /**
     * Set coderingIsHoofdNur value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $coderingIsHoofdNur
     * @return \VoorraadApiV5\StructType\PublicatieCoderingenRecV5
     */
    public function setCoderingIsHoofdNur($coderingIsHoofdNur = null)
    {
        // validation for constraint: boolean
        if (!is_null($coderingIsHoofdNur) && !is_bool($coderingIsHoofdNur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($coderingIsHoofdNur, true), gettype($coderingIsHoofdNur)), __LINE__);
        }
        if (is_null($coderingIsHoofdNur) || (is_array($coderingIsHoofdNur) && empty($coderingIsHoofdNur))) {
            unset($this->coderingIsHoofdNur);
        } else {
            $this->coderingIsHoofdNur = $coderingIsHoofdNur;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\PublicatieCoderingenRecV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
