<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrdersoorttableV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met beschikbare ordersoorten
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class OrdersoorttableV5 extends AbstractStructBase
{
    /**
     * The ordersoort
     * Meta informations extracted from the WSDL
     * - documentation: OrdersoortRec
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \VoorraadApiV5\StructType\OrdersoortRecV5[]
     */
    public $ordersoort;
    /**
     * Constructor method for OrdersoorttableV5
     * @uses OrdersoorttableV5::setOrdersoort()
     * @param \VoorraadApiV5\StructType\OrdersoortRecV5[] $ordersoort
     */
    public function __construct(array $ordersoort = array())
    {
        $this
            ->setOrdersoort($ordersoort);
    }
    /**
     * Get ordersoort value
     * @return \VoorraadApiV5\StructType\OrdersoortRecV5[]|null
     */
    public function getOrdersoort()
    {
        return $this->ordersoort;
    }
    /**
     * This method is responsible for validating the values passed to the setOrdersoort method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrdersoort method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrdersoortForArrayConstraintsFromSetOrdersoort(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ordersoorttableV5OrdersoortItem) {
            // validation for constraint: itemType
            if (!$ordersoorttableV5OrdersoortItem instanceof \VoorraadApiV5\StructType\OrdersoortRecV5) {
                $invalidValues[] = is_object($ordersoorttableV5OrdersoortItem) ? get_class($ordersoorttableV5OrdersoortItem) : sprintf('%s(%s)', gettype($ordersoorttableV5OrdersoortItem), var_export($ordersoorttableV5OrdersoortItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ordersoort property can only contain items of type \VoorraadApiV5\StructType\OrdersoortRecV5, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ordersoort value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\OrdersoortRecV5[] $ordersoort
     * @return \VoorraadApiV5\StructType\OrdersoorttableV5
     */
    public function setOrdersoort(array $ordersoort = array())
    {
        // validation for constraint: array
        if ('' !== ($ordersoortArrayErrorMessage = self::validateOrdersoortForArrayConstraintsFromSetOrdersoort($ordersoort))) {
            throw new \InvalidArgumentException($ordersoortArrayErrorMessage, __LINE__);
        }
        $this->ordersoort = $ordersoort;
        return $this;
    }
    /**
     * Add item to ordersoort value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\OrdersoortRecV5 $item
     * @return \VoorraadApiV5\StructType\OrdersoorttableV5
     */
    public function addToOrdersoort(\VoorraadApiV5\StructType\OrdersoortRecV5 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \VoorraadApiV5\StructType\OrdersoortRecV5) {
            throw new \InvalidArgumentException(sprintf('The ordersoort property can only contain items of type \VoorraadApiV5\StructType\OrdersoortRecV5, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ordersoort[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\OrdersoorttableV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
