<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderregelRecV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Orderregel gegevens van de in te voeren orderregels bij een verkooporder.
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class OrderregelRecV5 extends AbstractStructBase
{
    /**
     * The artikelNummer
     * Meta informations extracted from the WSDL
     * - documentation: Artikelnummer van het op de orderregel op te nemen artikel
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $artikelNummer;
    /**
     * The prijs
     * Meta informations extracted from the WSDL
     * - documentation: De totale prijs voor het bestelde artikel en aantal (excl. BTW). Indien op de order een valuta is ingevoerd, moet dit bedrag in die valuta zijn.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $prijs;
    /**
     * The aantal
     * Meta informations extracted from the WSDL
     * - documentation: Het aantal te bestellen artikelen
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $aantal;
    /**
     * The kortingBedrag
     * Meta informations extracted from the WSDL
     * - documentation: Kortingsbedrag dat geldt voor de volledige artikelregel (excl. BTW). Indien op de order een valuta is ingevoerd, moet dit bedrag in die valuta zijn.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $kortingBedrag;
    /**
     * The kortingPercentage
     * Meta informations extracted from the WSDL
     * - documentation: Percentage korting dat geldig is op het artikel
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $kortingPercentage;
    /**
     * The kortingOmschr
     * Meta informations extracted from the WSDL
     * - documentation: Omschrijving van de korting
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $kortingOmschr;
    /**
     * The kortingStaffel
     * Meta informations extracted from the WSDL
     * - documentation: Totaal kortingsbedrag op basis van de staffel (excl. BTW). Indien op de order een valuta is ingevoerd, moet dit bedrag in die valuta zijn.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $kortingStaffel;
    /**
     * The kortingStaffelPercentage
     * Meta informations extracted from the WSDL
     * - documentation: Kortingspercentage op basis van de staffel
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $kortingStaffelPercentage;
    /**
     * The kortingPrijsmatrix
     * Meta informations extracted from the WSDL
     * - documentation: Totaal kortingsbedrag op basis van de prijsmatrix (excl. BTW). Indien op de order een valuta is ingevoerd, moet dit bedrag in die valuta zijn.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $kortingPrijsmatrix;
    /**
     * The kortingPrijsmatrixPercentage
     * Meta informations extracted from the WSDL
     * - documentation: Kortingspercentage op basis van de prijsmatrix
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $kortingPrijsmatrixPercentage;
    /**
     * The kortingPrijsmatrixOmschr
     * Meta informations extracted from the WSDL
     * - documentation: Omschrijving korting op basis van de prijsmatrix
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $kortingPrijsmatrixOmschr;
    /**
     * The kortingOrdersoort
     * Meta informations extracted from the WSDL
     * - documentation: Totaal kortingsbedrag op basis van de ordersoort (excl. BTW). Indien op de order een valuta is ingevoerd, moet dit bedrag in die valuta zijn.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $kortingOrdersoort;
    /**
     * The kortingOrdersoortPercentage
     * Meta informations extracted from the WSDL
     * - documentation: Kortingspercentage op basis van de ordersoort
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $kortingOrdersoortPercentage;
    /**
     * The kortingOrdersoortOmschr
     * Meta informations extracted from the WSDL
     * - documentation: Omschrijving korting op basis van de ordersoort
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $kortingOrdersoortOmschr;
    /**
     * Constructor method for OrderregelRecV5
     * @uses OrderregelRecV5::setArtikelNummer()
     * @uses OrderregelRecV5::setPrijs()
     * @uses OrderregelRecV5::setAantal()
     * @uses OrderregelRecV5::setKortingBedrag()
     * @uses OrderregelRecV5::setKortingPercentage()
     * @uses OrderregelRecV5::setKortingOmschr()
     * @uses OrderregelRecV5::setKortingStaffel()
     * @uses OrderregelRecV5::setKortingStaffelPercentage()
     * @uses OrderregelRecV5::setKortingPrijsmatrix()
     * @uses OrderregelRecV5::setKortingPrijsmatrixPercentage()
     * @uses OrderregelRecV5::setKortingPrijsmatrixOmschr()
     * @uses OrderregelRecV5::setKortingOrdersoort()
     * @uses OrderregelRecV5::setKortingOrdersoortPercentage()
     * @uses OrderregelRecV5::setKortingOrdersoortOmschr()
     * @param int $artikelNummer
     * @param float $prijs
     * @param float $aantal
     * @param float $kortingBedrag
     * @param float $kortingPercentage
     * @param string $kortingOmschr
     * @param float $kortingStaffel
     * @param float $kortingStaffelPercentage
     * @param float $kortingPrijsmatrix
     * @param float $kortingPrijsmatrixPercentage
     * @param string $kortingPrijsmatrixOmschr
     * @param float $kortingOrdersoort
     * @param float $kortingOrdersoortPercentage
     * @param string $kortingOrdersoortOmschr
     */
    public function __construct($artikelNummer = null, $prijs = null, $aantal = null, $kortingBedrag = null, $kortingPercentage = null, $kortingOmschr = null, $kortingStaffel = null, $kortingStaffelPercentage = null, $kortingPrijsmatrix = null, $kortingPrijsmatrixPercentage = null, $kortingPrijsmatrixOmschr = null, $kortingOrdersoort = null, $kortingOrdersoortPercentage = null, $kortingOrdersoortOmschr = null)
    {
        $this
            ->setArtikelNummer($artikelNummer)
            ->setPrijs($prijs)
            ->setAantal($aantal)
            ->setKortingBedrag($kortingBedrag)
            ->setKortingPercentage($kortingPercentage)
            ->setKortingOmschr($kortingOmschr)
            ->setKortingStaffel($kortingStaffel)
            ->setKortingStaffelPercentage($kortingStaffelPercentage)
            ->setKortingPrijsmatrix($kortingPrijsmatrix)
            ->setKortingPrijsmatrixPercentage($kortingPrijsmatrixPercentage)
            ->setKortingPrijsmatrixOmschr($kortingPrijsmatrixOmschr)
            ->setKortingOrdersoort($kortingOrdersoort)
            ->setKortingOrdersoortPercentage($kortingOrdersoortPercentage)
            ->setKortingOrdersoortOmschr($kortingOrdersoortOmschr);
    }
    /**
     * Get artikelNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getArtikelNummer()
    {
        return isset($this->artikelNummer) ? $this->artikelNummer : null;
    }
    /**
     * Set artikelNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $artikelNummer
     * @return \VoorraadApiV5\StructType\OrderregelRecV5
     */
    public function setArtikelNummer($artikelNummer = null)
    {
        // validation for constraint: int
        if (!is_null($artikelNummer) && !(is_int($artikelNummer) || ctype_digit($artikelNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($artikelNummer, true), gettype($artikelNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($artikelNummer) && mb_strlen(preg_replace('/(\D)/', '', $artikelNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($artikelNummer, true), mb_strlen(preg_replace('/(\D)/', '', $artikelNummer))), __LINE__);
        }
        if (is_null($artikelNummer) || (is_array($artikelNummer) && empty($artikelNummer))) {
            unset($this->artikelNummer);
        } else {
            $this->artikelNummer = $artikelNummer;
        }
        return $this;
    }
    /**
     * Get prijs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrijs()
    {
        return isset($this->prijs) ? $this->prijs : null;
    }
    /**
     * Set prijs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prijs
     * @return \VoorraadApiV5\StructType\OrderregelRecV5
     */
    public function setPrijs($prijs = null)
    {
        // validation for constraint: float
        if (!is_null($prijs) && !(is_float($prijs) || is_numeric($prijs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prijs, true), gettype($prijs)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($prijs) && mb_strlen(preg_replace('/(\D)/', '', $prijs)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($prijs, true), mb_strlen(preg_replace('/(\D)/', '', $prijs))), __LINE__);
        }
        if (is_null($prijs) || (is_array($prijs) && empty($prijs))) {
            unset($this->prijs);
        } else {
            $this->prijs = $prijs;
        }
        return $this;
    }
    /**
     * Get aantal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAantal()
    {
        return isset($this->aantal) ? $this->aantal : null;
    }
    /**
     * Set aantal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aantal
     * @return \VoorraadApiV5\StructType\OrderregelRecV5
     */
    public function setAantal($aantal = null)
    {
        // validation for constraint: float
        if (!is_null($aantal) && !(is_float($aantal) || is_numeric($aantal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aantal, true), gettype($aantal)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($aantal) && mb_strlen(preg_replace('/(\D)/', '', $aantal)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($aantal, true), mb_strlen(preg_replace('/(\D)/', '', $aantal))), __LINE__);
        }
        if (is_null($aantal) || (is_array($aantal) && empty($aantal))) {
            unset($this->aantal);
        } else {
            $this->aantal = $aantal;
        }
        return $this;
    }
    /**
     * Get kortingBedrag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKortingBedrag()
    {
        return isset($this->kortingBedrag) ? $this->kortingBedrag : null;
    }
    /**
     * Set kortingBedrag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kortingBedrag
     * @return \VoorraadApiV5\StructType\OrderregelRecV5
     */
    public function setKortingBedrag($kortingBedrag = null)
    {
        // validation for constraint: float
        if (!is_null($kortingBedrag) && !(is_float($kortingBedrag) || is_numeric($kortingBedrag))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kortingBedrag, true), gettype($kortingBedrag)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($kortingBedrag) && mb_strlen(preg_replace('/(\D)/', '', $kortingBedrag)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($kortingBedrag, true), mb_strlen(preg_replace('/(\D)/', '', $kortingBedrag))), __LINE__);
        }
        if (is_null($kortingBedrag) || (is_array($kortingBedrag) && empty($kortingBedrag))) {
            unset($this->kortingBedrag);
        } else {
            $this->kortingBedrag = $kortingBedrag;
        }
        return $this;
    }
    /**
     * Get kortingPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKortingPercentage()
    {
        return isset($this->kortingPercentage) ? $this->kortingPercentage : null;
    }
    /**
     * Set kortingPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kortingPercentage
     * @return \VoorraadApiV5\StructType\OrderregelRecV5
     */
    public function setKortingPercentage($kortingPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($kortingPercentage) && !(is_float($kortingPercentage) || is_numeric($kortingPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kortingPercentage, true), gettype($kortingPercentage)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($kortingPercentage) && mb_strlen(preg_replace('/(\D)/', '', $kortingPercentage)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($kortingPercentage, true), mb_strlen(preg_replace('/(\D)/', '', $kortingPercentage))), __LINE__);
        }
        if (is_null($kortingPercentage) || (is_array($kortingPercentage) && empty($kortingPercentage))) {
            unset($this->kortingPercentage);
        } else {
            $this->kortingPercentage = $kortingPercentage;
        }
        return $this;
    }
    /**
     * Get kortingOmschr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKortingOmschr()
    {
        return isset($this->kortingOmschr) ? $this->kortingOmschr : null;
    }
    /**
     * Set kortingOmschr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kortingOmschr
     * @return \VoorraadApiV5\StructType\OrderregelRecV5
     */
    public function setKortingOmschr($kortingOmschr = null)
    {
        // validation for constraint: string
        if (!is_null($kortingOmschr) && !is_string($kortingOmschr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kortingOmschr, true), gettype($kortingOmschr)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($kortingOmschr) && mb_strlen($kortingOmschr) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($kortingOmschr)), __LINE__);
        }
        if (is_null($kortingOmschr) || (is_array($kortingOmschr) && empty($kortingOmschr))) {
            unset($this->kortingOmschr);
        } else {
            $this->kortingOmschr = $kortingOmschr;
        }
        return $this;
    }
    /**
     * Get kortingStaffel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKortingStaffel()
    {
        return isset($this->kortingStaffel) ? $this->kortingStaffel : null;
    }
    /**
     * Set kortingStaffel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kortingStaffel
     * @return \VoorraadApiV5\StructType\OrderregelRecV5
     */
    public function setKortingStaffel($kortingStaffel = null)
    {
        // validation for constraint: float
        if (!is_null($kortingStaffel) && !(is_float($kortingStaffel) || is_numeric($kortingStaffel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kortingStaffel, true), gettype($kortingStaffel)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($kortingStaffel) && mb_strlen(preg_replace('/(\D)/', '', $kortingStaffel)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($kortingStaffel, true), mb_strlen(preg_replace('/(\D)/', '', $kortingStaffel))), __LINE__);
        }
        if (is_null($kortingStaffel) || (is_array($kortingStaffel) && empty($kortingStaffel))) {
            unset($this->kortingStaffel);
        } else {
            $this->kortingStaffel = $kortingStaffel;
        }
        return $this;
    }
    /**
     * Get kortingStaffelPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKortingStaffelPercentage()
    {
        return isset($this->kortingStaffelPercentage) ? $this->kortingStaffelPercentage : null;
    }
    /**
     * Set kortingStaffelPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kortingStaffelPercentage
     * @return \VoorraadApiV5\StructType\OrderregelRecV5
     */
    public function setKortingStaffelPercentage($kortingStaffelPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($kortingStaffelPercentage) && !(is_float($kortingStaffelPercentage) || is_numeric($kortingStaffelPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kortingStaffelPercentage, true), gettype($kortingStaffelPercentage)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($kortingStaffelPercentage) && mb_strlen(preg_replace('/(\D)/', '', $kortingStaffelPercentage)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($kortingStaffelPercentage, true), mb_strlen(preg_replace('/(\D)/', '', $kortingStaffelPercentage))), __LINE__);
        }
        if (is_null($kortingStaffelPercentage) || (is_array($kortingStaffelPercentage) && empty($kortingStaffelPercentage))) {
            unset($this->kortingStaffelPercentage);
        } else {
            $this->kortingStaffelPercentage = $kortingStaffelPercentage;
        }
        return $this;
    }
    /**
     * Get kortingPrijsmatrix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKortingPrijsmatrix()
    {
        return isset($this->kortingPrijsmatrix) ? $this->kortingPrijsmatrix : null;
    }
    /**
     * Set kortingPrijsmatrix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kortingPrijsmatrix
     * @return \VoorraadApiV5\StructType\OrderregelRecV5
     */
    public function setKortingPrijsmatrix($kortingPrijsmatrix = null)
    {
        // validation for constraint: float
        if (!is_null($kortingPrijsmatrix) && !(is_float($kortingPrijsmatrix) || is_numeric($kortingPrijsmatrix))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kortingPrijsmatrix, true), gettype($kortingPrijsmatrix)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($kortingPrijsmatrix) && mb_strlen(preg_replace('/(\D)/', '', $kortingPrijsmatrix)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($kortingPrijsmatrix, true), mb_strlen(preg_replace('/(\D)/', '', $kortingPrijsmatrix))), __LINE__);
        }
        if (is_null($kortingPrijsmatrix) || (is_array($kortingPrijsmatrix) && empty($kortingPrijsmatrix))) {
            unset($this->kortingPrijsmatrix);
        } else {
            $this->kortingPrijsmatrix = $kortingPrijsmatrix;
        }
        return $this;
    }
    /**
     * Get kortingPrijsmatrixPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKortingPrijsmatrixPercentage()
    {
        return isset($this->kortingPrijsmatrixPercentage) ? $this->kortingPrijsmatrixPercentage : null;
    }
    /**
     * Set kortingPrijsmatrixPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kortingPrijsmatrixPercentage
     * @return \VoorraadApiV5\StructType\OrderregelRecV5
     */
    public function setKortingPrijsmatrixPercentage($kortingPrijsmatrixPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($kortingPrijsmatrixPercentage) && !(is_float($kortingPrijsmatrixPercentage) || is_numeric($kortingPrijsmatrixPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kortingPrijsmatrixPercentage, true), gettype($kortingPrijsmatrixPercentage)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($kortingPrijsmatrixPercentage) && mb_strlen(mb_substr($kortingPrijsmatrixPercentage, mb_strpos($kortingPrijsmatrixPercentage, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($kortingPrijsmatrixPercentage, true), mb_strlen(mb_substr($kortingPrijsmatrixPercentage, mb_strpos($kortingPrijsmatrixPercentage, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($kortingPrijsmatrixPercentage) && mb_strlen(preg_replace('/(\D)/', '', $kortingPrijsmatrixPercentage)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($kortingPrijsmatrixPercentage, true), mb_strlen(preg_replace('/(\D)/', '', $kortingPrijsmatrixPercentage))), __LINE__);
        }
        if (is_null($kortingPrijsmatrixPercentage) || (is_array($kortingPrijsmatrixPercentage) && empty($kortingPrijsmatrixPercentage))) {
            unset($this->kortingPrijsmatrixPercentage);
        } else {
            $this->kortingPrijsmatrixPercentage = $kortingPrijsmatrixPercentage;
        }
        return $this;
    }
    /**
     * Get kortingPrijsmatrixOmschr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKortingPrijsmatrixOmschr()
    {
        return isset($this->kortingPrijsmatrixOmschr) ? $this->kortingPrijsmatrixOmschr : null;
    }
    /**
     * Set kortingPrijsmatrixOmschr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kortingPrijsmatrixOmschr
     * @return \VoorraadApiV5\StructType\OrderregelRecV5
     */
    public function setKortingPrijsmatrixOmschr($kortingPrijsmatrixOmschr = null)
    {
        // validation for constraint: string
        if (!is_null($kortingPrijsmatrixOmschr) && !is_string($kortingPrijsmatrixOmschr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kortingPrijsmatrixOmschr, true), gettype($kortingPrijsmatrixOmschr)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($kortingPrijsmatrixOmschr) && mb_strlen($kortingPrijsmatrixOmschr) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($kortingPrijsmatrixOmschr)), __LINE__);
        }
        if (is_null($kortingPrijsmatrixOmschr) || (is_array($kortingPrijsmatrixOmschr) && empty($kortingPrijsmatrixOmschr))) {
            unset($this->kortingPrijsmatrixOmschr);
        } else {
            $this->kortingPrijsmatrixOmschr = $kortingPrijsmatrixOmschr;
        }
        return $this;
    }
    /**
     * Get kortingOrdersoort value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKortingOrdersoort()
    {
        return isset($this->kortingOrdersoort) ? $this->kortingOrdersoort : null;
    }
    /**
     * Set kortingOrdersoort value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kortingOrdersoort
     * @return \VoorraadApiV5\StructType\OrderregelRecV5
     */
    public function setKortingOrdersoort($kortingOrdersoort = null)
    {
        // validation for constraint: float
        if (!is_null($kortingOrdersoort) && !(is_float($kortingOrdersoort) || is_numeric($kortingOrdersoort))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kortingOrdersoort, true), gettype($kortingOrdersoort)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($kortingOrdersoort) && mb_strlen(preg_replace('/(\D)/', '', $kortingOrdersoort)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($kortingOrdersoort, true), mb_strlen(preg_replace('/(\D)/', '', $kortingOrdersoort))), __LINE__);
        }
        if (is_null($kortingOrdersoort) || (is_array($kortingOrdersoort) && empty($kortingOrdersoort))) {
            unset($this->kortingOrdersoort);
        } else {
            $this->kortingOrdersoort = $kortingOrdersoort;
        }
        return $this;
    }
    /**
     * Get kortingOrdersoortPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getKortingOrdersoortPercentage()
    {
        return isset($this->kortingOrdersoortPercentage) ? $this->kortingOrdersoortPercentage : null;
    }
    /**
     * Set kortingOrdersoortPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $kortingOrdersoortPercentage
     * @return \VoorraadApiV5\StructType\OrderregelRecV5
     */
    public function setKortingOrdersoortPercentage($kortingOrdersoortPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($kortingOrdersoortPercentage) && !(is_float($kortingOrdersoortPercentage) || is_numeric($kortingOrdersoortPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kortingOrdersoortPercentage, true), gettype($kortingOrdersoortPercentage)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($kortingOrdersoortPercentage) && mb_strlen(mb_substr($kortingOrdersoortPercentage, mb_strpos($kortingOrdersoortPercentage, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($kortingOrdersoortPercentage, true), mb_strlen(mb_substr($kortingOrdersoortPercentage, mb_strpos($kortingOrdersoortPercentage, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($kortingOrdersoortPercentage) && mb_strlen(preg_replace('/(\D)/', '', $kortingOrdersoortPercentage)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($kortingOrdersoortPercentage, true), mb_strlen(preg_replace('/(\D)/', '', $kortingOrdersoortPercentage))), __LINE__);
        }
        if (is_null($kortingOrdersoortPercentage) || (is_array($kortingOrdersoortPercentage) && empty($kortingOrdersoortPercentage))) {
            unset($this->kortingOrdersoortPercentage);
        } else {
            $this->kortingOrdersoortPercentage = $kortingOrdersoortPercentage;
        }
        return $this;
    }
    /**
     * Get kortingOrdersoortOmschr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKortingOrdersoortOmschr()
    {
        return isset($this->kortingOrdersoortOmschr) ? $this->kortingOrdersoortOmschr : null;
    }
    /**
     * Set kortingOrdersoortOmschr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kortingOrdersoortOmschr
     * @return \VoorraadApiV5\StructType\OrderregelRecV5
     */
    public function setKortingOrdersoortOmschr($kortingOrdersoortOmschr = null)
    {
        // validation for constraint: string
        if (!is_null($kortingOrdersoortOmschr) && !is_string($kortingOrdersoortOmschr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kortingOrdersoortOmschr, true), gettype($kortingOrdersoortOmschr)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($kortingOrdersoortOmschr) && mb_strlen($kortingOrdersoortOmschr) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($kortingOrdersoortOmschr)), __LINE__);
        }
        if (is_null($kortingOrdersoortOmschr) || (is_array($kortingOrdersoortOmschr) && empty($kortingOrdersoortOmschr))) {
            unset($this->kortingOrdersoortOmschr);
        } else {
            $this->kortingOrdersoortOmschr = $kortingOrdersoortOmschr;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\OrderregelRecV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
