<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MagazijnRecV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Magazijn
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class MagazijnRecV5 extends AbstractStructBase
{
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - documentation: Code van het magazijn
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $code;
    /**
     * The naam
     * Meta informations extracted from the WSDL
     * - documentation: Omschrijving van het magazijn
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $naam;
    /**
     * The relatieNummer
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer van de eigenaar van het magazijn
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relatieNummer;
    /**
     * The isCbMagazijn
     * Meta informations extracted from the WSDL
     * - documentation: Indictie die aangeeft of het betreffende magazijn, het magazijn van het CB is.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var bool
     */
    public $isCbMagazijn;
    /**
     * Constructor method for MagazijnRecV5
     * @uses MagazijnRecV5::setCode()
     * @uses MagazijnRecV5::setNaam()
     * @uses MagazijnRecV5::setRelatieNummer()
     * @uses MagazijnRecV5::setIsCbMagazijn()
     * @param string $code
     * @param string $naam
     * @param int $relatieNummer
     * @param bool $isCbMagazijn
     */
    public function __construct($code = null, $naam = null, $relatieNummer = null, $isCbMagazijn = null)
    {
        $this
            ->setCode($code)
            ->setNaam($naam)
            ->setRelatieNummer($relatieNummer)
            ->setIsCbMagazijn($isCbMagazijn);
    }
    /**
     * Get code value
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \VoorraadApiV5\StructType\MagazijnRecV5
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($code) && mb_strlen($code) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($code)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($code) && mb_strlen($code) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get naam value
     * @return string
     */
    public function getNaam()
    {
        return $this->naam;
    }
    /**
     * Set naam value
     * @param string $naam
     * @return \VoorraadApiV5\StructType\MagazijnRecV5
     */
    public function setNaam($naam = null)
    {
        // validation for constraint: string
        if (!is_null($naam) && !is_string($naam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naam, true), gettype($naam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($naam) && mb_strlen($naam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($naam)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($naam) && mb_strlen($naam) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($naam)), __LINE__);
        }
        $this->naam = $naam;
        return $this;
    }
    /**
     * Get relatieNummer value
     * @return int
     */
    public function getRelatieNummer()
    {
        return $this->relatieNummer;
    }
    /**
     * Set relatieNummer value
     * @param int $relatieNummer
     * @return \VoorraadApiV5\StructType\MagazijnRecV5
     */
    public function setRelatieNummer($relatieNummer = null)
    {
        // validation for constraint: int
        if (!is_null($relatieNummer) && !(is_int($relatieNummer) || ctype_digit($relatieNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatieNummer, true), gettype($relatieNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatieNummer) && mb_strlen(preg_replace('/(\D)/', '', $relatieNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatieNummer, true), mb_strlen(preg_replace('/(\D)/', '', $relatieNummer))), __LINE__);
        }
        $this->relatieNummer = $relatieNummer;
        return $this;
    }
    /**
     * Get isCbMagazijn value
     * @return bool
     */
    public function getIsCbMagazijn()
    {
        return $this->isCbMagazijn;
    }
    /**
     * Set isCbMagazijn value
     * @param bool $isCbMagazijn
     * @return \VoorraadApiV5\StructType\MagazijnRecV5
     */
    public function setIsCbMagazijn($isCbMagazijn = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCbMagazijn) && !is_bool($isCbMagazijn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCbMagazijn, true), gettype($isCbMagazijn)), __LINE__);
        }
        $this->isCbMagazijn = $isCbMagazijn;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\MagazijnRecV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
