<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getLeverantiesRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ophalen van de leverantieregels van de leveranties die voor een relatie aangemaakt zijn. Hierbij kunnen de verschijningsvorm, het leverantienummer en het originele verkoopordernummer als filter opgegeven worden.
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class GetLeverantiesRequest extends AbstractStructBase
{
    /**
     * The relatieNummer
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer van de ontvanger van de verkooporder.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relatieNummer;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The verschijningsvormCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de verschijningsvorm (indien leeg worden artikelen met alle verschijningsvormen geretourneerd).
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $verschijningsvormCode;
    /**
     * The leverantieNummer
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van de leverantie (indien leeg worden artikelen uit alle leveranties voor de relatie geretourneerd).
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $leverantieNummer;
    /**
     * The orderNummer
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van de verkooporder, om leveranties behorende bij deze verkooporder op te halen
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $orderNummer;
    /**
     * Constructor method for getLeverantiesRequest
     * @uses GetLeverantiesRequest::setRelatieNummer()
     * @uses GetLeverantiesRequest::setRequestTag()
     * @uses GetLeverantiesRequest::setVerschijningsvormCode()
     * @uses GetLeverantiesRequest::setLeverantieNummer()
     * @uses GetLeverantiesRequest::setOrderNummer()
     * @param int $relatieNummer
     * @param string $requestTag
     * @param string $verschijningsvormCode
     * @param int $leverantieNummer
     * @param int $orderNummer
     */
    public function __construct($relatieNummer = null, $requestTag = null, $verschijningsvormCode = null, $leverantieNummer = null, $orderNummer = null)
    {
        $this
            ->setRelatieNummer($relatieNummer)
            ->setRequestTag($requestTag)
            ->setVerschijningsvormCode($verschijningsvormCode)
            ->setLeverantieNummer($leverantieNummer)
            ->setOrderNummer($orderNummer);
    }
    /**
     * Get relatieNummer value
     * @return int
     */
    public function getRelatieNummer()
    {
        return $this->relatieNummer;
    }
    /**
     * Set relatieNummer value
     * @param int $relatieNummer
     * @return \VoorraadApiV5\StructType\GetLeverantiesRequest
     */
    public function setRelatieNummer($relatieNummer = null)
    {
        // validation for constraint: int
        if (!is_null($relatieNummer) && !(is_int($relatieNummer) || ctype_digit($relatieNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatieNummer, true), gettype($relatieNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatieNummer) && mb_strlen(preg_replace('/(\D)/', '', $relatieNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatieNummer, true), mb_strlen(preg_replace('/(\D)/', '', $relatieNummer))), __LINE__);
        }
        $this->relatieNummer = $relatieNummer;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \VoorraadApiV5\StructType\GetLeverantiesRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get verschijningsvormCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVerschijningsvormCode()
    {
        return isset($this->verschijningsvormCode) ? $this->verschijningsvormCode : null;
    }
    /**
     * Set verschijningsvormCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $verschijningsvormCode
     * @return \VoorraadApiV5\StructType\GetLeverantiesRequest
     */
    public function setVerschijningsvormCode($verschijningsvormCode = null)
    {
        // validation for constraint: string
        if (!is_null($verschijningsvormCode) && !is_string($verschijningsvormCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($verschijningsvormCode, true), gettype($verschijningsvormCode)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($verschijningsvormCode) && mb_strlen($verschijningsvormCode) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($verschijningsvormCode)), __LINE__);
        }
        if (is_null($verschijningsvormCode) || (is_array($verschijningsvormCode) && empty($verschijningsvormCode))) {
            unset($this->verschijningsvormCode);
        } else {
            $this->verschijningsvormCode = $verschijningsvormCode;
        }
        return $this;
    }
    /**
     * Get leverantieNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLeverantieNummer()
    {
        return isset($this->leverantieNummer) ? $this->leverantieNummer : null;
    }
    /**
     * Set leverantieNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $leverantieNummer
     * @return \VoorraadApiV5\StructType\GetLeverantiesRequest
     */
    public function setLeverantieNummer($leverantieNummer = null)
    {
        // validation for constraint: int
        if (!is_null($leverantieNummer) && !(is_int($leverantieNummer) || ctype_digit($leverantieNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($leverantieNummer, true), gettype($leverantieNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($leverantieNummer) && mb_strlen(preg_replace('/(\D)/', '', $leverantieNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($leverantieNummer, true), mb_strlen(preg_replace('/(\D)/', '', $leverantieNummer))), __LINE__);
        }
        if (is_null($leverantieNummer) || (is_array($leverantieNummer) && empty($leverantieNummer))) {
            unset($this->leverantieNummer);
        } else {
            $this->leverantieNummer = $leverantieNummer;
        }
        return $this;
    }
    /**
     * Get orderNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrderNummer()
    {
        return isset($this->orderNummer) ? $this->orderNummer : null;
    }
    /**
     * Set orderNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $orderNummer
     * @return \VoorraadApiV5\StructType\GetLeverantiesRequest
     */
    public function setOrderNummer($orderNummer = null)
    {
        // validation for constraint: int
        if (!is_null($orderNummer) && !(is_int($orderNummer) || ctype_digit($orderNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderNummer, true), gettype($orderNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($orderNummer) && mb_strlen(preg_replace('/(\D)/', '', $orderNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($orderNummer, true), mb_strlen(preg_replace('/(\D)/', '', $orderNummer))), __LINE__);
        }
        if (is_null($orderNummer) || (is_array($orderNummer) && empty($orderNummer))) {
            unset($this->orderNummer);
        } else {
            $this->orderNummer = $orderNummer;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\GetLeverantiesRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
