<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getFondsenPerGroepRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ophalen fondsen per fondsgroep.
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class GetFondsenPerGroepRequest extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The fondsGroepCode
     * Meta informations extracted from the WSDL
     * - documentation: De code van de fondsgroep waarvan de fondsen moeten worden opgehaald.
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $fondsGroepCode;
    /**
     * Constructor method for getFondsenPerGroepRequest
     * @uses GetFondsenPerGroepRequest::setRequestTag()
     * @uses GetFondsenPerGroepRequest::setFondsGroepCode()
     * @param string $requestTag
     * @param string $fondsGroepCode
     */
    public function __construct($requestTag = null, $fondsGroepCode = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setFondsGroepCode($fondsGroepCode);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \VoorraadApiV5\StructType\GetFondsenPerGroepRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get fondsGroepCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFondsGroepCode()
    {
        return isset($this->fondsGroepCode) ? $this->fondsGroepCode : null;
    }
    /**
     * Set fondsGroepCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fondsGroepCode
     * @return \VoorraadApiV5\StructType\GetFondsenPerGroepRequest
     */
    public function setFondsGroepCode($fondsGroepCode = null)
    {
        // validation for constraint: string
        if (!is_null($fondsGroepCode) && !is_string($fondsGroepCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fondsGroepCode, true), gettype($fondsGroepCode)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($fondsGroepCode) && mb_strlen($fondsGroepCode) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($fondsGroepCode)), __LINE__);
        }
        if (is_null($fondsGroepCode) || (is_array($fondsGroepCode) && empty($fondsGroepCode))) {
            unset($this->fondsGroepCode);
        } else {
            $this->fondsGroepCode = $fondsGroepCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\GetFondsenPerGroepRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
