<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FondsTableV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met beschikbare fondsen.
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class FondsTableV5 extends AbstractStructBase
{
    /**
     * The fonds
     * Meta informations extracted from the WSDL
     * - documentation: Fonds
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \VoorraadApiV5\StructType\FondsRecV5[]
     */
    public $fonds;
    /**
     * Constructor method for FondsTableV5
     * @uses FondsTableV5::setFonds()
     * @param \VoorraadApiV5\StructType\FondsRecV5[] $fonds
     */
    public function __construct(array $fonds = array())
    {
        $this
            ->setFonds($fonds);
    }
    /**
     * Get fonds value
     * @return \VoorraadApiV5\StructType\FondsRecV5[]|null
     */
    public function getFonds()
    {
        return $this->fonds;
    }
    /**
     * This method is responsible for validating the values passed to the setFonds method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFonds method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFondsForArrayConstraintsFromSetFonds(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $fondsTableV5FondsItem) {
            // validation for constraint: itemType
            if (!$fondsTableV5FondsItem instanceof \VoorraadApiV5\StructType\FondsRecV5) {
                $invalidValues[] = is_object($fondsTableV5FondsItem) ? get_class($fondsTableV5FondsItem) : sprintf('%s(%s)', gettype($fondsTableV5FondsItem), var_export($fondsTableV5FondsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The fonds property can only contain items of type \VoorraadApiV5\StructType\FondsRecV5, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set fonds value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\FondsRecV5[] $fonds
     * @return \VoorraadApiV5\StructType\FondsTableV5
     */
    public function setFonds(array $fonds = array())
    {
        // validation for constraint: array
        if ('' !== ($fondsArrayErrorMessage = self::validateFondsForArrayConstraintsFromSetFonds($fonds))) {
            throw new \InvalidArgumentException($fondsArrayErrorMessage, __LINE__);
        }
        $this->fonds = $fonds;
        return $this;
    }
    /**
     * Add item to fonds value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\FondsRecV5 $item
     * @return \VoorraadApiV5\StructType\FondsTableV5
     */
    public function addToFonds(\VoorraadApiV5\StructType\FondsRecV5 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \VoorraadApiV5\StructType\FondsRecV5) {
            throw new \InvalidArgumentException(sprintf('The fonds property can only contain items of type \VoorraadApiV5\StructType\FondsRecV5, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->fonds[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\FondsTableV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
