<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createArtikelRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Aanmaken van een nieuw artikel
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class CreateArtikelRequest extends AbstractStructBase
{
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - documentation: De code van het aan te maken artikel
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $code;
    /**
     * The artikelgroepCode
     * Meta informations extracted from the WSDL
     * - documentation: De code van de artikelgroep waar het artikel aan gekoppeld moet worden
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $artikelgroepCode;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The omschrijving
     * Meta informations extracted from the WSDL
     * - documentation: Omschrijving van het artikel
     * - base: xsd:string
     * - maxLength: 500
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $omschrijving;
    /**
     * The prijs
     * Meta informations extracted from the WSDL
     * - documentation: De nieuwe prijs van het artikel
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $prijs;
    /**
     * The prijsIsInclBtw
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of de meegegeven prijs inclusief btw is. true: De prijs is inclusief BTW, false (Default): De prijs is exclusief btw
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $prijsIsInclBtw;
    /**
     * The btwCode
     * Meta informations extracted from the WSDL
     * - documentation: De te gebruiken BTW code voor het artikel
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $btwCode;
    /**
     * The vrijTekstveld8
     * Meta informations extracted from the WSDL
     * - documentation: De tekst voor vrij tekstveld 8
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $vrijTekstveld8;
    /**
     * Constructor method for createArtikelRequest
     * @uses CreateArtikelRequest::setCode()
     * @uses CreateArtikelRequest::setArtikelgroepCode()
     * @uses CreateArtikelRequest::setRequestTag()
     * @uses CreateArtikelRequest::setOmschrijving()
     * @uses CreateArtikelRequest::setPrijs()
     * @uses CreateArtikelRequest::setPrijsIsInclBtw()
     * @uses CreateArtikelRequest::setBtwCode()
     * @uses CreateArtikelRequest::setVrijTekstveld8()
     * @param string $code
     * @param string $artikelgroepCode
     * @param string $requestTag
     * @param string $omschrijving
     * @param float $prijs
     * @param bool $prijsIsInclBtw
     * @param string $btwCode
     * @param string $vrijTekstveld8
     */
    public function __construct($code = null, $artikelgroepCode = null, $requestTag = null, $omschrijving = null, $prijs = null, $prijsIsInclBtw = null, $btwCode = null, $vrijTekstveld8 = null)
    {
        $this
            ->setCode($code)
            ->setArtikelgroepCode($artikelgroepCode)
            ->setRequestTag($requestTag)
            ->setOmschrijving($omschrijving)
            ->setPrijs($prijs)
            ->setPrijsIsInclBtw($prijsIsInclBtw)
            ->setBtwCode($btwCode)
            ->setVrijTekstveld8($vrijTekstveld8);
    }
    /**
     * Get code value
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \VoorraadApiV5\StructType\CreateArtikelRequest
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($code) && mb_strlen($code) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($code)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($code) && mb_strlen($code) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get artikelgroepCode value
     * @return string
     */
    public function getArtikelgroepCode()
    {
        return $this->artikelgroepCode;
    }
    /**
     * Set artikelgroepCode value
     * @param string $artikelgroepCode
     * @return \VoorraadApiV5\StructType\CreateArtikelRequest
     */
    public function setArtikelgroepCode($artikelgroepCode = null)
    {
        // validation for constraint: string
        if (!is_null($artikelgroepCode) && !is_string($artikelgroepCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($artikelgroepCode, true), gettype($artikelgroepCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($artikelgroepCode) && mb_strlen($artikelgroepCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($artikelgroepCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($artikelgroepCode) && mb_strlen($artikelgroepCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($artikelgroepCode)), __LINE__);
        }
        $this->artikelgroepCode = $artikelgroepCode;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \VoorraadApiV5\StructType\CreateArtikelRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get omschrijving value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOmschrijving()
    {
        return isset($this->omschrijving) ? $this->omschrijving : null;
    }
    /**
     * Set omschrijving value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $omschrijving
     * @return \VoorraadApiV5\StructType\CreateArtikelRequest
     */
    public function setOmschrijving($omschrijving = null)
    {
        // validation for constraint: string
        if (!is_null($omschrijving) && !is_string($omschrijving)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($omschrijving, true), gettype($omschrijving)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($omschrijving) && mb_strlen($omschrijving) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($omschrijving)), __LINE__);
        }
        if (is_null($omschrijving) || (is_array($omschrijving) && empty($omschrijving))) {
            unset($this->omschrijving);
        } else {
            $this->omschrijving = $omschrijving;
        }
        return $this;
    }
    /**
     * Get prijs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrijs()
    {
        return isset($this->prijs) ? $this->prijs : null;
    }
    /**
     * Set prijs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prijs
     * @return \VoorraadApiV5\StructType\CreateArtikelRequest
     */
    public function setPrijs($prijs = null)
    {
        // validation for constraint: float
        if (!is_null($prijs) && !(is_float($prijs) || is_numeric($prijs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prijs, true), gettype($prijs)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($prijs) && mb_strlen(preg_replace('/(\D)/', '', $prijs)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($prijs, true), mb_strlen(preg_replace('/(\D)/', '', $prijs))), __LINE__);
        }
        if (is_null($prijs) || (is_array($prijs) && empty($prijs))) {
            unset($this->prijs);
        } else {
            $this->prijs = $prijs;
        }
        return $this;
    }
    /**
     * Get prijsIsInclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPrijsIsInclBtw()
    {
        return isset($this->prijsIsInclBtw) ? $this->prijsIsInclBtw : null;
    }
    /**
     * Set prijsIsInclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $prijsIsInclBtw
     * @return \VoorraadApiV5\StructType\CreateArtikelRequest
     */
    public function setPrijsIsInclBtw($prijsIsInclBtw = null)
    {
        // validation for constraint: boolean
        if (!is_null($prijsIsInclBtw) && !is_bool($prijsIsInclBtw)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($prijsIsInclBtw, true), gettype($prijsIsInclBtw)), __LINE__);
        }
        if (is_null($prijsIsInclBtw) || (is_array($prijsIsInclBtw) && empty($prijsIsInclBtw))) {
            unset($this->prijsIsInclBtw);
        } else {
            $this->prijsIsInclBtw = $prijsIsInclBtw;
        }
        return $this;
    }
    /**
     * Get btwCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBtwCode()
    {
        return isset($this->btwCode) ? $this->btwCode : null;
    }
    /**
     * Set btwCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $btwCode
     * @return \VoorraadApiV5\StructType\CreateArtikelRequest
     */
    public function setBtwCode($btwCode = null)
    {
        // validation for constraint: string
        if (!is_null($btwCode) && !is_string($btwCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($btwCode, true), gettype($btwCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($btwCode) && mb_strlen($btwCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($btwCode)), __LINE__);
        }
        if (is_null($btwCode) || (is_array($btwCode) && empty($btwCode))) {
            unset($this->btwCode);
        } else {
            $this->btwCode = $btwCode;
        }
        return $this;
    }
    /**
     * Get vrijTekstveld8 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVrijTekstveld8()
    {
        return isset($this->vrijTekstveld8) ? $this->vrijTekstveld8 : null;
    }
    /**
     * Set vrijTekstveld8 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vrijTekstveld8
     * @return \VoorraadApiV5\StructType\CreateArtikelRequest
     */
    public function setVrijTekstveld8($vrijTekstveld8 = null)
    {
        // validation for constraint: string
        if (!is_null($vrijTekstveld8) && !is_string($vrijTekstveld8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vrijTekstveld8, true), gettype($vrijTekstveld8)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($vrijTekstveld8) && mb_strlen($vrijTekstveld8) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($vrijTekstveld8)), __LINE__);
        }
        if (is_null($vrijTekstveld8) || (is_array($vrijTekstveld8) && empty($vrijTekstveld8))) {
            unset($this->vrijTekstveld8);
        } else {
            $this->vrijTekstveld8 = $vrijTekstveld8;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\CreateArtikelRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
