<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArtikelStaffelTableV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: lijst met staffelprijzen
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class ArtikelStaffelTableV5 extends AbstractStructBase
{
    /**
     * The staffelprijs
     * Meta informations extracted from the WSDL
     * - documentation: ArtikelStaffelprijzenRec
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \VoorraadApiV5\StructType\ArtikelStaffelRecV5[]
     */
    public $staffelprijs;
    /**
     * Constructor method for ArtikelStaffelTableV5
     * @uses ArtikelStaffelTableV5::setStaffelprijs()
     * @param \VoorraadApiV5\StructType\ArtikelStaffelRecV5[] $staffelprijs
     */
    public function __construct(array $staffelprijs = array())
    {
        $this
            ->setStaffelprijs($staffelprijs);
    }
    /**
     * Get staffelprijs value
     * @return \VoorraadApiV5\StructType\ArtikelStaffelRecV5[]|null
     */
    public function getStaffelprijs()
    {
        return $this->staffelprijs;
    }
    /**
     * This method is responsible for validating the values passed to the setStaffelprijs method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStaffelprijs method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStaffelprijsForArrayConstraintsFromSetStaffelprijs(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $artikelStaffelTableV5StaffelprijsItem) {
            // validation for constraint: itemType
            if (!$artikelStaffelTableV5StaffelprijsItem instanceof \VoorraadApiV5\StructType\ArtikelStaffelRecV5) {
                $invalidValues[] = is_object($artikelStaffelTableV5StaffelprijsItem) ? get_class($artikelStaffelTableV5StaffelprijsItem) : sprintf('%s(%s)', gettype($artikelStaffelTableV5StaffelprijsItem), var_export($artikelStaffelTableV5StaffelprijsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The staffelprijs property can only contain items of type \VoorraadApiV5\StructType\ArtikelStaffelRecV5, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set staffelprijs value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\ArtikelStaffelRecV5[] $staffelprijs
     * @return \VoorraadApiV5\StructType\ArtikelStaffelTableV5
     */
    public function setStaffelprijs(array $staffelprijs = array())
    {
        // validation for constraint: array
        if ('' !== ($staffelprijsArrayErrorMessage = self::validateStaffelprijsForArrayConstraintsFromSetStaffelprijs($staffelprijs))) {
            throw new \InvalidArgumentException($staffelprijsArrayErrorMessage, __LINE__);
        }
        $this->staffelprijs = $staffelprijs;
        return $this;
    }
    /**
     * Add item to staffelprijs value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\ArtikelStaffelRecV5 $item
     * @return \VoorraadApiV5\StructType\ArtikelStaffelTableV5
     */
    public function addToStaffelprijs(\VoorraadApiV5\StructType\ArtikelStaffelRecV5 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \VoorraadApiV5\StructType\ArtikelStaffelRecV5) {
            throw new \InvalidArgumentException(sprintf('The staffelprijs property can only contain items of type \VoorraadApiV5\StructType\ArtikelStaffelRecV5, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->staffelprijs[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\ArtikelStaffelTableV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
