<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \VoorraadApiV5\ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \VoorraadApiV5\ServiceType\Get($options);
$get->setSoapHeaderAuthentication(new \VoorraadApiV5\StructType\Authentication());
/**
 * Sample call for getFondsGroepen operation/method
 */
if ($get->getFondsGroepen(new \VoorraadApiV5\StructType\GetFondsGroepenRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getFondsenPerGroep operation/method
 */
if ($get->getFondsenPerGroep(new \VoorraadApiV5\StructType\GetFondsenPerGroepRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getArtikelInfo operation/method
 */
if ($get->getArtikelInfo(new \VoorraadApiV5\StructType\GetArtikelInfoRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getArtikelLijstInfo operation/method
 */
if ($get->getArtikelLijstInfo(new \VoorraadApiV5\StructType\GetArtikelLijstInfoRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVoorraadInfo operation/method
 */
if ($get->getVoorraadInfo(new \VoorraadApiV5\StructType\GetVoorraadInfoRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVoorraadLijstInfo operation/method
 */
if ($get->getVoorraadLijstInfo(new \VoorraadApiV5\StructType\GetVoorraadLijstInfoRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVerkoopOrders operation/method
 */
if ($get->getVerkoopOrders(new \VoorraadApiV5\StructType\GetVerkoopOrdersRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getOrdersoorten operation/method
 */
if ($get->getOrdersoorten(new \VoorraadApiV5\StructType\GetOrdersoortenRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVerzendwijzen operation/method
 */
if ($get->getVerzendwijzen(new \VoorraadApiV5\StructType\GetVerzendwijzenRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRelatieArtikelPrijs operation/method
 */
if ($get->getRelatieArtikelPrijs(new \VoorraadApiV5\StructType\GetRelatieArtikelPrijsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVerschijningsvormen operation/method
 */
if ($get->getVerschijningsvormen(new \VoorraadApiV5\StructType\GetVerschijningsvormenRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getRelatieArtikelen operation/method
 */
if ($get->getRelatieArtikelen(new \VoorraadApiV5\StructType\GetRelatieArtikelenRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getLeveranties operation/method
 */
if ($get->getLeveranties(new \VoorraadApiV5\StructType\GetLeverantiesRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \VoorraadApiV5\ServiceType\Create($options);
$create->setSoapHeaderAuthentication(new \VoorraadApiV5\StructType\Authentication());
/**
 * Sample call for createVerkoopOrder operation/method
 */
if ($create->createVerkoopOrder(new \VoorraadApiV5\StructType\CreateVerkoopOrderRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createArtikel operation/method
 */
if ($create->createArtikel(new \VoorraadApiV5\StructType\CreateArtikelRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createLeverantie operation/method
 */
if ($create->createLeverantie(new \VoorraadApiV5\StructType\CreateLeverantieRequest()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Order ServiceType
 */
$order = new \VoorraadApiV5\ServiceType\Order($options);
$order->setSoapHeaderAuthentication(new \VoorraadApiV5\StructType\Authentication());
/**
 * Sample call for orderEBooks operation/method
 */
if ($order->orderEBooks(new \VoorraadApiV5\StructType\OrderEBooksRequest()) !== false) {
    print_r($order->getResult());
} else {
    print_r($order->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \VoorraadApiV5\ServiceType\Update($options);
$update->setSoapHeaderAuthentication(new \VoorraadApiV5\StructType\Authentication());
/**
 * Sample call for updateArtikel operation/method
 */
if ($update->updateArtikel(new \VoorraadApiV5\StructType\UpdateArtikelRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
