<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerkooporderInfoTabV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Verkooporders
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class VerkooporderInfoTabV5 extends AbstractStructBase
{
    /**
     * The order
     * Meta informations extracted from the WSDL
     * - documentation: verkooporder
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - nillable: false
     * @var \VoorraadApiV5\StructType\VerkooporderInfoRecV5[]
     */
    public $order;
    /**
     * Constructor method for VerkooporderInfoTabV5
     * @uses VerkooporderInfoTabV5::setOrder()
     * @param \VoorraadApiV5\StructType\VerkooporderInfoRecV5[] $order
     */
    public function __construct(array $order = array())
    {
        $this
            ->setOrder($order);
    }
    /**
     * Get order value
     * @return \VoorraadApiV5\StructType\VerkooporderInfoRecV5[]
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * This method is responsible for validating the values passed to the setOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderForArrayConstraintsFromSetOrder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $verkooporderInfoTabV5OrderItem) {
            // validation for constraint: itemType
            if (!$verkooporderInfoTabV5OrderItem instanceof \VoorraadApiV5\StructType\VerkooporderInfoRecV5) {
                $invalidValues[] = is_object($verkooporderInfoTabV5OrderItem) ? get_class($verkooporderInfoTabV5OrderItem) : sprintf('%s(%s)', gettype($verkooporderInfoTabV5OrderItem), var_export($verkooporderInfoTabV5OrderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The order property can only contain items of type \VoorraadApiV5\StructType\VerkooporderInfoRecV5, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set order value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\VerkooporderInfoRecV5[] $order
     * @return \VoorraadApiV5\StructType\VerkooporderInfoTabV5
     */
    public function setOrder(array $order = array())
    {
        // validation for constraint: array
        if ('' !== ($orderArrayErrorMessage = self::validateOrderForArrayConstraintsFromSetOrder($order))) {
            throw new \InvalidArgumentException($orderArrayErrorMessage, __LINE__);
        }
        $this->order = $order;
        return $this;
    }
    /**
     * Add item to order value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\VerkooporderInfoRecV5 $item
     * @return \VoorraadApiV5\StructType\VerkooporderInfoTabV5
     */
    public function addToOrder(\VoorraadApiV5\StructType\VerkooporderInfoRecV5 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \VoorraadApiV5\StructType\VerkooporderInfoRecV5) {
            throw new \InvalidArgumentException(sprintf('The order property can only contain items of type \VoorraadApiV5\StructType\VerkooporderInfoRecV5, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->order[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\VerkooporderInfoTabV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
