<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatieArtikelRecV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Bij de relatie als orderregel aanwezige artikelen
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class RelatieArtikelRecV5 extends AbstractStructBase
{
    /**
     * The ordernummer
     * Meta informations extracted from the WSDL
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $ordernummer;
    /**
     * The relatieNummer
     * Meta informations extracted from the WSDL
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relatieNummer;
    /**
     * The artikel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \VoorraadApiV5\StructType\VoorraadArtikelRecV5
     */
    public $artikel;
    /**
     * Constructor method for RelatieArtikelRecV5
     * @uses RelatieArtikelRecV5::setOrdernummer()
     * @uses RelatieArtikelRecV5::setRelatieNummer()
     * @uses RelatieArtikelRecV5::setArtikel()
     * @param int $ordernummer
     * @param int $relatieNummer
     * @param \VoorraadApiV5\StructType\VoorraadArtikelRecV5 $artikel
     */
    public function __construct($ordernummer = null, $relatieNummer = null, \VoorraadApiV5\StructType\VoorraadArtikelRecV5 $artikel = null)
    {
        $this
            ->setOrdernummer($ordernummer)
            ->setRelatieNummer($relatieNummer)
            ->setArtikel($artikel);
    }
    /**
     * Get ordernummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrdernummer()
    {
        return isset($this->ordernummer) ? $this->ordernummer : null;
    }
    /**
     * Set ordernummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ordernummer
     * @return \VoorraadApiV5\StructType\RelatieArtikelRecV5
     */
    public function setOrdernummer($ordernummer = null)
    {
        // validation for constraint: int
        if (!is_null($ordernummer) && !(is_int($ordernummer) || ctype_digit($ordernummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordernummer, true), gettype($ordernummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($ordernummer) && mb_strlen(preg_replace('/(\D)/', '', $ordernummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($ordernummer, true), mb_strlen(preg_replace('/(\D)/', '', $ordernummer))), __LINE__);
        }
        if (is_null($ordernummer) || (is_array($ordernummer) && empty($ordernummer))) {
            unset($this->ordernummer);
        } else {
            $this->ordernummer = $ordernummer;
        }
        return $this;
    }
    /**
     * Get relatieNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelatieNummer()
    {
        return isset($this->relatieNummer) ? $this->relatieNummer : null;
    }
    /**
     * Set relatieNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relatieNummer
     * @return \VoorraadApiV5\StructType\RelatieArtikelRecV5
     */
    public function setRelatieNummer($relatieNummer = null)
    {
        // validation for constraint: int
        if (!is_null($relatieNummer) && !(is_int($relatieNummer) || ctype_digit($relatieNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatieNummer, true), gettype($relatieNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatieNummer) && mb_strlen(preg_replace('/(\D)/', '', $relatieNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatieNummer, true), mb_strlen(preg_replace('/(\D)/', '', $relatieNummer))), __LINE__);
        }
        if (is_null($relatieNummer) || (is_array($relatieNummer) && empty($relatieNummer))) {
            unset($this->relatieNummer);
        } else {
            $this->relatieNummer = $relatieNummer;
        }
        return $this;
    }
    /**
     * Get artikel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \VoorraadApiV5\StructType\VoorraadArtikelRecV5|null
     */
    public function getArtikel()
    {
        return isset($this->artikel) ? $this->artikel : null;
    }
    /**
     * Set artikel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \VoorraadApiV5\StructType\VoorraadArtikelRecV5 $artikel
     * @return \VoorraadApiV5\StructType\RelatieArtikelRecV5
     */
    public function setArtikel(\VoorraadApiV5\StructType\VoorraadArtikelRecV5 $artikel = null)
    {
        if (is_null($artikel) || (is_array($artikel) && empty($artikel))) {
            unset($this->artikel);
        } else {
            $this->artikel = $artikel;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\RelatieArtikelRecV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
