<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PublicatieCoderingenTableV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met coderingen van een publicatie
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class PublicatieCoderingenTableV5 extends AbstractStructBase
{
    /**
     * The publicatieCoderingen
     * Meta informations extracted from the WSDL
     * - documentation: Codering
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \VoorraadApiV5\StructType\PublicatieCoderingenRecV5[]
     */
    public $publicatieCoderingen;
    /**
     * Constructor method for PublicatieCoderingenTableV5
     * @uses PublicatieCoderingenTableV5::setPublicatieCoderingen()
     * @param \VoorraadApiV5\StructType\PublicatieCoderingenRecV5[] $publicatieCoderingen
     */
    public function __construct(array $publicatieCoderingen = array())
    {
        $this
            ->setPublicatieCoderingen($publicatieCoderingen);
    }
    /**
     * Get publicatieCoderingen value
     * @return \VoorraadApiV5\StructType\PublicatieCoderingenRecV5[]|null
     */
    public function getPublicatieCoderingen()
    {
        return $this->publicatieCoderingen;
    }
    /**
     * This method is responsible for validating the values passed to the setPublicatieCoderingen method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPublicatieCoderingen method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePublicatieCoderingenForArrayConstraintsFromSetPublicatieCoderingen(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $publicatieCoderingenTableV5PublicatieCoderingenItem) {
            // validation for constraint: itemType
            if (!$publicatieCoderingenTableV5PublicatieCoderingenItem instanceof \VoorraadApiV5\StructType\PublicatieCoderingenRecV5) {
                $invalidValues[] = is_object($publicatieCoderingenTableV5PublicatieCoderingenItem) ? get_class($publicatieCoderingenTableV5PublicatieCoderingenItem) : sprintf('%s(%s)', gettype($publicatieCoderingenTableV5PublicatieCoderingenItem), var_export($publicatieCoderingenTableV5PublicatieCoderingenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The publicatieCoderingen property can only contain items of type \VoorraadApiV5\StructType\PublicatieCoderingenRecV5, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set publicatieCoderingen value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\PublicatieCoderingenRecV5[] $publicatieCoderingen
     * @return \VoorraadApiV5\StructType\PublicatieCoderingenTableV5
     */
    public function setPublicatieCoderingen(array $publicatieCoderingen = array())
    {
        // validation for constraint: array
        if ('' !== ($publicatieCoderingenArrayErrorMessage = self::validatePublicatieCoderingenForArrayConstraintsFromSetPublicatieCoderingen($publicatieCoderingen))) {
            throw new \InvalidArgumentException($publicatieCoderingenArrayErrorMessage, __LINE__);
        }
        $this->publicatieCoderingen = $publicatieCoderingen;
        return $this;
    }
    /**
     * Add item to publicatieCoderingen value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\PublicatieCoderingenRecV5 $item
     * @return \VoorraadApiV5\StructType\PublicatieCoderingenTableV5
     */
    public function addToPublicatieCoderingen(\VoorraadApiV5\StructType\PublicatieCoderingenRecV5 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \VoorraadApiV5\StructType\PublicatieCoderingenRecV5) {
            throw new \InvalidArgumentException(sprintf('The publicatieCoderingen property can only contain items of type \VoorraadApiV5\StructType\PublicatieCoderingenRecV5, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->publicatieCoderingen[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\PublicatieCoderingenTableV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
