<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for orderEBooksRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Bestellen van eBooks bij CB (eboekhuis), voor een met incasso of iDeal betaalde verkoop order. Eerst dient de boekbestelling met de gebruikelijke operatie createVerkoopOrder met succes te worden aangemaakt in Zeno. Deze bestelling
 * dient daarna te worden aangeroepen met het ordernummer, zoals geretourneerd door createverkoopOrder. Mocht er een fout optreden bij het aanroepen van de eboekhuis webservice t.b.v. het plaatsen van de bestelling, dan wordt dat ook teruggegeven in de
 * lijst met download links per artikel nummer. In dat geval kan deze functie nogmaals worden aanroepen. Boeken die de eerste keer zijn besteld, waarvan de download link ook in Zeno is vastgelegd, wordt niet nogmaals besteld. Boeken die nog moeten
 * worden besteld, of waar dat eerder fout ging worden wel besteld. De lijst met download links is altijd de volledige lijst o.b.v. alle ebooks bij een order.
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class OrderEBooksRequest extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The orderNummer
     * Meta informations extracted from the WSDL
     * - documentation: Het nummer van de aangemaakte verkooporder.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $orderNummer;
    /**
     * Constructor method for orderEBooksRequest
     * @uses OrderEBooksRequest::setRequestTag()
     * @uses OrderEBooksRequest::setOrderNummer()
     * @param string $requestTag
     * @param int $orderNummer
     */
    public function __construct($requestTag = null, $orderNummer = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setOrderNummer($orderNummer);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \VoorraadApiV5\StructType\OrderEBooksRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get orderNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrderNummer()
    {
        return isset($this->orderNummer) ? $this->orderNummer : null;
    }
    /**
     * Set orderNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $orderNummer
     * @return \VoorraadApiV5\StructType\OrderEBooksRequest
     */
    public function setOrderNummer($orderNummer = null)
    {
        // validation for constraint: int
        if (!is_null($orderNummer) && !(is_int($orderNummer) || ctype_digit($orderNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderNummer, true), gettype($orderNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($orderNummer) && mb_strlen(preg_replace('/(\D)/', '', $orderNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($orderNummer, true), mb_strlen(preg_replace('/(\D)/', '', $orderNummer))), __LINE__);
        }
        if (is_null($orderNummer) || (is_array($orderNummer) && empty($orderNummer))) {
            unset($this->orderNummer);
        } else {
            $this->orderNummer = $orderNummer;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\OrderEBooksRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
