<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getVerkoopOrdersRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Geeft informatie terug van 1 of meer verkooporders.
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class GetVerkoopOrdersRequest extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The orderNummer
     * Meta informations extracted from the WSDL
     * - documentation: Ordernummer van de order die teruggegeven moet worden
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $orderNummer;
    /**
     * The relatieNummer
     * Meta informations extracted from the WSDL
     * - documentation: het relatienummer van de ontvanger. Alle orders van deze relatie worden teruggegeven
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relatieNummer;
    /**
     * Constructor method for getVerkoopOrdersRequest
     * @uses GetVerkoopOrdersRequest::setRequestTag()
     * @uses GetVerkoopOrdersRequest::setOrderNummer()
     * @uses GetVerkoopOrdersRequest::setRelatieNummer()
     * @param string $requestTag
     * @param int $orderNummer
     * @param int $relatieNummer
     */
    public function __construct($requestTag = null, $orderNummer = null, $relatieNummer = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setOrderNummer($orderNummer)
            ->setRelatieNummer($relatieNummer);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \VoorraadApiV5\StructType\GetVerkoopOrdersRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get orderNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrderNummer()
    {
        return isset($this->orderNummer) ? $this->orderNummer : null;
    }
    /**
     * Set orderNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $orderNummer
     * @return \VoorraadApiV5\StructType\GetVerkoopOrdersRequest
     */
    public function setOrderNummer($orderNummer = null)
    {
        // validation for constraint: int
        if (!is_null($orderNummer) && !(is_int($orderNummer) || ctype_digit($orderNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderNummer, true), gettype($orderNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($orderNummer) && mb_strlen(preg_replace('/(\D)/', '', $orderNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($orderNummer, true), mb_strlen(preg_replace('/(\D)/', '', $orderNummer))), __LINE__);
        }
        if (is_null($orderNummer) || (is_array($orderNummer) && empty($orderNummer))) {
            unset($this->orderNummer);
        } else {
            $this->orderNummer = $orderNummer;
        }
        return $this;
    }
    /**
     * Get relatieNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelatieNummer()
    {
        return isset($this->relatieNummer) ? $this->relatieNummer : null;
    }
    /**
     * Set relatieNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relatieNummer
     * @return \VoorraadApiV5\StructType\GetVerkoopOrdersRequest
     */
    public function setRelatieNummer($relatieNummer = null)
    {
        // validation for constraint: int
        if (!is_null($relatieNummer) && !(is_int($relatieNummer) || ctype_digit($relatieNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatieNummer, true), gettype($relatieNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatieNummer) && mb_strlen(preg_replace('/(\D)/', '', $relatieNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatieNummer, true), mb_strlen(preg_replace('/(\D)/', '', $relatieNummer))), __LINE__);
        }
        if (is_null($relatieNummer) || (is_array($relatieNummer) && empty($relatieNummer))) {
            unset($this->relatieNummer);
        } else {
            $this->relatieNummer = $relatieNummer;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\GetVerkoopOrdersRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
