<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DownloadLinkRecV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Download link gegevens van de bestelde ebooks bij een verkoop order regel.
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class DownloadLinkRecV5 extends AbstractStructBase
{
    /**
     * The artikelNummer
     * Meta informations extracted from the WSDL
     * - documentation: Artikelnummer van het eBook dat bij CB is besteld
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $artikelNummer;
    /**
     * The downloadUrl
     * Meta informations extracted from the WSDL
     * - documentation: Opgevraagde download url
     * - base: xsd:string
     * - maxLength: 200
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $downloadUrl;
    /**
     * The foutCode
     * Meta informations extracted from the WSDL
     * - documentation: Fout code CB n.a.v opvragen download url
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $foutCode;
    /**
     * The foutMelding
     * Meta informations extracted from the WSDL
     * - documentation: Fout melding CB n.a.v opvragen download url
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $foutMelding;
    /**
     * Constructor method for DownloadLinkRecV5
     * @uses DownloadLinkRecV5::setArtikelNummer()
     * @uses DownloadLinkRecV5::setDownloadUrl()
     * @uses DownloadLinkRecV5::setFoutCode()
     * @uses DownloadLinkRecV5::setFoutMelding()
     * @param int $artikelNummer
     * @param string $downloadUrl
     * @param string $foutCode
     * @param string $foutMelding
     */
    public function __construct($artikelNummer = null, $downloadUrl = null, $foutCode = null, $foutMelding = null)
    {
        $this
            ->setArtikelNummer($artikelNummer)
            ->setDownloadUrl($downloadUrl)
            ->setFoutCode($foutCode)
            ->setFoutMelding($foutMelding);
    }
    /**
     * Get artikelNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getArtikelNummer()
    {
        return isset($this->artikelNummer) ? $this->artikelNummer : null;
    }
    /**
     * Set artikelNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $artikelNummer
     * @return \VoorraadApiV5\StructType\DownloadLinkRecV5
     */
    public function setArtikelNummer($artikelNummer = null)
    {
        // validation for constraint: int
        if (!is_null($artikelNummer) && !(is_int($artikelNummer) || ctype_digit($artikelNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($artikelNummer, true), gettype($artikelNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($artikelNummer) && mb_strlen(preg_replace('/(\D)/', '', $artikelNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($artikelNummer, true), mb_strlen(preg_replace('/(\D)/', '', $artikelNummer))), __LINE__);
        }
        if (is_null($artikelNummer) || (is_array($artikelNummer) && empty($artikelNummer))) {
            unset($this->artikelNummer);
        } else {
            $this->artikelNummer = $artikelNummer;
        }
        return $this;
    }
    /**
     * Get downloadUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDownloadUrl()
    {
        return isset($this->downloadUrl) ? $this->downloadUrl : null;
    }
    /**
     * Set downloadUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $downloadUrl
     * @return \VoorraadApiV5\StructType\DownloadLinkRecV5
     */
    public function setDownloadUrl($downloadUrl = null)
    {
        // validation for constraint: string
        if (!is_null($downloadUrl) && !is_string($downloadUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($downloadUrl, true), gettype($downloadUrl)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($downloadUrl) && mb_strlen($downloadUrl) > 200) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen($downloadUrl)), __LINE__);
        }
        if (is_null($downloadUrl) || (is_array($downloadUrl) && empty($downloadUrl))) {
            unset($this->downloadUrl);
        } else {
            $this->downloadUrl = $downloadUrl;
        }
        return $this;
    }
    /**
     * Get foutCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFoutCode()
    {
        return isset($this->foutCode) ? $this->foutCode : null;
    }
    /**
     * Set foutCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $foutCode
     * @return \VoorraadApiV5\StructType\DownloadLinkRecV5
     */
    public function setFoutCode($foutCode = null)
    {
        // validation for constraint: string
        if (!is_null($foutCode) && !is_string($foutCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foutCode, true), gettype($foutCode)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($foutCode) && mb_strlen($foutCode) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($foutCode)), __LINE__);
        }
        if (is_null($foutCode) || (is_array($foutCode) && empty($foutCode))) {
            unset($this->foutCode);
        } else {
            $this->foutCode = $foutCode;
        }
        return $this;
    }
    /**
     * Get foutMelding value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFoutMelding()
    {
        return isset($this->foutMelding) ? $this->foutMelding : null;
    }
    /**
     * Set foutMelding value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $foutMelding
     * @return \VoorraadApiV5\StructType\DownloadLinkRecV5
     */
    public function setFoutMelding($foutMelding = null)
    {
        // validation for constraint: string
        if (!is_null($foutMelding) && !is_string($foutMelding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foutMelding, true), gettype($foutMelding)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($foutMelding) && mb_strlen($foutMelding) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($foutMelding)), __LINE__);
        }
        if (is_null($foutMelding) || (is_array($foutMelding) && empty($foutMelding))) {
            unset($this->foutMelding);
        } else {
            $this->foutMelding = $foutMelding;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\DownloadLinkRecV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
