<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createLeverantieResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: error544: De waarde van vrij code veld 4 kan niet worden gevonden in de database | error543: De waarde van vrij code veld 3 kan niet worden gevonden in de database | error542: De waarde van vrij code veld 2 kan niet worden gevonden
 * in de database | error541: De waarde van vrij code veld 1 kan niet worden gevonden in de database | error533: De valutacode is niet gevonden | error532: De betalingsconditie is niet gevonden | error527: Incasso leverantie dient een IBAN nummer te
 * hebben | error526: Er is een onverwachte fout opgetreden bij het factureren van de leverantie | error525: De leverantie kan niet aangemaakt worden. Voor de debiteur geldt een leververbod | error524: Incasso leverantie dient een bankrekening nummer te
 * hebben | error523: iDEAL leverantie dient een iDEAL kenmerk te hebben | error518: Kan geen factuuradres bepalen | error517: Kan geen afleveradres bepalen | error516: Een IBAN nummer dient altijd in combinatie met een BIC code opgegeven te worden |
 * error515: De opgegeven BIC code hoort niet bij het opgegeven IBAN nummer | error514: De opgegeven BIC code voldoet niet aan de eisen | error513: Het opgegeven IBAN nummer voldoet niet aan de eisen | error510: Afleveradres is niet compleet | error507:
 * Het artikel is niet gevonden | error506: Ongeldig bankrekening nummer | error503: De verzendwijze is niet gevonden | error502: De ordersoort is niet gevonden | error501: De debiteur is niet gevonden | error500: De relatie is niet gevonden
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class CreateLeverantieResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The leverantieNummer
     * Meta informations extracted from the WSDL
     * - documentation: Het nummer van de aangemaakte leverantie
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $leverantieNummer;
    /**
     * Constructor method for createLeverantieResponse
     * @uses CreateLeverantieResponse::setRequestTag()
     * @uses CreateLeverantieResponse::setLeverantieNummer()
     * @param string $requestTag
     * @param int $leverantieNummer
     */
    public function __construct($requestTag = null, $leverantieNummer = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setLeverantieNummer($leverantieNummer);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \VoorraadApiV5\StructType\CreateLeverantieResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get leverantieNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLeverantieNummer()
    {
        return isset($this->leverantieNummer) ? $this->leverantieNummer : null;
    }
    /**
     * Set leverantieNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $leverantieNummer
     * @return \VoorraadApiV5\StructType\CreateLeverantieResponse
     */
    public function setLeverantieNummer($leverantieNummer = null)
    {
        // validation for constraint: int
        if (!is_null($leverantieNummer) && !(is_int($leverantieNummer) || ctype_digit($leverantieNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($leverantieNummer, true), gettype($leverantieNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($leverantieNummer) && mb_strlen(preg_replace('/(\D)/', '', $leverantieNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($leverantieNummer, true), mb_strlen(preg_replace('/(\D)/', '', $leverantieNummer))), __LINE__);
        }
        if (is_null($leverantieNummer) || (is_array($leverantieNummer) && empty($leverantieNummer))) {
            unset($this->leverantieNummer);
        } else {
            $this->leverantieNummer = $leverantieNummer;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\CreateLeverantieResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
