<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArtikelgroepRecV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Artikelgroep
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class ArtikelgroepRecV5 extends AbstractStructBase
{
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - documentation: De code van de artikelgroep
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $code;
    /**
     * The naam
     * Meta informations extracted from the WSDL
     * - documentation: De omschrijving van de artikelgroep
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $naam;
    /**
     * The hoofdgroepCode
     * Meta informations extracted from the WSDL
     * - documentation: De code van de artikel-hoofdgroep
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $hoofdgroepCode;
    /**
     * The hoofdgroepNaam
     * Meta informations extracted from the WSDL
     * - documentation: De omschrijving van de artikel-hoofdgroep
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $hoofdgroepNaam;
    /**
     * Constructor method for ArtikelgroepRecV5
     * @uses ArtikelgroepRecV5::setCode()
     * @uses ArtikelgroepRecV5::setNaam()
     * @uses ArtikelgroepRecV5::setHoofdgroepCode()
     * @uses ArtikelgroepRecV5::setHoofdgroepNaam()
     * @param string $code
     * @param string $naam
     * @param string $hoofdgroepCode
     * @param string $hoofdgroepNaam
     */
    public function __construct($code = null, $naam = null, $hoofdgroepCode = null, $hoofdgroepNaam = null)
    {
        $this
            ->setCode($code)
            ->setNaam($naam)
            ->setHoofdgroepCode($hoofdgroepCode)
            ->setHoofdgroepNaam($hoofdgroepNaam);
    }
    /**
     * Get code value
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \VoorraadApiV5\StructType\ArtikelgroepRecV5
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($code) && mb_strlen($code) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($code)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($code) && mb_strlen($code) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get naam value
     * @return string
     */
    public function getNaam()
    {
        return $this->naam;
    }
    /**
     * Set naam value
     * @param string $naam
     * @return \VoorraadApiV5\StructType\ArtikelgroepRecV5
     */
    public function setNaam($naam = null)
    {
        // validation for constraint: string
        if (!is_null($naam) && !is_string($naam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naam, true), gettype($naam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($naam) && mb_strlen($naam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($naam)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($naam) && mb_strlen($naam) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($naam)), __LINE__);
        }
        $this->naam = $naam;
        return $this;
    }
    /**
     * Get hoofdgroepCode value
     * @return string
     */
    public function getHoofdgroepCode()
    {
        return $this->hoofdgroepCode;
    }
    /**
     * Set hoofdgroepCode value
     * @param string $hoofdgroepCode
     * @return \VoorraadApiV5\StructType\ArtikelgroepRecV5
     */
    public function setHoofdgroepCode($hoofdgroepCode = null)
    {
        // validation for constraint: string
        if (!is_null($hoofdgroepCode) && !is_string($hoofdgroepCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hoofdgroepCode, true), gettype($hoofdgroepCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($hoofdgroepCode) && mb_strlen($hoofdgroepCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($hoofdgroepCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($hoofdgroepCode) && mb_strlen($hoofdgroepCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($hoofdgroepCode)), __LINE__);
        }
        $this->hoofdgroepCode = $hoofdgroepCode;
        return $this;
    }
    /**
     * Get hoofdgroepNaam value
     * @return string
     */
    public function getHoofdgroepNaam()
    {
        return $this->hoofdgroepNaam;
    }
    /**
     * Set hoofdgroepNaam value
     * @param string $hoofdgroepNaam
     * @return \VoorraadApiV5\StructType\ArtikelgroepRecV5
     */
    public function setHoofdgroepNaam($hoofdgroepNaam = null)
    {
        // validation for constraint: string
        if (!is_null($hoofdgroepNaam) && !is_string($hoofdgroepNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hoofdgroepNaam, true), gettype($hoofdgroepNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($hoofdgroepNaam) && mb_strlen($hoofdgroepNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($hoofdgroepNaam)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($hoofdgroepNaam) && mb_strlen($hoofdgroepNaam) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($hoofdgroepNaam)), __LINE__);
        }
        $this->hoofdgroepNaam = $hoofdgroepNaam;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\ArtikelgroepRecV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
