<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArtikelStaffelRecV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Staffelprijzen van een artikel
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class ArtikelStaffelRecV5 extends AbstractStructBase
{
    /**
     * The aantalVanaf
     * Meta informations extracted from the WSDL
     * - documentation: Vanaf aantal waarvoor de staffelprijs geldt
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $aantalVanaf;
    /**
     * The aantalTm
     * Meta informations extracted from the WSDL
     * - documentation: Eindaantal waarvoor de staffelprijs geldt
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $aantalTm;
    /**
     * The prijsExclBtw
     * Meta informations extracted from the WSDL
     * - documentation: Prijs exclusief BTW
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $prijsExclBtw;
    /**
     * The prijsInclBtw
     * Meta informations extracted from the WSDL
     * - documentation: Prijs inclusief BTW (standaard percentage)
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $prijsInclBtw;
    /**
     * Constructor method for ArtikelStaffelRecV5
     * @uses ArtikelStaffelRecV5::setAantalVanaf()
     * @uses ArtikelStaffelRecV5::setAantalTm()
     * @uses ArtikelStaffelRecV5::setPrijsExclBtw()
     * @uses ArtikelStaffelRecV5::setPrijsInclBtw()
     * @param float $aantalVanaf
     * @param float $aantalTm
     * @param float $prijsExclBtw
     * @param float $prijsInclBtw
     */
    public function __construct($aantalVanaf = null, $aantalTm = null, $prijsExclBtw = null, $prijsInclBtw = null)
    {
        $this
            ->setAantalVanaf($aantalVanaf)
            ->setAantalTm($aantalTm)
            ->setPrijsExclBtw($prijsExclBtw)
            ->setPrijsInclBtw($prijsInclBtw);
    }
    /**
     * Get aantalVanaf value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAantalVanaf()
    {
        return isset($this->aantalVanaf) ? $this->aantalVanaf : null;
    }
    /**
     * Set aantalVanaf value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aantalVanaf
     * @return \VoorraadApiV5\StructType\ArtikelStaffelRecV5
     */
    public function setAantalVanaf($aantalVanaf = null)
    {
        // validation for constraint: float
        if (!is_null($aantalVanaf) && !(is_float($aantalVanaf) || is_numeric($aantalVanaf))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aantalVanaf, true), gettype($aantalVanaf)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($aantalVanaf) && mb_strlen(preg_replace('/(\D)/', '', $aantalVanaf)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($aantalVanaf, true), mb_strlen(preg_replace('/(\D)/', '', $aantalVanaf))), __LINE__);
        }
        if (is_null($aantalVanaf) || (is_array($aantalVanaf) && empty($aantalVanaf))) {
            unset($this->aantalVanaf);
        } else {
            $this->aantalVanaf = $aantalVanaf;
        }
        return $this;
    }
    /**
     * Get aantalTm value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAantalTm()
    {
        return isset($this->aantalTm) ? $this->aantalTm : null;
    }
    /**
     * Set aantalTm value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $aantalTm
     * @return \VoorraadApiV5\StructType\ArtikelStaffelRecV5
     */
    public function setAantalTm($aantalTm = null)
    {
        // validation for constraint: float
        if (!is_null($aantalTm) && !(is_float($aantalTm) || is_numeric($aantalTm))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aantalTm, true), gettype($aantalTm)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($aantalTm) && mb_strlen(preg_replace('/(\D)/', '', $aantalTm)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($aantalTm, true), mb_strlen(preg_replace('/(\D)/', '', $aantalTm))), __LINE__);
        }
        if (is_null($aantalTm) || (is_array($aantalTm) && empty($aantalTm))) {
            unset($this->aantalTm);
        } else {
            $this->aantalTm = $aantalTm;
        }
        return $this;
    }
    /**
     * Get prijsExclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrijsExclBtw()
    {
        return isset($this->prijsExclBtw) ? $this->prijsExclBtw : null;
    }
    /**
     * Set prijsExclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prijsExclBtw
     * @return \VoorraadApiV5\StructType\ArtikelStaffelRecV5
     */
    public function setPrijsExclBtw($prijsExclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($prijsExclBtw) && !(is_float($prijsExclBtw) || is_numeric($prijsExclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prijsExclBtw, true), gettype($prijsExclBtw)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($prijsExclBtw) && mb_strlen(preg_replace('/(\D)/', '', $prijsExclBtw)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($prijsExclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $prijsExclBtw))), __LINE__);
        }
        if (is_null($prijsExclBtw) || (is_array($prijsExclBtw) && empty($prijsExclBtw))) {
            unset($this->prijsExclBtw);
        } else {
            $this->prijsExclBtw = $prijsExclBtw;
        }
        return $this;
    }
    /**
     * Get prijsInclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrijsInclBtw()
    {
        return isset($this->prijsInclBtw) ? $this->prijsInclBtw : null;
    }
    /**
     * Set prijsInclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prijsInclBtw
     * @return \VoorraadApiV5\StructType\ArtikelStaffelRecV5
     */
    public function setPrijsInclBtw($prijsInclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($prijsInclBtw) && !(is_float($prijsInclBtw) || is_numeric($prijsInclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prijsInclBtw, true), gettype($prijsInclBtw)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($prijsInclBtw) && mb_strlen(mb_substr($prijsInclBtw, mb_strpos($prijsInclBtw, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($prijsInclBtw, true), mb_strlen(mb_substr($prijsInclBtw, mb_strpos($prijsInclBtw, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($prijsInclBtw) && mb_strlen(preg_replace('/(\D)/', '', $prijsInclBtw)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($prijsInclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $prijsInclBtw))), __LINE__);
        }
        if (is_null($prijsInclBtw) || (is_array($prijsInclBtw) && empty($prijsInclBtw))) {
            unset($this->prijsInclBtw);
        } else {
            $this->prijsInclBtw = $prijsInclBtw;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\ArtikelStaffelRecV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
