<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArtikelSamenstellingRecV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Gegevens van artikelen waar het artikel uit is samengesteld
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class ArtikelSamenstellingRecV5 extends AbstractStructBase
{
    /**
     * The artikelNummer
     * Meta informations extracted from the WSDL
     * - documentation: Het unieke nummer van het artikel
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $artikelNummer;
    /**
     * The btwCode
     * Meta informations extracted from the WSDL
     * - documentation: De BTW-code die op het artikel van toepassing is
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $btwCode;
    /**
     * The btwPercentage
     * Meta informations extracted from the WSDL
     * - documentation: Het BTW-percentage dat op het artikel van toepassing is
     * - base: xsd:decimal
     * - fractionDigits: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 16
     * @var float
     */
    public $btwPercentage;
    /**
     * The prijsExclBtw
     * Meta informations extracted from the WSDL
     * - documentation: Prijs exclusief BTW. Deze prijs kan binnen deze samenstelling afwijken van de standaardprijs van een artikel
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $prijsExclBtw;
    /**
     * The prijsInclBtw
     * Meta informations extracted from the WSDL
     * - documentation: Prijs inclusief BTW
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var float
     */
    public $prijsInclBtw;
    /**
     * Constructor method for ArtikelSamenstellingRecV5
     * @uses ArtikelSamenstellingRecV5::setArtikelNummer()
     * @uses ArtikelSamenstellingRecV5::setBtwCode()
     * @uses ArtikelSamenstellingRecV5::setBtwPercentage()
     * @uses ArtikelSamenstellingRecV5::setPrijsExclBtw()
     * @uses ArtikelSamenstellingRecV5::setPrijsInclBtw()
     * @param float $artikelNummer
     * @param string $btwCode
     * @param float $btwPercentage
     * @param float $prijsExclBtw
     * @param float $prijsInclBtw
     */
    public function __construct($artikelNummer = null, $btwCode = null, $btwPercentage = null, $prijsExclBtw = null, $prijsInclBtw = null)
    {
        $this
            ->setArtikelNummer($artikelNummer)
            ->setBtwCode($btwCode)
            ->setBtwPercentage($btwPercentage)
            ->setPrijsExclBtw($prijsExclBtw)
            ->setPrijsInclBtw($prijsInclBtw);
    }
    /**
     * Get artikelNummer value
     * @return float
     */
    public function getArtikelNummer()
    {
        return $this->artikelNummer;
    }
    /**
     * Set artikelNummer value
     * @param float $artikelNummer
     * @return \VoorraadApiV5\StructType\ArtikelSamenstellingRecV5
     */
    public function setArtikelNummer($artikelNummer = null)
    {
        // validation for constraint: float
        if (!is_null($artikelNummer) && !(is_float($artikelNummer) || is_numeric($artikelNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($artikelNummer, true), gettype($artikelNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($artikelNummer) && mb_strlen(preg_replace('/(\D)/', '', $artikelNummer)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($artikelNummer, true), mb_strlen(preg_replace('/(\D)/', '', $artikelNummer))), __LINE__);
        }
        $this->artikelNummer = $artikelNummer;
        return $this;
    }
    /**
     * Get btwCode value
     * @return string
     */
    public function getBtwCode()
    {
        return $this->btwCode;
    }
    /**
     * Set btwCode value
     * @param string $btwCode
     * @return \VoorraadApiV5\StructType\ArtikelSamenstellingRecV5
     */
    public function setBtwCode($btwCode = null)
    {
        // validation for constraint: string
        if (!is_null($btwCode) && !is_string($btwCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($btwCode, true), gettype($btwCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($btwCode) && mb_strlen($btwCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($btwCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($btwCode) && mb_strlen($btwCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($btwCode)), __LINE__);
        }
        $this->btwCode = $btwCode;
        return $this;
    }
    /**
     * Get btwPercentage value
     * @return float
     */
    public function getBtwPercentage()
    {
        return $this->btwPercentage;
    }
    /**
     * Set btwPercentage value
     * @param float $btwPercentage
     * @return \VoorraadApiV5\StructType\ArtikelSamenstellingRecV5
     */
    public function setBtwPercentage($btwPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($btwPercentage) && !(is_float($btwPercentage) || is_numeric($btwPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($btwPercentage, true), gettype($btwPercentage)), __LINE__);
        }
        // validation for constraint: fractionDigits(1)
        if (!is_null($btwPercentage) && mb_strlen(mb_substr($btwPercentage, mb_strpos($btwPercentage, '.') + 1)) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 1 fraction digits, %d given', var_export($btwPercentage, true), mb_strlen(mb_substr($btwPercentage, mb_strpos($btwPercentage, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(16)
        if (!is_null($btwPercentage) && mb_strlen(preg_replace('/(\D)/', '', $btwPercentage)) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 16 digits, "%d" given', var_export($btwPercentage, true), mb_strlen(preg_replace('/(\D)/', '', $btwPercentage))), __LINE__);
        }
        $this->btwPercentage = $btwPercentage;
        return $this;
    }
    /**
     * Get prijsExclBtw value
     * @return float
     */
    public function getPrijsExclBtw()
    {
        return $this->prijsExclBtw;
    }
    /**
     * Set prijsExclBtw value
     * @param float $prijsExclBtw
     * @return \VoorraadApiV5\StructType\ArtikelSamenstellingRecV5
     */
    public function setPrijsExclBtw($prijsExclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($prijsExclBtw) && !(is_float($prijsExclBtw) || is_numeric($prijsExclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prijsExclBtw, true), gettype($prijsExclBtw)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($prijsExclBtw) && mb_strlen(preg_replace('/(\D)/', '', $prijsExclBtw)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($prijsExclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $prijsExclBtw))), __LINE__);
        }
        $this->prijsExclBtw = $prijsExclBtw;
        return $this;
    }
    /**
     * Get prijsInclBtw value
     * @return float
     */
    public function getPrijsInclBtw()
    {
        return $this->prijsInclBtw;
    }
    /**
     * Set prijsInclBtw value
     * @param float $prijsInclBtw
     * @return \VoorraadApiV5\StructType\ArtikelSamenstellingRecV5
     */
    public function setPrijsInclBtw($prijsInclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($prijsInclBtw) && !(is_float($prijsInclBtw) || is_numeric($prijsInclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prijsInclBtw, true), gettype($prijsInclBtw)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($prijsInclBtw) && mb_strlen(mb_substr($prijsInclBtw, mb_strpos($prijsInclBtw, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($prijsInclBtw, true), mb_strlen(mb_substr($prijsInclBtw, mb_strpos($prijsInclBtw, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($prijsInclBtw) && mb_strlen(preg_replace('/(\D)/', '', $prijsInclBtw)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($prijsInclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $prijsInclBtw))), __LINE__);
        }
        $this->prijsInclBtw = $prijsInclBtw;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\ArtikelSamenstellingRecV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
