<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VoorraadInfoTableV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met artikel voorraad informatie
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class VoorraadInfoTableV5 extends AbstractStructBase
{
    /**
     * The voorraadInfo
     * Meta informations extracted from the WSDL
     * - documentation: VoorraadInfoRec
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - nillable: false
     * @var \VoorraadApiV5\StructType\VoorraadInfoRecV5[]
     */
    public $voorraadInfo;
    /**
     * Constructor method for VoorraadInfoTableV5
     * @uses VoorraadInfoTableV5::setVoorraadInfo()
     * @param \VoorraadApiV5\StructType\VoorraadInfoRecV5[] $voorraadInfo
     */
    public function __construct(array $voorraadInfo = array())
    {
        $this
            ->setVoorraadInfo($voorraadInfo);
    }
    /**
     * Get voorraadInfo value
     * @return \VoorraadApiV5\StructType\VoorraadInfoRecV5[]
     */
    public function getVoorraadInfo()
    {
        return $this->voorraadInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setVoorraadInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVoorraadInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVoorraadInfoForArrayConstraintsFromSetVoorraadInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $voorraadInfoTableV5VoorraadInfoItem) {
            // validation for constraint: itemType
            if (!$voorraadInfoTableV5VoorraadInfoItem instanceof \VoorraadApiV5\StructType\VoorraadInfoRecV5) {
                $invalidValues[] = is_object($voorraadInfoTableV5VoorraadInfoItem) ? get_class($voorraadInfoTableV5VoorraadInfoItem) : sprintf('%s(%s)', gettype($voorraadInfoTableV5VoorraadInfoItem), var_export($voorraadInfoTableV5VoorraadInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The voorraadInfo property can only contain items of type \VoorraadApiV5\StructType\VoorraadInfoRecV5, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set voorraadInfo value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\VoorraadInfoRecV5[] $voorraadInfo
     * @return \VoorraadApiV5\StructType\VoorraadInfoTableV5
     */
    public function setVoorraadInfo(array $voorraadInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($voorraadInfoArrayErrorMessage = self::validateVoorraadInfoForArrayConstraintsFromSetVoorraadInfo($voorraadInfo))) {
            throw new \InvalidArgumentException($voorraadInfoArrayErrorMessage, __LINE__);
        }
        $this->voorraadInfo = $voorraadInfo;
        return $this;
    }
    /**
     * Add item to voorraadInfo value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\VoorraadInfoRecV5 $item
     * @return \VoorraadApiV5\StructType\VoorraadInfoTableV5
     */
    public function addToVoorraadInfo(\VoorraadApiV5\StructType\VoorraadInfoRecV5 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \VoorraadApiV5\StructType\VoorraadInfoRecV5) {
            throw new \InvalidArgumentException(sprintf('The voorraadInfo property can only contain items of type \VoorraadApiV5\StructType\VoorraadInfoRecV5, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->voorraadInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\VoorraadInfoTableV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
