<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerkooporderregelLevTabV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met leveringen van een orderregel
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class VerkooporderregelLevTabV5 extends AbstractStructBase
{
    /**
     * The levering
     * Meta informations extracted from the WSDL
     * - documentation: verkooporderregelLevRec
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - nillable: false
     * @var \VoorraadApiV5\StructType\VerkooporderregelLevRecV5[]
     */
    public $levering;
    /**
     * Constructor method for VerkooporderregelLevTabV5
     * @uses VerkooporderregelLevTabV5::setLevering()
     * @param \VoorraadApiV5\StructType\VerkooporderregelLevRecV5[] $levering
     */
    public function __construct(array $levering = array())
    {
        $this
            ->setLevering($levering);
    }
    /**
     * Get levering value
     * @return \VoorraadApiV5\StructType\VerkooporderregelLevRecV5[]
     */
    public function getLevering()
    {
        return $this->levering;
    }
    /**
     * This method is responsible for validating the values passed to the setLevering method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLevering method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLeveringForArrayConstraintsFromSetLevering(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $verkooporderregelLevTabV5LeveringItem) {
            // validation for constraint: itemType
            if (!$verkooporderregelLevTabV5LeveringItem instanceof \VoorraadApiV5\StructType\VerkooporderregelLevRecV5) {
                $invalidValues[] = is_object($verkooporderregelLevTabV5LeveringItem) ? get_class($verkooporderregelLevTabV5LeveringItem) : sprintf('%s(%s)', gettype($verkooporderregelLevTabV5LeveringItem), var_export($verkooporderregelLevTabV5LeveringItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The levering property can only contain items of type \VoorraadApiV5\StructType\VerkooporderregelLevRecV5, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set levering value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\VerkooporderregelLevRecV5[] $levering
     * @return \VoorraadApiV5\StructType\VerkooporderregelLevTabV5
     */
    public function setLevering(array $levering = array())
    {
        // validation for constraint: array
        if ('' !== ($leveringArrayErrorMessage = self::validateLeveringForArrayConstraintsFromSetLevering($levering))) {
            throw new \InvalidArgumentException($leveringArrayErrorMessage, __LINE__);
        }
        $this->levering = $levering;
        return $this;
    }
    /**
     * Add item to levering value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\VerkooporderregelLevRecV5 $item
     * @return \VoorraadApiV5\StructType\VerkooporderregelLevTabV5
     */
    public function addToLevering(\VoorraadApiV5\StructType\VerkooporderregelLevRecV5 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \VoorraadApiV5\StructType\VerkooporderregelLevRecV5) {
            throw new \InvalidArgumentException(sprintf('The levering property can only contain items of type \VoorraadApiV5\StructType\VerkooporderregelLevRecV5, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->levering[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\VerkooporderregelLevTabV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
