<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrdersoortRecV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ordersoort informatie
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class OrdersoortRecV5 extends AbstractStructBase
{
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - documentation: Code van de ordersoort
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $code;
    /**
     * The naam
     * Meta informations extracted from the WSDL
     * - documentation: Naam/omschrijving van de ordersoort
     * - base: xsd:string
     * - maxLength: 50
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $naam;
    /**
     * The indicatieStandaard
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie dat dit de standaard (default) ordersoort is
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $indicatieStandaard;
    /**
     * The indicatieInternet
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie dat dit de standaard (default) ordersoort is
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $indicatieInternet;
    /**
     * The kortingPercentage
     * Meta informations extracted from the WSDL
     * - documentation: Kortings percentage dat bij de ordersoort van toepassing is
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $kortingPercentage;
    /**
     * Constructor method for OrdersoortRecV5
     * @uses OrdersoortRecV5::setCode()
     * @uses OrdersoortRecV5::setNaam()
     * @uses OrdersoortRecV5::setIndicatieStandaard()
     * @uses OrdersoortRecV5::setIndicatieInternet()
     * @uses OrdersoortRecV5::setKortingPercentage()
     * @param string $code
     * @param string $naam
     * @param bool $indicatieStandaard
     * @param bool $indicatieInternet
     * @param int $kortingPercentage
     */
    public function __construct($code = null, $naam = null, $indicatieStandaard = null, $indicatieInternet = null, $kortingPercentage = null)
    {
        $this
            ->setCode($code)
            ->setNaam($naam)
            ->setIndicatieStandaard($indicatieStandaard)
            ->setIndicatieInternet($indicatieInternet)
            ->setKortingPercentage($kortingPercentage);
    }
    /**
     * Get code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->code) ? $this->code : null;
    }
    /**
     * Set code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \VoorraadApiV5\StructType\OrdersoortRecV5
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($code) && mb_strlen($code) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->code);
        } else {
            $this->code = $code;
        }
        return $this;
    }
    /**
     * Get naam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNaam()
    {
        return isset($this->naam) ? $this->naam : null;
    }
    /**
     * Set naam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $naam
     * @return \VoorraadApiV5\StructType\OrdersoortRecV5
     */
    public function setNaam($naam = null)
    {
        // validation for constraint: string
        if (!is_null($naam) && !is_string($naam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naam, true), gettype($naam)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($naam) && mb_strlen($naam) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($naam)), __LINE__);
        }
        if (is_null($naam) || (is_array($naam) && empty($naam))) {
            unset($this->naam);
        } else {
            $this->naam = $naam;
        }
        return $this;
    }
    /**
     * Get indicatieStandaard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIndicatieStandaard()
    {
        return isset($this->indicatieStandaard) ? $this->indicatieStandaard : null;
    }
    /**
     * Set indicatieStandaard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $indicatieStandaard
     * @return \VoorraadApiV5\StructType\OrdersoortRecV5
     */
    public function setIndicatieStandaard($indicatieStandaard = null)
    {
        // validation for constraint: boolean
        if (!is_null($indicatieStandaard) && !is_bool($indicatieStandaard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($indicatieStandaard, true), gettype($indicatieStandaard)), __LINE__);
        }
        if (is_null($indicatieStandaard) || (is_array($indicatieStandaard) && empty($indicatieStandaard))) {
            unset($this->indicatieStandaard);
        } else {
            $this->indicatieStandaard = $indicatieStandaard;
        }
        return $this;
    }
    /**
     * Get indicatieInternet value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIndicatieInternet()
    {
        return isset($this->indicatieInternet) ? $this->indicatieInternet : null;
    }
    /**
     * Set indicatieInternet value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $indicatieInternet
     * @return \VoorraadApiV5\StructType\OrdersoortRecV5
     */
    public function setIndicatieInternet($indicatieInternet = null)
    {
        // validation for constraint: boolean
        if (!is_null($indicatieInternet) && !is_bool($indicatieInternet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($indicatieInternet, true), gettype($indicatieInternet)), __LINE__);
        }
        if (is_null($indicatieInternet) || (is_array($indicatieInternet) && empty($indicatieInternet))) {
            unset($this->indicatieInternet);
        } else {
            $this->indicatieInternet = $indicatieInternet;
        }
        return $this;
    }
    /**
     * Get kortingPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getKortingPercentage()
    {
        return isset($this->kortingPercentage) ? $this->kortingPercentage : null;
    }
    /**
     * Set kortingPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $kortingPercentage
     * @return \VoorraadApiV5\StructType\OrdersoortRecV5
     */
    public function setKortingPercentage($kortingPercentage = null)
    {
        // validation for constraint: int
        if (!is_null($kortingPercentage) && !(is_int($kortingPercentage) || ctype_digit($kortingPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kortingPercentage, true), gettype($kortingPercentage)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($kortingPercentage) && mb_strlen(preg_replace('/(\D)/', '', $kortingPercentage)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($kortingPercentage, true), mb_strlen(preg_replace('/(\D)/', '', $kortingPercentage))), __LINE__);
        }
        if (is_null($kortingPercentage) || (is_array($kortingPercentage) && empty($kortingPercentage))) {
            unset($this->kortingPercentage);
        } else {
            $this->kortingPercentage = $kortingPercentage;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\OrdersoortRecV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
