<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderAfleverRecV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Afwijkende aflevergegevens voor de order. Indien 1 van de velden gevuld is wordt dit hele Type OrderAflever gebruikt als afleveradres en moet je alle van toepassing zijnde velden vullen.
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class OrderAfleverRecV5 extends AbstractStructBase
{
    /**
     * The bedrijfsnaam
     * Meta informations extracted from the WSDL
     * - documentation: Bedrijfsnaam van het afleveradres
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $bedrijfsnaam;
    /**
     * The achternaam
     * Meta informations extracted from the WSDL
     * - documentation: Achternaam van het afleveradres
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $achternaam;
    /**
     * The afdeling
     * Meta informations extracted from the WSDL
     * - documentation: Afdeling van het afleveradres
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $afdeling;
    /**
     * The voorletters
     * Meta informations extracted from the WSDL
     * - documentation: Voorletters van het afleveradres
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $voorletters;
    /**
     * The tussenvoegsels
     * Meta informations extracted from the WSDL
     * - documentation: Tussenvoegsels van het afleveradres
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $tussenvoegsels;
    /**
     * The adres
     * Meta informations extracted from the WSDL
     * - documentation: Afleveradres adresgegevens
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \VoorraadApiV5\StructType\AdresRecV5
     */
    public $adres;
    /**
     * The land
     * Meta informations extracted from the WSDL
     * - documentation: Land van het afleveradres
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $land;
    /**
     * Constructor method for OrderAfleverRecV5
     * @uses OrderAfleverRecV5::setBedrijfsnaam()
     * @uses OrderAfleverRecV5::setAchternaam()
     * @uses OrderAfleverRecV5::setAfdeling()
     * @uses OrderAfleverRecV5::setVoorletters()
     * @uses OrderAfleverRecV5::setTussenvoegsels()
     * @uses OrderAfleverRecV5::setAdres()
     * @uses OrderAfleverRecV5::setLand()
     * @param string $bedrijfsnaam
     * @param string $achternaam
     * @param string $afdeling
     * @param string $voorletters
     * @param string $tussenvoegsels
     * @param \VoorraadApiV5\StructType\AdresRecV5 $adres
     * @param string $land
     */
    public function __construct($bedrijfsnaam = null, $achternaam = null, $afdeling = null, $voorletters = null, $tussenvoegsels = null, \VoorraadApiV5\StructType\AdresRecV5 $adres = null, $land = null)
    {
        $this
            ->setBedrijfsnaam($bedrijfsnaam)
            ->setAchternaam($achternaam)
            ->setAfdeling($afdeling)
            ->setVoorletters($voorletters)
            ->setTussenvoegsels($tussenvoegsels)
            ->setAdres($adres)
            ->setLand($land);
    }
    /**
     * Get bedrijfsnaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBedrijfsnaam()
    {
        return isset($this->bedrijfsnaam) ? $this->bedrijfsnaam : null;
    }
    /**
     * Set bedrijfsnaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bedrijfsnaam
     * @return \VoorraadApiV5\StructType\OrderAfleverRecV5
     */
    public function setBedrijfsnaam($bedrijfsnaam = null)
    {
        // validation for constraint: string
        if (!is_null($bedrijfsnaam) && !is_string($bedrijfsnaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bedrijfsnaam, true), gettype($bedrijfsnaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($bedrijfsnaam) && mb_strlen($bedrijfsnaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($bedrijfsnaam)), __LINE__);
        }
        if (is_null($bedrijfsnaam) || (is_array($bedrijfsnaam) && empty($bedrijfsnaam))) {
            unset($this->bedrijfsnaam);
        } else {
            $this->bedrijfsnaam = $bedrijfsnaam;
        }
        return $this;
    }
    /**
     * Get achternaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAchternaam()
    {
        return isset($this->achternaam) ? $this->achternaam : null;
    }
    /**
     * Set achternaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $achternaam
     * @return \VoorraadApiV5\StructType\OrderAfleverRecV5
     */
    public function setAchternaam($achternaam = null)
    {
        // validation for constraint: string
        if (!is_null($achternaam) && !is_string($achternaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($achternaam, true), gettype($achternaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($achternaam) && mb_strlen($achternaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($achternaam)), __LINE__);
        }
        if (is_null($achternaam) || (is_array($achternaam) && empty($achternaam))) {
            unset($this->achternaam);
        } else {
            $this->achternaam = $achternaam;
        }
        return $this;
    }
    /**
     * Get afdeling value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAfdeling()
    {
        return isset($this->afdeling) ? $this->afdeling : null;
    }
    /**
     * Set afdeling value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $afdeling
     * @return \VoorraadApiV5\StructType\OrderAfleverRecV5
     */
    public function setAfdeling($afdeling = null)
    {
        // validation for constraint: string
        if (!is_null($afdeling) && !is_string($afdeling)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($afdeling, true), gettype($afdeling)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($afdeling) && mb_strlen($afdeling) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($afdeling)), __LINE__);
        }
        if (is_null($afdeling) || (is_array($afdeling) && empty($afdeling))) {
            unset($this->afdeling);
        } else {
            $this->afdeling = $afdeling;
        }
        return $this;
    }
    /**
     * Get voorletters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVoorletters()
    {
        return isset($this->voorletters) ? $this->voorletters : null;
    }
    /**
     * Set voorletters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $voorletters
     * @return \VoorraadApiV5\StructType\OrderAfleverRecV5
     */
    public function setVoorletters($voorletters = null)
    {
        // validation for constraint: string
        if (!is_null($voorletters) && !is_string($voorletters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voorletters, true), gettype($voorletters)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($voorletters) && mb_strlen($voorletters) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($voorletters)), __LINE__);
        }
        if (is_null($voorletters) || (is_array($voorletters) && empty($voorletters))) {
            unset($this->voorletters);
        } else {
            $this->voorletters = $voorletters;
        }
        return $this;
    }
    /**
     * Get tussenvoegsels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTussenvoegsels()
    {
        return isset($this->tussenvoegsels) ? $this->tussenvoegsels : null;
    }
    /**
     * Set tussenvoegsels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tussenvoegsels
     * @return \VoorraadApiV5\StructType\OrderAfleverRecV5
     */
    public function setTussenvoegsels($tussenvoegsels = null)
    {
        // validation for constraint: string
        if (!is_null($tussenvoegsels) && !is_string($tussenvoegsels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tussenvoegsels, true), gettype($tussenvoegsels)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($tussenvoegsels) && mb_strlen($tussenvoegsels) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($tussenvoegsels)), __LINE__);
        }
        if (is_null($tussenvoegsels) || (is_array($tussenvoegsels) && empty($tussenvoegsels))) {
            unset($this->tussenvoegsels);
        } else {
            $this->tussenvoegsels = $tussenvoegsels;
        }
        return $this;
    }
    /**
     * Get adres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \VoorraadApiV5\StructType\AdresRecV5|null
     */
    public function getAdres()
    {
        return isset($this->adres) ? $this->adres : null;
    }
    /**
     * Set adres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \VoorraadApiV5\StructType\AdresRecV5 $adres
     * @return \VoorraadApiV5\StructType\OrderAfleverRecV5
     */
    public function setAdres(\VoorraadApiV5\StructType\AdresRecV5 $adres = null)
    {
        if (is_null($adres) || (is_array($adres) && empty($adres))) {
            unset($this->adres);
        } else {
            $this->adres = $adres;
        }
        return $this;
    }
    /**
     * Get land value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLand()
    {
        return isset($this->land) ? $this->land : null;
    }
    /**
     * Set land value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $land
     * @return \VoorraadApiV5\StructType\OrderAfleverRecV5
     */
    public function setLand($land = null)
    {
        // validation for constraint: string
        if (!is_null($land) && !is_string($land)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($land, true), gettype($land)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($land) && mb_strlen($land) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($land)), __LINE__);
        }
        if (is_null($land) || (is_array($land) && empty($land))) {
            unset($this->land);
        } else {
            $this->land = $land;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\OrderAfleverRecV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
