<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getRelatieArtikelPrijsRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ophalen van een prijs van een artikel zoals die geldt voor een specifieke relatie, aantal, ordersoort en datum.<BR><BR> Hierbij wordt rekening gehouden met de prijsmatrix binnen Zeno. Afhankelijk van een globale instelling worden de
 * kortingen samengevoegd in het veld kortingBedrag of worden de kortingen gesplitst per categorie (staffelkorting, ordersoortkorting en prijsmatrix korting) geretourneerd, zodat de kortingen ook bij invoeren van de orderregels meegegeven kunnen worden
 * en ze uiteindelijk gespecificeerd op de factuur terechtkomen.<BR><BR>
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class GetRelatieArtikelPrijsRequest extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The artikelNummer
     * Meta informations extracted from the WSDL
     * - documentation: Nummer van het artikel waarvoor de prijs bepaald wordt
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $artikelNummer;
    /**
     * The relatieNummer
     * Meta informations extracted from the WSDL
     * - documentation: Het relatienummer van de relatie voor wie de prijs bepaald wordt
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $relatieNummer;
    /**
     * The aantal
     * Meta informations extracted from the WSDL
     * - documentation: Het aantal producten dat de klant wil bestellen (default 1)
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $aantal;
    /**
     * The datum
     * Meta informations extracted from the WSDL
     * - documentation: De datum waarop het artikel besteld zal worden (default vandaag)
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $datum;
    /**
     * The ordersoortCode
     * Meta informations extracted from the WSDL
     * - documentation: De code van de ordersoort waarmee de verkooporder aangemaakt zal gaan worden (default geen)
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ordersoortCode;
    /**
     * The afleverenOpPrive
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of het artikel op het prive adres afgeleverd zal gaan worden. De plaats van levering bepaalt namelijk welk BTW-percentage van toepassing is. Bij contactpersonen kan het land van levering afwijken (van het adres van het
     * bedrijf) indien gekozen wordt voor afleveren op prive
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $afleverenOpPrive;
    /**
     * Constructor method for getRelatieArtikelPrijsRequest
     * @uses GetRelatieArtikelPrijsRequest::setRequestTag()
     * @uses GetRelatieArtikelPrijsRequest::setArtikelNummer()
     * @uses GetRelatieArtikelPrijsRequest::setRelatieNummer()
     * @uses GetRelatieArtikelPrijsRequest::setAantal()
     * @uses GetRelatieArtikelPrijsRequest::setDatum()
     * @uses GetRelatieArtikelPrijsRequest::setOrdersoortCode()
     * @uses GetRelatieArtikelPrijsRequest::setAfleverenOpPrive()
     * @param string $requestTag
     * @param int $artikelNummer
     * @param int $relatieNummer
     * @param int $aantal
     * @param string $datum
     * @param string $ordersoortCode
     * @param bool $afleverenOpPrive
     */
    public function __construct($requestTag = null, $artikelNummer = null, $relatieNummer = null, $aantal = null, $datum = null, $ordersoortCode = null, $afleverenOpPrive = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setArtikelNummer($artikelNummer)
            ->setRelatieNummer($relatieNummer)
            ->setAantal($aantal)
            ->setDatum($datum)
            ->setOrdersoortCode($ordersoortCode)
            ->setAfleverenOpPrive($afleverenOpPrive);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \VoorraadApiV5\StructType\GetRelatieArtikelPrijsRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get artikelNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getArtikelNummer()
    {
        return isset($this->artikelNummer) ? $this->artikelNummer : null;
    }
    /**
     * Set artikelNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $artikelNummer
     * @return \VoorraadApiV5\StructType\GetRelatieArtikelPrijsRequest
     */
    public function setArtikelNummer($artikelNummer = null)
    {
        // validation for constraint: int
        if (!is_null($artikelNummer) && !(is_int($artikelNummer) || ctype_digit($artikelNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($artikelNummer, true), gettype($artikelNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($artikelNummer) && mb_strlen(preg_replace('/(\D)/', '', $artikelNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($artikelNummer, true), mb_strlen(preg_replace('/(\D)/', '', $artikelNummer))), __LINE__);
        }
        if (is_null($artikelNummer) || (is_array($artikelNummer) && empty($artikelNummer))) {
            unset($this->artikelNummer);
        } else {
            $this->artikelNummer = $artikelNummer;
        }
        return $this;
    }
    /**
     * Get relatieNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRelatieNummer()
    {
        return isset($this->relatieNummer) ? $this->relatieNummer : null;
    }
    /**
     * Set relatieNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $relatieNummer
     * @return \VoorraadApiV5\StructType\GetRelatieArtikelPrijsRequest
     */
    public function setRelatieNummer($relatieNummer = null)
    {
        // validation for constraint: int
        if (!is_null($relatieNummer) && !(is_int($relatieNummer) || ctype_digit($relatieNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relatieNummer, true), gettype($relatieNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relatieNummer) && mb_strlen(preg_replace('/(\D)/', '', $relatieNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relatieNummer, true), mb_strlen(preg_replace('/(\D)/', '', $relatieNummer))), __LINE__);
        }
        if (is_null($relatieNummer) || (is_array($relatieNummer) && empty($relatieNummer))) {
            unset($this->relatieNummer);
        } else {
            $this->relatieNummer = $relatieNummer;
        }
        return $this;
    }
    /**
     * Get aantal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAantal()
    {
        return isset($this->aantal) ? $this->aantal : null;
    }
    /**
     * Set aantal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aantal
     * @return \VoorraadApiV5\StructType\GetRelatieArtikelPrijsRequest
     */
    public function setAantal($aantal = null)
    {
        // validation for constraint: int
        if (!is_null($aantal) && !(is_int($aantal) || ctype_digit($aantal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aantal, true), gettype($aantal)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($aantal) && mb_strlen(preg_replace('/(\D)/', '', $aantal)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($aantal, true), mb_strlen(preg_replace('/(\D)/', '', $aantal))), __LINE__);
        }
        if (is_null($aantal) || (is_array($aantal) && empty($aantal))) {
            unset($this->aantal);
        } else {
            $this->aantal = $aantal;
        }
        return $this;
    }
    /**
     * Get datum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatum()
    {
        return isset($this->datum) ? $this->datum : null;
    }
    /**
     * Set datum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datum
     * @return \VoorraadApiV5\StructType\GetRelatieArtikelPrijsRequest
     */
    public function setDatum($datum = null)
    {
        // validation for constraint: string
        if (!is_null($datum) && !is_string($datum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datum, true), gettype($datum)), __LINE__);
        }
        if (is_null($datum) || (is_array($datum) && empty($datum))) {
            unset($this->datum);
        } else {
            $this->datum = $datum;
        }
        return $this;
    }
    /**
     * Get ordersoortCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrdersoortCode()
    {
        return isset($this->ordersoortCode) ? $this->ordersoortCode : null;
    }
    /**
     * Set ordersoortCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ordersoortCode
     * @return \VoorraadApiV5\StructType\GetRelatieArtikelPrijsRequest
     */
    public function setOrdersoortCode($ordersoortCode = null)
    {
        // validation for constraint: string
        if (!is_null($ordersoortCode) && !is_string($ordersoortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ordersoortCode, true), gettype($ordersoortCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($ordersoortCode) && mb_strlen($ordersoortCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($ordersoortCode)), __LINE__);
        }
        if (is_null($ordersoortCode) || (is_array($ordersoortCode) && empty($ordersoortCode))) {
            unset($this->ordersoortCode);
        } else {
            $this->ordersoortCode = $ordersoortCode;
        }
        return $this;
    }
    /**
     * Get afleverenOpPrive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAfleverenOpPrive()
    {
        return isset($this->afleverenOpPrive) ? $this->afleverenOpPrive : null;
    }
    /**
     * Set afleverenOpPrive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $afleverenOpPrive
     * @return \VoorraadApiV5\StructType\GetRelatieArtikelPrijsRequest
     */
    public function setAfleverenOpPrive($afleverenOpPrive = null)
    {
        // validation for constraint: boolean
        if (!is_null($afleverenOpPrive) && !is_bool($afleverenOpPrive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($afleverenOpPrive, true), gettype($afleverenOpPrive)), __LINE__);
        }
        if (is_null($afleverenOpPrive) || (is_array($afleverenOpPrive) && empty($afleverenOpPrive))) {
            unset($this->afleverenOpPrive);
        } else {
            $this->afleverenOpPrive = $afleverenOpPrive;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\GetRelatieArtikelPrijsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
