<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getArtikelLijstInfoResponse StructType
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class GetArtikelLijstInfoResponse extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The artikelLijst
     * Meta informations extracted from the WSDL
     * - documentation: De lijst met beschikbare voorraad artikelen
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \VoorraadApiV5\StructType\VoorraadArtikeltableV5
     */
    public $artikelLijst;
    /**
     * Constructor method for getArtikelLijstInfoResponse
     * @uses GetArtikelLijstInfoResponse::setRequestTag()
     * @uses GetArtikelLijstInfoResponse::setArtikelLijst()
     * @param string $requestTag
     * @param \VoorraadApiV5\StructType\VoorraadArtikeltableV5 $artikelLijst
     */
    public function __construct($requestTag = null, \VoorraadApiV5\StructType\VoorraadArtikeltableV5 $artikelLijst = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setArtikelLijst($artikelLijst);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \VoorraadApiV5\StructType\GetArtikelLijstInfoResponse
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get artikelLijst value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \VoorraadApiV5\StructType\VoorraadArtikeltableV5|null
     */
    public function getArtikelLijst()
    {
        return isset($this->artikelLijst) ? $this->artikelLijst : null;
    }
    /**
     * Set artikelLijst value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \VoorraadApiV5\StructType\VoorraadArtikeltableV5 $artikelLijst
     * @return \VoorraadApiV5\StructType\GetArtikelLijstInfoResponse
     */
    public function setArtikelLijst(\VoorraadApiV5\StructType\VoorraadArtikeltableV5 $artikelLijst = null)
    {
        if (is_null($artikelLijst) || (is_array($artikelLijst) && empty($artikelLijst))) {
            unset($this->artikelLijst);
        } else {
            $this->artikelLijst = $artikelLijst;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\GetArtikelLijstInfoResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
