<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getArtikelLijstInfoRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ophalen informatie betreffende voorraad-artikelgegevens
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class GetArtikelLijstInfoRequest extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The inclusiefInactief
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie ook inactieve artikelen retourneren. false(Default)=Alleen actieve, true=Ook inactieve artikelen
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $inclusiefInactief;
    /**
     * The fondsGroepCode
     * Meta informations extracted from the WSDL
     * - documentation: De code van de fondsgroep waarvoor artikelen (publicaties) moeten worden opgehaald. Wordt niet gebruikt indien leeg.
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $fondsGroepCode;
    /**
     * The fondsCode
     * Meta informations extracted from the WSDL
     * - documentation: De code van het fonds waarvoor artikelen (publicaties) moeten worden opgehaald. Wordt niet gebruikt indien leeg.
     * - base: xsd:string
     * - maxLength: 25
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $fondsCode;
    /**
     * The inclusiefRechthebbenden
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie ook rechthebbende (auteur en/of redacteur) gegevens ophalen. false(Default)=niet ophalen, true=Wel ophalen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $inclusiefRechthebbenden;
    /**
     * The inclusiefCoderingen
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie ook coderingsinformatie ophalen (o.a. NUR coderingen). false(Default)=niet ophalen, true=Wel ophalen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $inclusiefCoderingen;
    /**
     * The inclusiefPrijzen
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of ook extra prijsinformatie meegegeven moet worden. false(Default)=niet ophalen, true=Wel ophalen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $inclusiefPrijzen;
    /**
     * The inclusiefStaffels
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of ook Staffelinformatie meegegeven moet worden. false(Default)=niet ophalen, true=Wel ophalen.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $inclusiefStaffels;
    /**
     * Constructor method for getArtikelLijstInfoRequest
     * @uses GetArtikelLijstInfoRequest::setRequestTag()
     * @uses GetArtikelLijstInfoRequest::setInclusiefInactief()
     * @uses GetArtikelLijstInfoRequest::setFondsGroepCode()
     * @uses GetArtikelLijstInfoRequest::setFondsCode()
     * @uses GetArtikelLijstInfoRequest::setInclusiefRechthebbenden()
     * @uses GetArtikelLijstInfoRequest::setInclusiefCoderingen()
     * @uses GetArtikelLijstInfoRequest::setInclusiefPrijzen()
     * @uses GetArtikelLijstInfoRequest::setInclusiefStaffels()
     * @param string $requestTag
     * @param bool $inclusiefInactief
     * @param string $fondsGroepCode
     * @param string $fondsCode
     * @param bool $inclusiefRechthebbenden
     * @param bool $inclusiefCoderingen
     * @param bool $inclusiefPrijzen
     * @param bool $inclusiefStaffels
     */
    public function __construct($requestTag = null, $inclusiefInactief = null, $fondsGroepCode = null, $fondsCode = null, $inclusiefRechthebbenden = null, $inclusiefCoderingen = null, $inclusiefPrijzen = null, $inclusiefStaffels = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setInclusiefInactief($inclusiefInactief)
            ->setFondsGroepCode($fondsGroepCode)
            ->setFondsCode($fondsCode)
            ->setInclusiefRechthebbenden($inclusiefRechthebbenden)
            ->setInclusiefCoderingen($inclusiefCoderingen)
            ->setInclusiefPrijzen($inclusiefPrijzen)
            ->setInclusiefStaffels($inclusiefStaffels);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \VoorraadApiV5\StructType\GetArtikelLijstInfoRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get inclusiefInactief value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getInclusiefInactief()
    {
        return isset($this->inclusiefInactief) ? $this->inclusiefInactief : null;
    }
    /**
     * Set inclusiefInactief value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $inclusiefInactief
     * @return \VoorraadApiV5\StructType\GetArtikelLijstInfoRequest
     */
    public function setInclusiefInactief($inclusiefInactief = null)
    {
        // validation for constraint: boolean
        if (!is_null($inclusiefInactief) && !is_bool($inclusiefInactief)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inclusiefInactief, true), gettype($inclusiefInactief)), __LINE__);
        }
        if (is_null($inclusiefInactief) || (is_array($inclusiefInactief) && empty($inclusiefInactief))) {
            unset($this->inclusiefInactief);
        } else {
            $this->inclusiefInactief = $inclusiefInactief;
        }
        return $this;
    }
    /**
     * Get fondsGroepCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFondsGroepCode()
    {
        return isset($this->fondsGroepCode) ? $this->fondsGroepCode : null;
    }
    /**
     * Set fondsGroepCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fondsGroepCode
     * @return \VoorraadApiV5\StructType\GetArtikelLijstInfoRequest
     */
    public function setFondsGroepCode($fondsGroepCode = null)
    {
        // validation for constraint: string
        if (!is_null($fondsGroepCode) && !is_string($fondsGroepCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fondsGroepCode, true), gettype($fondsGroepCode)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($fondsGroepCode) && mb_strlen($fondsGroepCode) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($fondsGroepCode)), __LINE__);
        }
        if (is_null($fondsGroepCode) || (is_array($fondsGroepCode) && empty($fondsGroepCode))) {
            unset($this->fondsGroepCode);
        } else {
            $this->fondsGroepCode = $fondsGroepCode;
        }
        return $this;
    }
    /**
     * Get fondsCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFondsCode()
    {
        return isset($this->fondsCode) ? $this->fondsCode : null;
    }
    /**
     * Set fondsCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fondsCode
     * @return \VoorraadApiV5\StructType\GetArtikelLijstInfoRequest
     */
    public function setFondsCode($fondsCode = null)
    {
        // validation for constraint: string
        if (!is_null($fondsCode) && !is_string($fondsCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fondsCode, true), gettype($fondsCode)), __LINE__);
        }
        // validation for constraint: maxLength(25)
        if (!is_null($fondsCode) && mb_strlen($fondsCode) > 25) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 25', mb_strlen($fondsCode)), __LINE__);
        }
        if (is_null($fondsCode) || (is_array($fondsCode) && empty($fondsCode))) {
            unset($this->fondsCode);
        } else {
            $this->fondsCode = $fondsCode;
        }
        return $this;
    }
    /**
     * Get inclusiefRechthebbenden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getInclusiefRechthebbenden()
    {
        return isset($this->inclusiefRechthebbenden) ? $this->inclusiefRechthebbenden : null;
    }
    /**
     * Set inclusiefRechthebbenden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $inclusiefRechthebbenden
     * @return \VoorraadApiV5\StructType\GetArtikelLijstInfoRequest
     */
    public function setInclusiefRechthebbenden($inclusiefRechthebbenden = null)
    {
        // validation for constraint: boolean
        if (!is_null($inclusiefRechthebbenden) && !is_bool($inclusiefRechthebbenden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inclusiefRechthebbenden, true), gettype($inclusiefRechthebbenden)), __LINE__);
        }
        if (is_null($inclusiefRechthebbenden) || (is_array($inclusiefRechthebbenden) && empty($inclusiefRechthebbenden))) {
            unset($this->inclusiefRechthebbenden);
        } else {
            $this->inclusiefRechthebbenden = $inclusiefRechthebbenden;
        }
        return $this;
    }
    /**
     * Get inclusiefCoderingen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getInclusiefCoderingen()
    {
        return isset($this->inclusiefCoderingen) ? $this->inclusiefCoderingen : null;
    }
    /**
     * Set inclusiefCoderingen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $inclusiefCoderingen
     * @return \VoorraadApiV5\StructType\GetArtikelLijstInfoRequest
     */
    public function setInclusiefCoderingen($inclusiefCoderingen = null)
    {
        // validation for constraint: boolean
        if (!is_null($inclusiefCoderingen) && !is_bool($inclusiefCoderingen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inclusiefCoderingen, true), gettype($inclusiefCoderingen)), __LINE__);
        }
        if (is_null($inclusiefCoderingen) || (is_array($inclusiefCoderingen) && empty($inclusiefCoderingen))) {
            unset($this->inclusiefCoderingen);
        } else {
            $this->inclusiefCoderingen = $inclusiefCoderingen;
        }
        return $this;
    }
    /**
     * Get inclusiefPrijzen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getInclusiefPrijzen()
    {
        return isset($this->inclusiefPrijzen) ? $this->inclusiefPrijzen : null;
    }
    /**
     * Set inclusiefPrijzen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $inclusiefPrijzen
     * @return \VoorraadApiV5\StructType\GetArtikelLijstInfoRequest
     */
    public function setInclusiefPrijzen($inclusiefPrijzen = null)
    {
        // validation for constraint: boolean
        if (!is_null($inclusiefPrijzen) && !is_bool($inclusiefPrijzen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inclusiefPrijzen, true), gettype($inclusiefPrijzen)), __LINE__);
        }
        if (is_null($inclusiefPrijzen) || (is_array($inclusiefPrijzen) && empty($inclusiefPrijzen))) {
            unset($this->inclusiefPrijzen);
        } else {
            $this->inclusiefPrijzen = $inclusiefPrijzen;
        }
        return $this;
    }
    /**
     * Get inclusiefStaffels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getInclusiefStaffels()
    {
        return isset($this->inclusiefStaffels) ? $this->inclusiefStaffels : null;
    }
    /**
     * Set inclusiefStaffels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $inclusiefStaffels
     * @return \VoorraadApiV5\StructType\GetArtikelLijstInfoRequest
     */
    public function setInclusiefStaffels($inclusiefStaffels = null)
    {
        // validation for constraint: boolean
        if (!is_null($inclusiefStaffels) && !is_bool($inclusiefStaffels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inclusiefStaffels, true), gettype($inclusiefStaffels)), __LINE__);
        }
        if (is_null($inclusiefStaffels) || (is_array($inclusiefStaffels) && empty($inclusiefStaffels))) {
            unset($this->inclusiefStaffels);
        } else {
            $this->inclusiefStaffels = $inclusiefStaffels;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\GetArtikelLijstInfoRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
