<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getArtikelInfoRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ophalen informatie betreffende 1 voorraad-artikel
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class GetArtikelInfoRequest extends AbstractStructBase
{
    /**
     * The artikelCode
     * Meta informations extracted from the WSDL
     * - documentation: De unieke code van het artikel
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $artikelCode;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * Constructor method for getArtikelInfoRequest
     * @uses GetArtikelInfoRequest::setArtikelCode()
     * @uses GetArtikelInfoRequest::setRequestTag()
     * @param string $artikelCode
     * @param string $requestTag
     */
    public function __construct($artikelCode = null, $requestTag = null)
    {
        $this
            ->setArtikelCode($artikelCode)
            ->setRequestTag($requestTag);
    }
    /**
     * Get artikelCode value
     * @return string
     */
    public function getArtikelCode()
    {
        return $this->artikelCode;
    }
    /**
     * Set artikelCode value
     * @param string $artikelCode
     * @return \VoorraadApiV5\StructType\GetArtikelInfoRequest
     */
    public function setArtikelCode($artikelCode = null)
    {
        // validation for constraint: string
        if (!is_null($artikelCode) && !is_string($artikelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($artikelCode, true), gettype($artikelCode)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($artikelCode) && mb_strlen($artikelCode) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($artikelCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($artikelCode) && mb_strlen($artikelCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($artikelCode)), __LINE__);
        }
        $this->artikelCode = $artikelCode;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \VoorraadApiV5\StructType\GetArtikelInfoRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\GetArtikelInfoRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
