<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DownloadLinkTableV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met download links
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class DownloadLinkTableV5 extends AbstractStructBase
{
    /**
     * The downloadLink
     * Meta informations extracted from the WSDL
     * - documentation: DownloadLinkRec
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - nillable: false
     * @var \VoorraadApiV5\StructType\DownloadLinkRecV5[]
     */
    public $downloadLink;
    /**
     * Constructor method for DownloadLinkTableV5
     * @uses DownloadLinkTableV5::setDownloadLink()
     * @param \VoorraadApiV5\StructType\DownloadLinkRecV5[] $downloadLink
     */
    public function __construct(array $downloadLink = array())
    {
        $this
            ->setDownloadLink($downloadLink);
    }
    /**
     * Get downloadLink value
     * @return \VoorraadApiV5\StructType\DownloadLinkRecV5[]
     */
    public function getDownloadLink()
    {
        return $this->downloadLink;
    }
    /**
     * This method is responsible for validating the values passed to the setDownloadLink method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDownloadLink method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDownloadLinkForArrayConstraintsFromSetDownloadLink(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $downloadLinkTableV5DownloadLinkItem) {
            // validation for constraint: itemType
            if (!$downloadLinkTableV5DownloadLinkItem instanceof \VoorraadApiV5\StructType\DownloadLinkRecV5) {
                $invalidValues[] = is_object($downloadLinkTableV5DownloadLinkItem) ? get_class($downloadLinkTableV5DownloadLinkItem) : sprintf('%s(%s)', gettype($downloadLinkTableV5DownloadLinkItem), var_export($downloadLinkTableV5DownloadLinkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The downloadLink property can only contain items of type \VoorraadApiV5\StructType\DownloadLinkRecV5, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set downloadLink value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\DownloadLinkRecV5[] $downloadLink
     * @return \VoorraadApiV5\StructType\DownloadLinkTableV5
     */
    public function setDownloadLink(array $downloadLink = array())
    {
        // validation for constraint: array
        if ('' !== ($downloadLinkArrayErrorMessage = self::validateDownloadLinkForArrayConstraintsFromSetDownloadLink($downloadLink))) {
            throw new \InvalidArgumentException($downloadLinkArrayErrorMessage, __LINE__);
        }
        $this->downloadLink = $downloadLink;
        return $this;
    }
    /**
     * Add item to downloadLink value
     * @throws \InvalidArgumentException
     * @param \VoorraadApiV5\StructType\DownloadLinkRecV5 $item
     * @return \VoorraadApiV5\StructType\DownloadLinkTableV5
     */
    public function addToDownloadLink(\VoorraadApiV5\StructType\DownloadLinkRecV5 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \VoorraadApiV5\StructType\DownloadLinkRecV5) {
            throw new \InvalidArgumentException(sprintf('The downloadLink property can only contain items of type \VoorraadApiV5\StructType\DownloadLinkRecV5, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->downloadLink[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\DownloadLinkTableV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
