<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArtikelPrijzenRecV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Prijzen van een artikel
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class ArtikelPrijzenRecV5 extends AbstractStructBase
{
    /**
     * The geldigVanaf
     * Meta informations extracted from the WSDL
     * - documentation: Datum vanaf wanneer een prijs geldig is
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $geldigVanaf;
    /**
     * The geldigTm
     * Meta informations extracted from the WSDL
     * - documentation: Einddatum van de geldigheid van de prijs. Indien leeg, is de prijs onbeperkt geldig
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $geldigTm;
    /**
     * The prijsExclBtw
     * Meta informations extracted from the WSDL
     * - documentation: Prijs exclusief BTW
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $prijsExclBtw;
    /**
     * The prijsInclBtw
     * Meta informations extracted from the WSDL
     * - documentation: Prijs inclusief BTW (standaard percentage)
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var float
     */
    public $prijsInclBtw;
    /**
     * Constructor method for ArtikelPrijzenRecV5
     * @uses ArtikelPrijzenRecV5::setGeldigVanaf()
     * @uses ArtikelPrijzenRecV5::setGeldigTm()
     * @uses ArtikelPrijzenRecV5::setPrijsExclBtw()
     * @uses ArtikelPrijzenRecV5::setPrijsInclBtw()
     * @param string $geldigVanaf
     * @param string $geldigTm
     * @param float $prijsExclBtw
     * @param float $prijsInclBtw
     */
    public function __construct($geldigVanaf = null, $geldigTm = null, $prijsExclBtw = null, $prijsInclBtw = null)
    {
        $this
            ->setGeldigVanaf($geldigVanaf)
            ->setGeldigTm($geldigTm)
            ->setPrijsExclBtw($prijsExclBtw)
            ->setPrijsInclBtw($prijsInclBtw);
    }
    /**
     * Get geldigVanaf value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeldigVanaf()
    {
        return isset($this->geldigVanaf) ? $this->geldigVanaf : null;
    }
    /**
     * Set geldigVanaf value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $geldigVanaf
     * @return \VoorraadApiV5\StructType\ArtikelPrijzenRecV5
     */
    public function setGeldigVanaf($geldigVanaf = null)
    {
        // validation for constraint: string
        if (!is_null($geldigVanaf) && !is_string($geldigVanaf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geldigVanaf, true), gettype($geldigVanaf)), __LINE__);
        }
        if (is_null($geldigVanaf) || (is_array($geldigVanaf) && empty($geldigVanaf))) {
            unset($this->geldigVanaf);
        } else {
            $this->geldigVanaf = $geldigVanaf;
        }
        return $this;
    }
    /**
     * Get geldigTm value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGeldigTm()
    {
        return isset($this->geldigTm) ? $this->geldigTm : null;
    }
    /**
     * Set geldigTm value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $geldigTm
     * @return \VoorraadApiV5\StructType\ArtikelPrijzenRecV5
     */
    public function setGeldigTm($geldigTm = null)
    {
        // validation for constraint: string
        if (!is_null($geldigTm) && !is_string($geldigTm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geldigTm, true), gettype($geldigTm)), __LINE__);
        }
        if (is_null($geldigTm) || (is_array($geldigTm) && empty($geldigTm))) {
            unset($this->geldigTm);
        } else {
            $this->geldigTm = $geldigTm;
        }
        return $this;
    }
    /**
     * Get prijsExclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrijsExclBtw()
    {
        return isset($this->prijsExclBtw) ? $this->prijsExclBtw : null;
    }
    /**
     * Set prijsExclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prijsExclBtw
     * @return \VoorraadApiV5\StructType\ArtikelPrijzenRecV5
     */
    public function setPrijsExclBtw($prijsExclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($prijsExclBtw) && !(is_float($prijsExclBtw) || is_numeric($prijsExclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prijsExclBtw, true), gettype($prijsExclBtw)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($prijsExclBtw) && mb_strlen(preg_replace('/(\D)/', '', $prijsExclBtw)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($prijsExclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $prijsExclBtw))), __LINE__);
        }
        if (is_null($prijsExclBtw) || (is_array($prijsExclBtw) && empty($prijsExclBtw))) {
            unset($this->prijsExclBtw);
        } else {
            $this->prijsExclBtw = $prijsExclBtw;
        }
        return $this;
    }
    /**
     * Get prijsInclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrijsInclBtw()
    {
        return isset($this->prijsInclBtw) ? $this->prijsInclBtw : null;
    }
    /**
     * Set prijsInclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prijsInclBtw
     * @return \VoorraadApiV5\StructType\ArtikelPrijzenRecV5
     */
    public function setPrijsInclBtw($prijsInclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($prijsInclBtw) && !(is_float($prijsInclBtw) || is_numeric($prijsInclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prijsInclBtw, true), gettype($prijsInclBtw)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($prijsInclBtw) && mb_strlen(mb_substr($prijsInclBtw, mb_strpos($prijsInclBtw, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($prijsInclBtw, true), mb_strlen(mb_substr($prijsInclBtw, mb_strpos($prijsInclBtw, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($prijsInclBtw) && mb_strlen(preg_replace('/(\D)/', '', $prijsInclBtw)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($prijsInclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $prijsInclBtw))), __LINE__);
        }
        if (is_null($prijsInclBtw) || (is_array($prijsInclBtw) && empty($prijsInclBtw))) {
            unset($this->prijsInclBtw);
        } else {
            $this->prijsInclBtw = $prijsInclBtw;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\ArtikelPrijzenRecV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
