<?php

namespace VoorraadApiV5\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdresRecV5 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Adres gegevens.
 * @subpackage Structs
 * @date 20190723
 * @package VoorraadApiV5
 */
class AdresRecV5 extends AbstractStructBase
{
    /**
     * The straatnaam
     * Meta informations extracted from the WSDL
     * - documentation: De straatnaam van het adres
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $straatnaam;
    /**
     * The huisnummer
     * Meta informations extracted from the WSDL
     * - documentation: Het huisnummer van het adres
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $huisnummer;
    /**
     * The postcode
     * Meta informations extracted from the WSDL
     * - documentation: De postcode van het adres
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $postcode;
    /**
     * The plaatsnaam
     * Meta informations extracted from the WSDL
     * - documentation: De plaatsnaam van het adres
     * - base: xsd:string
     * - maxLength: 40
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $plaatsnaam;
    /**
     * The huisnummerToevoeging
     * Meta informations extracted from the WSDL
     * - documentation: De huisnummer toevoeging van het adres
     * - base: xsd:string
     * - maxLength: 10
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $huisnummerToevoeging;
    /**
     * Constructor method for AdresRecV5
     * @uses AdresRecV5::setStraatnaam()
     * @uses AdresRecV5::setHuisnummer()
     * @uses AdresRecV5::setPostcode()
     * @uses AdresRecV5::setPlaatsnaam()
     * @uses AdresRecV5::setHuisnummerToevoeging()
     * @param string $straatnaam
     * @param string $huisnummer
     * @param string $postcode
     * @param string $plaatsnaam
     * @param string $huisnummerToevoeging
     */
    public function __construct($straatnaam = null, $huisnummer = null, $postcode = null, $plaatsnaam = null, $huisnummerToevoeging = null)
    {
        $this
            ->setStraatnaam($straatnaam)
            ->setHuisnummer($huisnummer)
            ->setPostcode($postcode)
            ->setPlaatsnaam($plaatsnaam)
            ->setHuisnummerToevoeging($huisnummerToevoeging);
    }
    /**
     * Get straatnaam value
     * @return string
     */
    public function getStraatnaam()
    {
        return $this->straatnaam;
    }
    /**
     * Set straatnaam value
     * @param string $straatnaam
     * @return \VoorraadApiV5\StructType\AdresRecV5
     */
    public function setStraatnaam($straatnaam = null)
    {
        // validation for constraint: string
        if (!is_null($straatnaam) && !is_string($straatnaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($straatnaam, true), gettype($straatnaam)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($straatnaam) && mb_strlen($straatnaam) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($straatnaam)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($straatnaam) && mb_strlen($straatnaam) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($straatnaam)), __LINE__);
        }
        $this->straatnaam = $straatnaam;
        return $this;
    }
    /**
     * Get huisnummer value
     * @return string
     */
    public function getHuisnummer()
    {
        return $this->huisnummer;
    }
    /**
     * Set huisnummer value
     * @param string $huisnummer
     * @return \VoorraadApiV5\StructType\AdresRecV5
     */
    public function setHuisnummer($huisnummer = null)
    {
        // validation for constraint: string
        if (!is_null($huisnummer) && !is_string($huisnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($huisnummer, true), gettype($huisnummer)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($huisnummer) && mb_strlen($huisnummer) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($huisnummer)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($huisnummer) && mb_strlen($huisnummer) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($huisnummer)), __LINE__);
        }
        $this->huisnummer = $huisnummer;
        return $this;
    }
    /**
     * Get postcode value
     * @return string
     */
    public function getPostcode()
    {
        return $this->postcode;
    }
    /**
     * Set postcode value
     * @param string $postcode
     * @return \VoorraadApiV5\StructType\AdresRecV5
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postcode, true), gettype($postcode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($postcode) && mb_strlen($postcode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($postcode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($postcode) && mb_strlen($postcode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($postcode)), __LINE__);
        }
        $this->postcode = $postcode;
        return $this;
    }
    /**
     * Get plaatsnaam value
     * @return string
     */
    public function getPlaatsnaam()
    {
        return $this->plaatsnaam;
    }
    /**
     * Set plaatsnaam value
     * @param string $plaatsnaam
     * @return \VoorraadApiV5\StructType\AdresRecV5
     */
    public function setPlaatsnaam($plaatsnaam = null)
    {
        // validation for constraint: string
        if (!is_null($plaatsnaam) && !is_string($plaatsnaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plaatsnaam, true), gettype($plaatsnaam)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($plaatsnaam) && mb_strlen($plaatsnaam) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($plaatsnaam)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($plaatsnaam) && mb_strlen($plaatsnaam) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($plaatsnaam)), __LINE__);
        }
        $this->plaatsnaam = $plaatsnaam;
        return $this;
    }
    /**
     * Get huisnummerToevoeging value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHuisnummerToevoeging()
    {
        return isset($this->huisnummerToevoeging) ? $this->huisnummerToevoeging : null;
    }
    /**
     * Set huisnummerToevoeging value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $huisnummerToevoeging
     * @return \VoorraadApiV5\StructType\AdresRecV5
     */
    public function setHuisnummerToevoeging($huisnummerToevoeging = null)
    {
        // validation for constraint: string
        if (!is_null($huisnummerToevoeging) && !is_string($huisnummerToevoeging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($huisnummerToevoeging, true), gettype($huisnummerToevoeging)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($huisnummerToevoeging) && mb_strlen($huisnummerToevoeging) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($huisnummerToevoeging)), __LINE__);
        }
        if (is_null($huisnummerToevoeging) || (is_array($huisnummerToevoeging) && empty($huisnummerToevoeging))) {
            unset($this->huisnummerToevoeging);
        } else {
            $this->huisnummerToevoeging = $huisnummerToevoeging;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \VoorraadApiV5\StructType\AdresRecV5
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
