<?php

namespace VoorraadApiV5\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 * @date 20190723
 * @package VoorraadApiV5
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \VoorraadApiV5\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\VoorraadApiV5\StructType\Authentication $authentication, $nameSpace = 'http://zeno.socho.nl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named getFondsGroepen
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \VoorraadApiV5\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen fonds groepen.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \VoorraadApiV5\StructType\GetFondsGroepenRequest $request_parameters
     * @return \VoorraadApiV5\StructType\GetFondsGroepenResponse|bool
     */
    public function getFondsGroepen(\VoorraadApiV5\StructType\GetFondsGroepenRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getFondsGroepen($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getFondsenPerGroep
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \VoorraadApiV5\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen fondsen per fondsgroep.error1: De fondsGroepCode waarvoor fondsen moeten worden opgehaald mag niet leeg zijn.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \VoorraadApiV5\StructType\GetFondsenPerGroepRequest $request_parameters
     * @return \VoorraadApiV5\StructType\GetFondsenPerGroepResponse|bool
     */
    public function getFondsenPerGroep(\VoorraadApiV5\StructType\GetFondsenPerGroepRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getFondsenPerGroep($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getArtikelInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \VoorraadApiV5\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen informatie betreffende 1 voorraad-artikelerror519: Op basis van de opgegeven code is geen artikel gevondenerror520: Op basis van de opgegeven code zijn meerdere artikelen gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \VoorraadApiV5\StructType\GetArtikelInfoRequest $request_parameters
     * @return \VoorraadApiV5\StructType\GetArtikelInfoResponse|bool
     */
    public function getArtikelInfo(\VoorraadApiV5\StructType\GetArtikelInfoRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getArtikelInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getArtikelLijstInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \VoorraadApiV5\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen informatie betreffende voorraad-artikelgegevens
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \VoorraadApiV5\StructType\GetArtikelLijstInfoRequest $request_parameters
     * @return \VoorraadApiV5\StructType\GetArtikelLijstInfoResponse|bool
     */
    public function getArtikelLijstInfo(\VoorraadApiV5\StructType\GetArtikelLijstInfoRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getArtikelLijstInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVoorraadInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \VoorraadApiV5\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen informatie betreffende betreft voorraadgegevens
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \VoorraadApiV5\StructType\GetVoorraadInfoRequest $request_parameters
     * @return \VoorraadApiV5\StructType\GetVoorraadInfoResponse|bool
     */
    public function getVoorraadInfo(\VoorraadApiV5\StructType\GetVoorraadInfoRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getVoorraadInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVoorraadLijstInfo
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \VoorraadApiV5\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen informatie betreffende voorraadgegevens voor alle artikelen
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \VoorraadApiV5\StructType\GetVoorraadLijstInfoRequest $request_parameters
     * @return \VoorraadApiV5\StructType\GetVoorraadLijstInfoResponse|bool
     */
    public function getVoorraadLijstInfo(\VoorraadApiV5\StructType\GetVoorraadLijstInfoRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getVoorraadLijstInfo($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVerkoopOrders
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \VoorraadApiV5\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Geeft informatie terug van 1 of meer verkooporders.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \VoorraadApiV5\StructType\GetVerkoopOrdersRequest $request_parameters
     * @return \VoorraadApiV5\StructType\GetVerkoopOrdersResponse|bool
     */
    public function getVerkoopOrders(\VoorraadApiV5\StructType\GetVerkoopOrdersRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getVerkoopOrders($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getOrdersoorten
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \VoorraadApiV5\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen van een lijst met ordersoorten
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \VoorraadApiV5\StructType\GetOrdersoortenRequest $request_parameters
     * @return \VoorraadApiV5\StructType\GetOrdersoortenResponse|bool
     */
    public function getOrdersoorten(\VoorraadApiV5\StructType\GetOrdersoortenRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getOrdersoorten($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVerzendwijzen
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \VoorraadApiV5\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen van een lijst met verzendwijzen
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \VoorraadApiV5\StructType\GetVerzendwijzenRequest $request_parameters
     * @return \VoorraadApiV5\StructType\GetVerzendwijzenResponse|bool
     */
    public function getVerzendwijzen(\VoorraadApiV5\StructType\GetVerzendwijzenRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getVerzendwijzen($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRelatieArtikelPrijs
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \VoorraadApiV5\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen van een prijs van een artikel zoals die geldt voor een specifieke relatie, aantal, ordersoort en datum.<BR><BR> Hierbij wordt rekening gehouden met de prijsmatrix binnen Zeno. Afhankelijk van een globale instelling worden de
     * kortingen samengevoegd in het veld kortingBedrag of worden de kortingen gesplitst per categorie (staffelkorting, ordersoortkorting en prijsmatrix korting) geretourneerd, zodat de kortingen ook bij invoeren van de orderregels meegegeven kunnen worden
     * en ze uiteindelijk gespecificeerd op de factuur terechtkomen.<BR><BR>error500: De relatie is niet gevondenerror502: De ordersoort is niet gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \VoorraadApiV5\StructType\GetRelatieArtikelPrijsRequest $request_parameters
     * @return \VoorraadApiV5\StructType\GetRelatieArtikelPrijsResponse|bool
     */
    public function getRelatieArtikelPrijs(\VoorraadApiV5\StructType\GetRelatieArtikelPrijsRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getRelatieArtikelPrijs($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getVerschijningsvormen
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \VoorraadApiV5\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen van de beschikbare verschijningvormen
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \VoorraadApiV5\StructType\GetVerschijningsvormenRequest $request_parameters
     * @return \VoorraadApiV5\StructType\GetVerschijningsvormenResponse|bool
     */
    public function getVerschijningsvormen(\VoorraadApiV5\StructType\GetVerschijningsvormenRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getVerschijningsvormen($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getRelatieArtikelen
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \VoorraadApiV5\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen van artikelen die bij de relatie als orderregel op een verkooporder opgenomen zijn. Hierbij kunnen de verschijningsvorm en het ordernummer als filter opgegeven worden.error500: De relatie is niet gevondenerror511: De
     * verschijningsvorm is niet gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \VoorraadApiV5\StructType\GetRelatieArtikelenRequest $request_parameters
     * @return \VoorraadApiV5\StructType\GetRelatieArtikelenResponse|bool
     */
    public function getRelatieArtikelen(\VoorraadApiV5\StructType\GetRelatieArtikelenRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getRelatieArtikelen($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getLeveranties
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \VoorraadApiV5\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Ophalen van de leverantieregels van de leveranties die voor een relatie aangemaakt zijn. Hierbij kunnen de verschijningsvorm, het leverantienummer en het originele verkoopordernummer als filter opgegeven worden.error500: De relatie
     * is niet gevondenerror511: De verschijningsvorm is niet gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \VoorraadApiV5\StructType\GetLeverantiesRequest $request_parameters
     * @return \VoorraadApiV5\StructType\GetLeverantiesResponse|bool
     */
    public function getLeveranties(\VoorraadApiV5\StructType\GetLeverantiesRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getLeveranties($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \VoorraadApiV5\StructType\GetArtikelInfoResponse|\VoorraadApiV5\StructType\GetArtikelLijstInfoResponse|\VoorraadApiV5\StructType\GetFondsenPerGroepResponse|\VoorraadApiV5\StructType\GetFondsGroepenResponse|\VoorraadApiV5\StructType\GetLeverantiesResponse|\VoorraadApiV5\StructType\GetOrdersoortenResponse|\VoorraadApiV5\StructType\GetRelatieArtikelenResponse|\VoorraadApiV5\StructType\GetRelatieArtikelPrijsResponse|\VoorraadApiV5\StructType\GetVerkoopOrdersResponse|\VoorraadApiV5\StructType\GetVerschijningsvormenResponse|\VoorraadApiV5\StructType\GetVerzendwijzenResponse|\VoorraadApiV5\StructType\GetVoorraadInfoResponse|\VoorraadApiV5\StructType\GetVoorraadLijstInfoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
