<?php

namespace VoorraadApiV5\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 * @date 20190723
 * @package VoorraadApiV5
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Sets the Authentication SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \VoorraadApiV5\StructType\Authentication $authentication
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderAuthentication(\VoorraadApiV5\StructType\Authentication $authentication, $nameSpace = 'http://zeno.socho.nl', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'authentication', $authentication, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named createVerkoopOrder
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \VoorraadApiV5\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Aanmaken van een verkooporder. Afleveradres is standaard het bezoekadres (indien afleverenOpPrive en afleverenOpCorrespondentie beide waarde 0 hebben). Factuuradres is standaard het correspondentieadres (indien factuurOpPrive en
     * factuurOpBezoek beide waarde 0 hebben).error500: De relatie is niet gevondenerror501: De debiteur is niet gevondenerror502: De ordersoort is niet gevondenerror503: De verzendwijze is niet gevondenerror504: iDEAL order dient een iDEAL kenmerk te
     * hebbenerror505: Incasso order dient een bankrekening nummer te hebbenerror506: Ongeldig bankrekening nummererror507: Het artikel is niet gevondenerror508: De verkooporder kan niet aangemaakt worden. Voor de debiteur geldt een leververboderror509: Er
     * is een onverwachte fout opgetreden bij het factureren van de verkoopordererror510: Afleveradres is niet compleeterror512: Incasso order dient een IBAN nummer te hebbenerror513: Het opgegeven IBAN nummer voldoet niet aan de eisenerror514: De opgegeven
     * BIC code voldoet niet aan de eisenerror515: De opgegeven BIC code hoort niet bij het opgegeven IBAN nummererror516: Een IBAN nummer dient altijd in combinatie met een BIC code opgegeven te wordenerror517: Kan geen afleveradres bepalenerror518: Kan
     * geen factuuradres bepalenerror528: Het aantal exemplaren mag niet nul zijnerror529: Er is meer dan 100% korting gegeven op een orderregelerror532: De betalingsconditie is niet gevondenerror533: De valutacode is niet gevondenerror541: De waarde van
     * vrij code veld 1 kan niet worden gevonden in de databaseerror542: De waarde van vrij code veld 2 kan niet worden gevonden in de databaseerror543: De waarde van vrij code veld 3 kan niet worden gevonden in de databaseerror544: De waarde van vrij code
     * veld 4 kan niet worden gevonden in de database
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \VoorraadApiV5\StructType\CreateVerkoopOrderRequest $request_parameters
     * @return \VoorraadApiV5\StructType\CreateVerkoopOrderResponse|bool
     */
    public function createVerkoopOrder(\VoorraadApiV5\StructType\CreateVerkoopOrderRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->createVerkoopOrder($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createArtikel
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \VoorraadApiV5\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Aanmaken van een nieuw artikelerror521: Op basis van de opgegeven code is geen artikelgroep gevondenerror522: Op basis van de opgegeven code is geen BTW-code gevonden
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \VoorraadApiV5\StructType\CreateArtikelRequest $request_parameters
     * @return \VoorraadApiV5\StructType\CreateArtikelResponse|bool
     */
    public function createArtikel(\VoorraadApiV5\StructType\CreateArtikelRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->createArtikel($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named createLeverantie
     * Meta informations extracted from the WSDL
     * - SOAPHeaderNames: authentication
     * - SOAPHeaderNamespaces: http://zeno.socho.nl
     * - SOAPHeaderTypes: \VoorraadApiV5\StructType\Authentication
     * - SOAPHeaders: required
     * - documentation: Aanmaken van een leverantie. Afleveradres is standaard het bezoekadres (indien afleverenOpPrive en afleverenOpCorrespondentie beide waarde 0 hebben). Factuuradres is standaard het correspondentieadres (indien factuurOpPrive en
     * factuurOpBezoek beide waarde 0 hebben).error500: De relatie is niet gevondenerror501: De debiteur is niet gevondenerror502: De ordersoort is niet gevondenerror503: De verzendwijze is niet gevondenerror506: Ongeldig bankrekening nummererror507: Het
     * artikel is niet gevondenerror510: Afleveradres is niet compleeterror513: Het opgegeven IBAN nummer voldoet niet aan de eisenerror514: De opgegeven BIC code voldoet niet aan de eisenerror515: De opgegeven BIC code hoort niet bij het opgegeven IBAN
     * nummererror516: Een IBAN nummer dient altijd in combinatie met een BIC code opgegeven te wordenerror517: Kan geen afleveradres bepalenerror518: Kan geen factuuradres bepalenerror523: iDEAL leverantie dient een iDEAL kenmerk te hebbenerror524: Incasso
     * leverantie dient een bankrekening nummer te hebbenerror525: De leverantie kan niet aangemaakt worden. Voor de debiteur geldt een leververboderror526: Er is een onverwachte fout opgetreden bij het factureren van de leverantieerror527: Incasso
     * leverantie dient een IBAN nummer te hebbenerror532: De betalingsconditie is niet gevondenerror533: De valutacode is niet gevondenerror541: De waarde van vrij code veld 1 kan niet worden gevonden in de databaseerror542: De waarde van vrij code veld 2
     * kan niet worden gevonden in de databaseerror543: De waarde van vrij code veld 3 kan niet worden gevonden in de databaseerror544: De waarde van vrij code veld 4 kan niet worden gevonden in de database
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \VoorraadApiV5\StructType\CreateLeverantieRequest $request_parameters
     * @return \VoorraadApiV5\StructType\CreateLeverantieResponse|bool
     */
    public function createLeverantie(\VoorraadApiV5\StructType\CreateLeverantieRequest $request_parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->createLeverantie($request_parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \VoorraadApiV5\StructType\CreateArtikelResponse|\VoorraadApiV5\StructType\CreateLeverantieResponse|\VoorraadApiV5\StructType\CreateVerkoopOrderResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
