<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ToekMutV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Gegevens met betrekking tot een toekomstige mutatie, zoals bijvoorbeeld een verhuizing of vakantie regeling.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class ToekMutV4 extends AbstractStructBase
{
    /**
     * The toekMutNo
     * Meta informations extracted from the WSDL
     * - documentation: Toekomstige mutatie nummer.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $toekMutNo;
    /**
     * The relNo
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * The datumVan
     * Meta informations extracted from the WSDL
     * - documentation: Ingangsdatum (datum vanaf).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $datumVan;
    /**
     * The datumTm
     * Meta informations extracted from the WSDL
     * - documentation: Einddatum (datum tot en met). Indien deze leeg is, geldt de wijziging permanent voor de toekomst.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $datumTm;
    /**
     * The specifiekVoorAbonnement
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie: true geeft aan of de regeling/verhuizing specifiek voor een abonnement geldt, false of deze integraal voor de relatie geldt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $specifiekVoorAbonnement;
    /**
     * The regelingType
     * Meta informations extracted from the WSDL
     * - documentation: [0,1,2,3,4,5,6,7] Soort regeling. 0 = Verhuizing, 1 = Onderbreking + verlengen, 2 = Goed doel, 3 = Vakantie bonnen, 4 = Vakantieadres, 5 = Doorsturen naar vriend of familie, 6 = Onderbreken zonder verlenging/zonder restitutie, 7 =
     * Restitutieregeling.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 1
     * @var int
     */
    public $regelingType;
    /**
     * The abonnementSoortCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de abonnementsoort van het abonnement.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $abonnementSoortCode;
    /**
     * The abonnementSoortNaam
     * Meta informations extracted from the WSDL
     * - documentation: Omschrijving van de abonnementsoort van het abonnement.
     * - base: xsd:string
     * - maxLength: 500
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $abonnementSoortNaam;
    /**
     * The artikelGroepCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van de artikelgroep van het abonnement (N.B. => Oude product).
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $artikelGroepCode;
    /**
     * The artikelGroepNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam van de artikelgroep van het abonnement (N.B. => Oude product).
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $artikelGroepNaam;
    /**
     * The pakketCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van het pakket van het abonnement.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $pakketCode;
    /**
     * The pakketNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam van het pakket van het abonnement.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $pakketNaam;
    /**
     * The pakketVrijeCode1
     * Meta informations extracted from the WSDL
     * - documentation: De code van de vrije code 1 van het pakket
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $pakketVrijeCode1;
    /**
     * The pakketVrijeNaam1
     * Meta informations extracted from the WSDL
     * - documentation: De naam van de vrije code 1 van het pakket
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $pakketVrijeNaam1;
    /**
     * The persoonsObjectOntvanger
     * Meta informations extracted from the WSDL
     * - documentation: Persoonsgegevens van de relatie die de tijdelijke ontvanger is bij vakantieRegelingType 5 (doorsturen).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \WebApiV4\StructType\PersoonsObjectV4
     */
    public $persoonsObjectOntvanger;
    /**
     * The adresObjectVakantie
     * Meta informations extracted from the WSDL
     * - documentation: Adresgegevens van het tijdelijke adres, of het adres van de tijdelijke ontvanger bij vakantieRegelingType 4 (vakantieadres) en 5 (doorsturen).
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \WebApiV4\StructType\AdresObjectV4
     */
    public $adresObjectVakantie;
    /**
     * The tijdelijkAdres
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of de adres wijziging tijdelijk is.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $tijdelijkAdres;
    /**
     * The adresObjectBezoek
     * Meta informations extracted from the WSDL
     * - documentation: Adresgegevens van het nieuwe bezoek adres i.g.v. verhuizing.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \WebApiV4\StructType\AdresObjectV4
     */
    public $adresObjectBezoek;
    /**
     * The adresObjectCorrespondentie
     * Meta informations extracted from the WSDL
     * - documentation: Adresgegevens van het nieuwe correspondentie adres i.g.v. verhuizing.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \WebApiV4\StructType\AdresObjectV4
     */
    public $adresObjectCorrespondentie;
    /**
     * The adresObjectPrive
     * Meta informations extracted from the WSDL
     * - documentation: Adresgegevens van het nieuwe prive adres i.g.v. verhuizing.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \WebApiV4\StructType\AdresObjectV4
     */
    public $adresObjectPrive;
    /**
     * The canDelete
     * Meta informations extracted from the WSDL
     * - documentation: Geeft aan of een toekomstige mutatie eventueel verwijderd mag worden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canDelete;
    /**
     * Constructor method for ToekMutV4
     * @uses ToekMutV4::setToekMutNo()
     * @uses ToekMutV4::setRelNo()
     * @uses ToekMutV4::setDatumVan()
     * @uses ToekMutV4::setDatumTm()
     * @uses ToekMutV4::setSpecifiekVoorAbonnement()
     * @uses ToekMutV4::setRegelingType()
     * @uses ToekMutV4::setAbonnementSoortCode()
     * @uses ToekMutV4::setAbonnementSoortNaam()
     * @uses ToekMutV4::setArtikelGroepCode()
     * @uses ToekMutV4::setArtikelGroepNaam()
     * @uses ToekMutV4::setPakketCode()
     * @uses ToekMutV4::setPakketNaam()
     * @uses ToekMutV4::setPakketVrijeCode1()
     * @uses ToekMutV4::setPakketVrijeNaam1()
     * @uses ToekMutV4::setPersoonsObjectOntvanger()
     * @uses ToekMutV4::setAdresObjectVakantie()
     * @uses ToekMutV4::setTijdelijkAdres()
     * @uses ToekMutV4::setAdresObjectBezoek()
     * @uses ToekMutV4::setAdresObjectCorrespondentie()
     * @uses ToekMutV4::setAdresObjectPrive()
     * @uses ToekMutV4::setCanDelete()
     * @param int $toekMutNo
     * @param int $relNo
     * @param string $datumVan
     * @param string $datumTm
     * @param bool $specifiekVoorAbonnement
     * @param int $regelingType
     * @param string $abonnementSoortCode
     * @param string $abonnementSoortNaam
     * @param string $artikelGroepCode
     * @param string $artikelGroepNaam
     * @param string $pakketCode
     * @param string $pakketNaam
     * @param string $pakketVrijeCode1
     * @param string $pakketVrijeNaam1
     * @param \WebApiV4\StructType\PersoonsObjectV4 $persoonsObjectOntvanger
     * @param \WebApiV4\StructType\AdresObjectV4 $adresObjectVakantie
     * @param bool $tijdelijkAdres
     * @param \WebApiV4\StructType\AdresObjectV4 $adresObjectBezoek
     * @param \WebApiV4\StructType\AdresObjectV4 $adresObjectCorrespondentie
     * @param \WebApiV4\StructType\AdresObjectV4 $adresObjectPrive
     * @param bool $canDelete
     */
    public function __construct($toekMutNo = null, $relNo = null, $datumVan = null, $datumTm = null, $specifiekVoorAbonnement = null, $regelingType = null, $abonnementSoortCode = null, $abonnementSoortNaam = null, $artikelGroepCode = null, $artikelGroepNaam = null, $pakketCode = null, $pakketNaam = null, $pakketVrijeCode1 = null, $pakketVrijeNaam1 = null, \WebApiV4\StructType\PersoonsObjectV4 $persoonsObjectOntvanger = null, \WebApiV4\StructType\AdresObjectV4 $adresObjectVakantie = null, $tijdelijkAdres = null, \WebApiV4\StructType\AdresObjectV4 $adresObjectBezoek = null, \WebApiV4\StructType\AdresObjectV4 $adresObjectCorrespondentie = null, \WebApiV4\StructType\AdresObjectV4 $adresObjectPrive = null, $canDelete = null)
    {
        $this
            ->setToekMutNo($toekMutNo)
            ->setRelNo($relNo)
            ->setDatumVan($datumVan)
            ->setDatumTm($datumTm)
            ->setSpecifiekVoorAbonnement($specifiekVoorAbonnement)
            ->setRegelingType($regelingType)
            ->setAbonnementSoortCode($abonnementSoortCode)
            ->setAbonnementSoortNaam($abonnementSoortNaam)
            ->setArtikelGroepCode($artikelGroepCode)
            ->setArtikelGroepNaam($artikelGroepNaam)
            ->setPakketCode($pakketCode)
            ->setPakketNaam($pakketNaam)
            ->setPakketVrijeCode1($pakketVrijeCode1)
            ->setPakketVrijeNaam1($pakketVrijeNaam1)
            ->setPersoonsObjectOntvanger($persoonsObjectOntvanger)
            ->setAdresObjectVakantie($adresObjectVakantie)
            ->setTijdelijkAdres($tijdelijkAdres)
            ->setAdresObjectBezoek($adresObjectBezoek)
            ->setAdresObjectCorrespondentie($adresObjectCorrespondentie)
            ->setAdresObjectPrive($adresObjectPrive)
            ->setCanDelete($canDelete);
    }
    /**
     * Get toekMutNo value
     * @return int
     */
    public function getToekMutNo()
    {
        return $this->toekMutNo;
    }
    /**
     * Set toekMutNo value
     * @param int $toekMutNo
     * @return \WebApiV4\StructType\ToekMutV4
     */
    public function setToekMutNo($toekMutNo = null)
    {
        // validation for constraint: int
        if (!is_null($toekMutNo) && !(is_int($toekMutNo) || ctype_digit($toekMutNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($toekMutNo, true), gettype($toekMutNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($toekMutNo) && mb_strlen(preg_replace('/(\D)/', '', $toekMutNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($toekMutNo, true), mb_strlen(preg_replace('/(\D)/', '', $toekMutNo))), __LINE__);
        }
        $this->toekMutNo = $toekMutNo;
        return $this;
    }
    /**
     * Get relNo value
     * @return int
     */
    public function getRelNo()
    {
        return $this->relNo;
    }
    /**
     * Set relNo value
     * @param int $relNo
     * @return \WebApiV4\StructType\ToekMutV4
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: int
        if (!is_null($relNo) && !(is_int($relNo) || ctype_digit($relNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNo, true), gettype($relNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNo) && mb_strlen(preg_replace('/(\D)/', '', $relNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNo, true), mb_strlen(preg_replace('/(\D)/', '', $relNo))), __LINE__);
        }
        $this->relNo = $relNo;
        return $this;
    }
    /**
     * Get datumVan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumVan()
    {
        return isset($this->datumVan) ? $this->datumVan : null;
    }
    /**
     * Set datumVan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumVan
     * @return \WebApiV4\StructType\ToekMutV4
     */
    public function setDatumVan($datumVan = null)
    {
        // validation for constraint: string
        if (!is_null($datumVan) && !is_string($datumVan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumVan, true), gettype($datumVan)), __LINE__);
        }
        if (is_null($datumVan) || (is_array($datumVan) && empty($datumVan))) {
            unset($this->datumVan);
        } else {
            $this->datumVan = $datumVan;
        }
        return $this;
    }
    /**
     * Get datumTm value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDatumTm()
    {
        return isset($this->datumTm) ? $this->datumTm : null;
    }
    /**
     * Set datumTm value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $datumTm
     * @return \WebApiV4\StructType\ToekMutV4
     */
    public function setDatumTm($datumTm = null)
    {
        // validation for constraint: string
        if (!is_null($datumTm) && !is_string($datumTm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumTm, true), gettype($datumTm)), __LINE__);
        }
        if (is_null($datumTm) || (is_array($datumTm) && empty($datumTm))) {
            unset($this->datumTm);
        } else {
            $this->datumTm = $datumTm;
        }
        return $this;
    }
    /**
     * Get specifiekVoorAbonnement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSpecifiekVoorAbonnement()
    {
        return isset($this->specifiekVoorAbonnement) ? $this->specifiekVoorAbonnement : null;
    }
    /**
     * Set specifiekVoorAbonnement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $specifiekVoorAbonnement
     * @return \WebApiV4\StructType\ToekMutV4
     */
    public function setSpecifiekVoorAbonnement($specifiekVoorAbonnement = null)
    {
        // validation for constraint: boolean
        if (!is_null($specifiekVoorAbonnement) && !is_bool($specifiekVoorAbonnement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($specifiekVoorAbonnement, true), gettype($specifiekVoorAbonnement)), __LINE__);
        }
        if (is_null($specifiekVoorAbonnement) || (is_array($specifiekVoorAbonnement) && empty($specifiekVoorAbonnement))) {
            unset($this->specifiekVoorAbonnement);
        } else {
            $this->specifiekVoorAbonnement = $specifiekVoorAbonnement;
        }
        return $this;
    }
    /**
     * Get regelingType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRegelingType()
    {
        return isset($this->regelingType) ? $this->regelingType : null;
    }
    /**
     * Set regelingType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $regelingType
     * @return \WebApiV4\StructType\ToekMutV4
     */
    public function setRegelingType($regelingType = null)
    {
        // validation for constraint: int
        if (!is_null($regelingType) && !(is_int($regelingType) || ctype_digit($regelingType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($regelingType, true), gettype($regelingType)), __LINE__);
        }
        // validation for constraint: totalDigits(1)
        if (!is_null($regelingType) && mb_strlen(preg_replace('/(\D)/', '', $regelingType)) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 1 digits, "%d" given', var_export($regelingType, true), mb_strlen(preg_replace('/(\D)/', '', $regelingType))), __LINE__);
        }
        if (is_null($regelingType) || (is_array($regelingType) && empty($regelingType))) {
            unset($this->regelingType);
        } else {
            $this->regelingType = $regelingType;
        }
        return $this;
    }
    /**
     * Get abonnementSoortCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAbonnementSoortCode()
    {
        return isset($this->abonnementSoortCode) ? $this->abonnementSoortCode : null;
    }
    /**
     * Set abonnementSoortCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $abonnementSoortCode
     * @return \WebApiV4\StructType\ToekMutV4
     */
    public function setAbonnementSoortCode($abonnementSoortCode = null)
    {
        // validation for constraint: string
        if (!is_null($abonnementSoortCode) && !is_string($abonnementSoortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abonnementSoortCode, true), gettype($abonnementSoortCode)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($abonnementSoortCode) && mb_strlen($abonnementSoortCode) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($abonnementSoortCode)), __LINE__);
        }
        if (is_null($abonnementSoortCode) || (is_array($abonnementSoortCode) && empty($abonnementSoortCode))) {
            unset($this->abonnementSoortCode);
        } else {
            $this->abonnementSoortCode = $abonnementSoortCode;
        }
        return $this;
    }
    /**
     * Get abonnementSoortNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAbonnementSoortNaam()
    {
        return isset($this->abonnementSoortNaam) ? $this->abonnementSoortNaam : null;
    }
    /**
     * Set abonnementSoortNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $abonnementSoortNaam
     * @return \WebApiV4\StructType\ToekMutV4
     */
    public function setAbonnementSoortNaam($abonnementSoortNaam = null)
    {
        // validation for constraint: string
        if (!is_null($abonnementSoortNaam) && !is_string($abonnementSoortNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abonnementSoortNaam, true), gettype($abonnementSoortNaam)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($abonnementSoortNaam) && mb_strlen($abonnementSoortNaam) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($abonnementSoortNaam)), __LINE__);
        }
        if (is_null($abonnementSoortNaam) || (is_array($abonnementSoortNaam) && empty($abonnementSoortNaam))) {
            unset($this->abonnementSoortNaam);
        } else {
            $this->abonnementSoortNaam = $abonnementSoortNaam;
        }
        return $this;
    }
    /**
     * Get artikelGroepCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtikelGroepCode()
    {
        return isset($this->artikelGroepCode) ? $this->artikelGroepCode : null;
    }
    /**
     * Set artikelGroepCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artikelGroepCode
     * @return \WebApiV4\StructType\ToekMutV4
     */
    public function setArtikelGroepCode($artikelGroepCode = null)
    {
        // validation for constraint: string
        if (!is_null($artikelGroepCode) && !is_string($artikelGroepCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($artikelGroepCode, true), gettype($artikelGroepCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($artikelGroepCode) && mb_strlen($artikelGroepCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($artikelGroepCode)), __LINE__);
        }
        if (is_null($artikelGroepCode) || (is_array($artikelGroepCode) && empty($artikelGroepCode))) {
            unset($this->artikelGroepCode);
        } else {
            $this->artikelGroepCode = $artikelGroepCode;
        }
        return $this;
    }
    /**
     * Get artikelGroepNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtikelGroepNaam()
    {
        return isset($this->artikelGroepNaam) ? $this->artikelGroepNaam : null;
    }
    /**
     * Set artikelGroepNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artikelGroepNaam
     * @return \WebApiV4\StructType\ToekMutV4
     */
    public function setArtikelGroepNaam($artikelGroepNaam = null)
    {
        // validation for constraint: string
        if (!is_null($artikelGroepNaam) && !is_string($artikelGroepNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($artikelGroepNaam, true), gettype($artikelGroepNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($artikelGroepNaam) && mb_strlen($artikelGroepNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($artikelGroepNaam)), __LINE__);
        }
        if (is_null($artikelGroepNaam) || (is_array($artikelGroepNaam) && empty($artikelGroepNaam))) {
            unset($this->artikelGroepNaam);
        } else {
            $this->artikelGroepNaam = $artikelGroepNaam;
        }
        return $this;
    }
    /**
     * Get pakketCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPakketCode()
    {
        return isset($this->pakketCode) ? $this->pakketCode : null;
    }
    /**
     * Set pakketCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pakketCode
     * @return \WebApiV4\StructType\ToekMutV4
     */
    public function setPakketCode($pakketCode = null)
    {
        // validation for constraint: string
        if (!is_null($pakketCode) && !is_string($pakketCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pakketCode, true), gettype($pakketCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($pakketCode) && mb_strlen($pakketCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($pakketCode)), __LINE__);
        }
        if (is_null($pakketCode) || (is_array($pakketCode) && empty($pakketCode))) {
            unset($this->pakketCode);
        } else {
            $this->pakketCode = $pakketCode;
        }
        return $this;
    }
    /**
     * Get pakketNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPakketNaam()
    {
        return isset($this->pakketNaam) ? $this->pakketNaam : null;
    }
    /**
     * Set pakketNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pakketNaam
     * @return \WebApiV4\StructType\ToekMutV4
     */
    public function setPakketNaam($pakketNaam = null)
    {
        // validation for constraint: string
        if (!is_null($pakketNaam) && !is_string($pakketNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pakketNaam, true), gettype($pakketNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($pakketNaam) && mb_strlen($pakketNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($pakketNaam)), __LINE__);
        }
        if (is_null($pakketNaam) || (is_array($pakketNaam) && empty($pakketNaam))) {
            unset($this->pakketNaam);
        } else {
            $this->pakketNaam = $pakketNaam;
        }
        return $this;
    }
    /**
     * Get pakketVrijeCode1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPakketVrijeCode1()
    {
        return isset($this->pakketVrijeCode1) ? $this->pakketVrijeCode1 : null;
    }
    /**
     * Set pakketVrijeCode1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pakketVrijeCode1
     * @return \WebApiV4\StructType\ToekMutV4
     */
    public function setPakketVrijeCode1($pakketVrijeCode1 = null)
    {
        // validation for constraint: string
        if (!is_null($pakketVrijeCode1) && !is_string($pakketVrijeCode1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pakketVrijeCode1, true), gettype($pakketVrijeCode1)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($pakketVrijeCode1) && mb_strlen($pakketVrijeCode1) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($pakketVrijeCode1)), __LINE__);
        }
        if (is_null($pakketVrijeCode1) || (is_array($pakketVrijeCode1) && empty($pakketVrijeCode1))) {
            unset($this->pakketVrijeCode1);
        } else {
            $this->pakketVrijeCode1 = $pakketVrijeCode1;
        }
        return $this;
    }
    /**
     * Get pakketVrijeNaam1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPakketVrijeNaam1()
    {
        return isset($this->pakketVrijeNaam1) ? $this->pakketVrijeNaam1 : null;
    }
    /**
     * Set pakketVrijeNaam1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pakketVrijeNaam1
     * @return \WebApiV4\StructType\ToekMutV4
     */
    public function setPakketVrijeNaam1($pakketVrijeNaam1 = null)
    {
        // validation for constraint: string
        if (!is_null($pakketVrijeNaam1) && !is_string($pakketVrijeNaam1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pakketVrijeNaam1, true), gettype($pakketVrijeNaam1)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($pakketVrijeNaam1) && mb_strlen($pakketVrijeNaam1) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($pakketVrijeNaam1)), __LINE__);
        }
        if (is_null($pakketVrijeNaam1) || (is_array($pakketVrijeNaam1) && empty($pakketVrijeNaam1))) {
            unset($this->pakketVrijeNaam1);
        } else {
            $this->pakketVrijeNaam1 = $pakketVrijeNaam1;
        }
        return $this;
    }
    /**
     * Get persoonsObjectOntvanger value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \WebApiV4\StructType\PersoonsObjectV4|null
     */
    public function getPersoonsObjectOntvanger()
    {
        return isset($this->persoonsObjectOntvanger) ? $this->persoonsObjectOntvanger : null;
    }
    /**
     * Set persoonsObjectOntvanger value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \WebApiV4\StructType\PersoonsObjectV4 $persoonsObjectOntvanger
     * @return \WebApiV4\StructType\ToekMutV4
     */
    public function setPersoonsObjectOntvanger(\WebApiV4\StructType\PersoonsObjectV4 $persoonsObjectOntvanger = null)
    {
        if (is_null($persoonsObjectOntvanger) || (is_array($persoonsObjectOntvanger) && empty($persoonsObjectOntvanger))) {
            unset($this->persoonsObjectOntvanger);
        } else {
            $this->persoonsObjectOntvanger = $persoonsObjectOntvanger;
        }
        return $this;
    }
    /**
     * Get adresObjectVakantie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \WebApiV4\StructType\AdresObjectV4|null
     */
    public function getAdresObjectVakantie()
    {
        return isset($this->adresObjectVakantie) ? $this->adresObjectVakantie : null;
    }
    /**
     * Set adresObjectVakantie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \WebApiV4\StructType\AdresObjectV4 $adresObjectVakantie
     * @return \WebApiV4\StructType\ToekMutV4
     */
    public function setAdresObjectVakantie(\WebApiV4\StructType\AdresObjectV4 $adresObjectVakantie = null)
    {
        if (is_null($adresObjectVakantie) || (is_array($adresObjectVakantie) && empty($adresObjectVakantie))) {
            unset($this->adresObjectVakantie);
        } else {
            $this->adresObjectVakantie = $adresObjectVakantie;
        }
        return $this;
    }
    /**
     * Get tijdelijkAdres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getTijdelijkAdres()
    {
        return isset($this->tijdelijkAdres) ? $this->tijdelijkAdres : null;
    }
    /**
     * Set tijdelijkAdres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $tijdelijkAdres
     * @return \WebApiV4\StructType\ToekMutV4
     */
    public function setTijdelijkAdres($tijdelijkAdres = null)
    {
        // validation for constraint: boolean
        if (!is_null($tijdelijkAdres) && !is_bool($tijdelijkAdres)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tijdelijkAdres, true), gettype($tijdelijkAdres)), __LINE__);
        }
        if (is_null($tijdelijkAdres) || (is_array($tijdelijkAdres) && empty($tijdelijkAdres))) {
            unset($this->tijdelijkAdres);
        } else {
            $this->tijdelijkAdres = $tijdelijkAdres;
        }
        return $this;
    }
    /**
     * Get adresObjectBezoek value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \WebApiV4\StructType\AdresObjectV4|null
     */
    public function getAdresObjectBezoek()
    {
        return isset($this->adresObjectBezoek) ? $this->adresObjectBezoek : null;
    }
    /**
     * Set adresObjectBezoek value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \WebApiV4\StructType\AdresObjectV4 $adresObjectBezoek
     * @return \WebApiV4\StructType\ToekMutV4
     */
    public function setAdresObjectBezoek(\WebApiV4\StructType\AdresObjectV4 $adresObjectBezoek = null)
    {
        if (is_null($adresObjectBezoek) || (is_array($adresObjectBezoek) && empty($adresObjectBezoek))) {
            unset($this->adresObjectBezoek);
        } else {
            $this->adresObjectBezoek = $adresObjectBezoek;
        }
        return $this;
    }
    /**
     * Get adresObjectCorrespondentie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \WebApiV4\StructType\AdresObjectV4|null
     */
    public function getAdresObjectCorrespondentie()
    {
        return isset($this->adresObjectCorrespondentie) ? $this->adresObjectCorrespondentie : null;
    }
    /**
     * Set adresObjectCorrespondentie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \WebApiV4\StructType\AdresObjectV4 $adresObjectCorrespondentie
     * @return \WebApiV4\StructType\ToekMutV4
     */
    public function setAdresObjectCorrespondentie(\WebApiV4\StructType\AdresObjectV4 $adresObjectCorrespondentie = null)
    {
        if (is_null($adresObjectCorrespondentie) || (is_array($adresObjectCorrespondentie) && empty($adresObjectCorrespondentie))) {
            unset($this->adresObjectCorrespondentie);
        } else {
            $this->adresObjectCorrespondentie = $adresObjectCorrespondentie;
        }
        return $this;
    }
    /**
     * Get adresObjectPrive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \WebApiV4\StructType\AdresObjectV4|null
     */
    public function getAdresObjectPrive()
    {
        return isset($this->adresObjectPrive) ? $this->adresObjectPrive : null;
    }
    /**
     * Set adresObjectPrive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \WebApiV4\StructType\AdresObjectV4 $adresObjectPrive
     * @return \WebApiV4\StructType\ToekMutV4
     */
    public function setAdresObjectPrive(\WebApiV4\StructType\AdresObjectV4 $adresObjectPrive = null)
    {
        if (is_null($adresObjectPrive) || (is_array($adresObjectPrive) && empty($adresObjectPrive))) {
            unset($this->adresObjectPrive);
        } else {
            $this->adresObjectPrive = $adresObjectPrive;
        }
        return $this;
    }
    /**
     * Get canDelete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanDelete()
    {
        return isset($this->canDelete) ? $this->canDelete : null;
    }
    /**
     * Set canDelete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canDelete
     * @return \WebApiV4\StructType\ToekMutV4
     */
    public function setCanDelete($canDelete = null)
    {
        // validation for constraint: boolean
        if (!is_null($canDelete) && !is_bool($canDelete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canDelete, true), gettype($canDelete)), __LINE__);
        }
        if (is_null($canDelete) || (is_array($canDelete) && empty($canDelete))) {
            unset($this->canDelete);
        } else {
            $this->canDelete = $canDelete;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\ToekMutV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
