<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for searchAbonnementByCredRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Geeft een lijst met abonnementen op die gelden voor de opgegeven userName en password combinatie.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class SearchAbonnementByCredRequest extends AbstractStructBase
{
    /**
     * The userName
     * Meta informations extracted from the WSDL
     * - documentation: Gebruikersnaam.
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $userName;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - documentation: Wachtwoord.
     * - base: xsd:string
     * - maxLength: 100
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $password;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The toonAbonnementen
     * Meta informations extracted from the WSDL
     * - documentation: [0,1,2] Welk type abonnementen moet worden getoond 0=Alleen gewone (default) 1=Alleen licentie 2=Alle abonnementen.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $toonAbonnementen;
    /**
     * Constructor method for searchAbonnementByCredRequest
     * @uses SearchAbonnementByCredRequest::setUserName()
     * @uses SearchAbonnementByCredRequest::setPassword()
     * @uses SearchAbonnementByCredRequest::setRequestTag()
     * @uses SearchAbonnementByCredRequest::setToonAbonnementen()
     * @param string $userName
     * @param string $password
     * @param string $requestTag
     * @param float $toonAbonnementen
     */
    public function __construct($userName = null, $password = null, $requestTag = null, $toonAbonnementen = null)
    {
        $this
            ->setUserName($userName)
            ->setPassword($password)
            ->setRequestTag($requestTag)
            ->setToonAbonnementen($toonAbonnementen);
    }
    /**
     * Get userName value
     * @return string
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \WebApiV4\StructType\SearchAbonnementByCredRequest
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($userName) && mb_strlen($userName) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($userName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($userName) && mb_strlen($userName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get password value
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \WebApiV4\StructType\SearchAbonnementByCredRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($password) && mb_strlen($password) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($password)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($password) && mb_strlen($password) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \WebApiV4\StructType\SearchAbonnementByCredRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get toonAbonnementen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getToonAbonnementen()
    {
        return isset($this->toonAbonnementen) ? $this->toonAbonnementen : null;
    }
    /**
     * Set toonAbonnementen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $toonAbonnementen
     * @return \WebApiV4\StructType\SearchAbonnementByCredRequest
     */
    public function setToonAbonnementen($toonAbonnementen = null)
    {
        // validation for constraint: float
        if (!is_null($toonAbonnementen) && !(is_float($toonAbonnementen) || is_numeric($toonAbonnementen))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($toonAbonnementen, true), gettype($toonAbonnementen)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($toonAbonnementen) && mb_strlen(preg_replace('/(\D)/', '', $toonAbonnementen)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($toonAbonnementen, true), mb_strlen(preg_replace('/(\D)/', '', $toonAbonnementen))), __LINE__);
        }
        if (is_null($toonAbonnementen) || (is_array($toonAbonnementen) && empty($toonAbonnementen))) {
            unset($this->toonAbonnementen);
        } else {
            $this->toonAbonnementen = $toonAbonnementen;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\SearchAbonnementByCredRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
