<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelatieNummerObjectV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met relatie nummers.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class RelatieNummerObjectV4 extends AbstractStructBase
{
    /**
     * The number
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met relatie nummers.
     * - base: xsd:integer
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * - totalDigits: 15
     * @var int[]
     */
    public $number;
    /**
     * Constructor method for RelatieNummerObjectV4
     * @uses RelatieNummerObjectV4::setNumber()
     * @param int[] $number
     */
    public function __construct(array $number = array())
    {
        $this
            ->setNumber($number);
    }
    /**
     * Get number value
     * @return int[]|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * This method is responsible for validating the values passed to the setNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNumberForArrayConstraintsFromSetNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $relatieNummerObjectV4NumberItem) {
            // validation for constraint: itemType
            if (!(is_int($relatieNummerObjectV4NumberItem) || ctype_digit($relatieNummerObjectV4NumberItem))) {
                $invalidValues[] = is_object($relatieNummerObjectV4NumberItem) ? get_class($relatieNummerObjectV4NumberItem) : sprintf('%s(%s)', gettype($relatieNummerObjectV4NumberItem), var_export($relatieNummerObjectV4NumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The number property can only contain items of type integer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set number value
     * @throws \InvalidArgumentException
     * @param int[] $number
     * @return \WebApiV4\StructType\RelatieNummerObjectV4
     */
    public function setNumber(array $number = array())
    {
        // validation for constraint: array
        if ('' !== ($numberArrayErrorMessage = self::validateNumberForArrayConstraintsFromSetNumber($number))) {
            throw new \InvalidArgumentException($numberArrayErrorMessage, __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($number) && mb_strlen(preg_replace('/(\D)/', '', $number)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($number, true), mb_strlen(preg_replace('/(\D)/', '', $number))), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Add item to number value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \WebApiV4\StructType\RelatieNummerObjectV4
     */
    public function addToNumber($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The number property can only contain items of type integer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (mb_strlen(preg_replace('/(\D)/', '', $item)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($item, true), mb_strlen(preg_replace('/(\D)/', '', $item))), __LINE__);
        }
        $this->number[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\RelatieNummerObjectV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
