<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropositiesV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Proposities object.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class PropositiesV4 extends AbstractStructBase
{
    /**
     * The actieNummer
     * Meta informations extracted from the WSDL
     * - documentation: Het unieke nummer van de actie.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $actieNummer;
    /**
     * The actieCode
     * Meta informations extracted from the WSDL
     * - documentation: De code van de actie.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $actieCode;
    /**
     * The actieNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam/omschrijving van de actie.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $actieNaam;
    /**
     * The propositieNummer
     * Meta informations extracted from the WSDL
     * - documentation: Het unieke nummer van de propositie.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $propositieNummer;
    /**
     * The propositieCode
     * Meta informations extracted from the WSDL
     * - documentation: De code van de propositie.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $propositieCode;
    /**
     * The propositieNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam/omschrijving van de propositie.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $propositieNaam;
    /**
     * The uitgaveNummer
     * Meta informations extracted from the WSDL
     * - documentation: Het unieke nummer van de uitgave.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $uitgaveNummer;
    /**
     * The uitgaveCode
     * Meta informations extracted from the WSDL
     * - documentation: De code van de uitgave.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $uitgaveCode;
    /**
     * The uitgaveNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam/omschrivjing van de propositie.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $uitgaveNaam;
    /**
     * The abonnementsoortNummer
     * Meta informations extracted from the WSDL
     * - documentation: Het unieke nummer van de abonnementsoort. Alleen gevuld indien de propositie voor een abosoort geldt.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $abonnementsoortNummer;
    /**
     * The abonnementsoortCode
     * Meta informations extracted from the WSDL
     * - documentation: De code van de abonnementsoort. Alleen gevuld indien de propositie voor een abosoort geldt.
     * - base: xsd:string
     * - maxLength: 30
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $abonnementsoortCode;
    /**
     * The abonnementsoortNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam/omschrijving van de abonnementsoort. Alleen gevuld indien de propositie voor een abosoort geldt.
     * - base: xsd:string
     * - maxLength: 500
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $abonnementsoortNaam;
    /**
     * The betaalwijze
     * Meta informations extracted from the WSDL
     * - documentation: Betaalwijze van de abonnementsoort. (0= Geen voorkeur, 1= Bij voorkeur aut. incasso, 2= Verplicht aut. incasso)
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $betaalwijze;
    /**
     * The abonnementsoortPrijsExclBtw
     * Meta informations extracted from the WSDL
     * - documentation: (Basis-) prijs voor de abonnementsoort excl. BTW. Alleen gevuld indien de propositie voor een abosoort geldt.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $abonnementsoortPrijsExclBtw;
    /**
     * The abonnementsoortPrijsInclBtw
     * Meta informations extracted from the WSDL
     * - documentation: (Basis-) prijs voor de abonnementsoort incl. BTW. Alleen gevuld indien de propositie voor een abosoort geldt.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $abonnementsoortPrijsInclBtw;
    /**
     * The pakketNummer
     * Meta informations extracted from the WSDL
     * - documentation: Het unieke nummer van het pakket. Alleen gevuld indien de propositie voor een pakket geldt.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 15
     * @var int
     */
    public $pakketNummer;
    /**
     * The pakketCode
     * Meta informations extracted from the WSDL
     * - documentation: De code van het pakket. Alleen gevuld indien de propositie voor een pakket geldt.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $pakketCode;
    /**
     * The pakketNaam
     * Meta informations extracted from the WSDL
     * - documentation: Naam/omschrijving van het pakket. Alleen gevuld indien de propositie voor een pakket geldt.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $pakketNaam;
    /**
     * The pakketPrijsExclBtw
     * Meta informations extracted from the WSDL
     * - documentation: (Basis-) prijs van het pakket excl. BTW. Alleen gevuld indien de propositie voor een pakket geldt.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $pakketPrijsExclBtw;
    /**
     * The pakketPrijsInclBtw
     * Meta informations extracted from the WSDL
     * - documentation: (Basis-) prijs van het pakket incl. BTW. Alleen gevuld indien de propositie voor een pakket geldt.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $pakketPrijsInclBtw;
    /**
     * The propositiePremiums
     * Meta informations extracted from the WSDL
     * - documentation: Een lijst met de gevonden premiums bij de propositie. Zie PropositiePremiums.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \WebApiV4\StructType\PropositiePremiumsTabV4
     */
    public $propositiePremiums;
    /**
     * The prijsPropositieInclBtw
     * Meta informations extracted from the WSDL
     * - documentation: Propositieprijs Prijs voor de hele propositie gelden voor eerste factuur/contractperiode.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $prijsPropositieInclBtw;
    /**
     * The kortingTekst
     * Meta informations extracted from the WSDL
     * - documentation: Kortingtekst bij de propositieprijs.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $kortingTekst;
    /**
     * The prijs1ePeriodeExcl
     * Meta informations extracted from the WSDL
     * - documentation: Prijs voor de abonnementsoort excl. BTW voor de 1e periode (i.v.m. eventuele korting van de actie).
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 38
     * @var float
     */
    public $prijs1ePeriodeExcl;
    /**
     * The prijs1ePeriodeIncl
     * Meta informations extracted from the WSDL
     * - documentation: Prijs voor de abonnementsoort incl. BTW voor de 1e periode (i.v.m. eventuele korting van de actie).
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - totalDigits: 17
     * @var float
     */
    public $prijs1ePeriodeIncl;
    /**
     * The actieHerkomstcode
     * Meta informations extracted from the WSDL
     * - documentation: Herkomst code die bij de actie is ingesteld.
     * - base: xsd:string
     * - maxLength: 20
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $actieHerkomstcode;
    /**
     * The actieHerkomstnaam
     * Meta informations extracted from the WSDL
     * - documentation: Herkomst omschrijving die bij de actie is ingesteld.
     * - base: xsd:string
     * - maxLength: 120
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $actieHerkomstnaam;
    /**
     * Constructor method for PropositiesV4
     * @uses PropositiesV4::setActieNummer()
     * @uses PropositiesV4::setActieCode()
     * @uses PropositiesV4::setActieNaam()
     * @uses PropositiesV4::setPropositieNummer()
     * @uses PropositiesV4::setPropositieCode()
     * @uses PropositiesV4::setPropositieNaam()
     * @uses PropositiesV4::setUitgaveNummer()
     * @uses PropositiesV4::setUitgaveCode()
     * @uses PropositiesV4::setUitgaveNaam()
     * @uses PropositiesV4::setAbonnementsoortNummer()
     * @uses PropositiesV4::setAbonnementsoortCode()
     * @uses PropositiesV4::setAbonnementsoortNaam()
     * @uses PropositiesV4::setBetaalwijze()
     * @uses PropositiesV4::setAbonnementsoortPrijsExclBtw()
     * @uses PropositiesV4::setAbonnementsoortPrijsInclBtw()
     * @uses PropositiesV4::setPakketNummer()
     * @uses PropositiesV4::setPakketCode()
     * @uses PropositiesV4::setPakketNaam()
     * @uses PropositiesV4::setPakketPrijsExclBtw()
     * @uses PropositiesV4::setPakketPrijsInclBtw()
     * @uses PropositiesV4::setPropositiePremiums()
     * @uses PropositiesV4::setPrijsPropositieInclBtw()
     * @uses PropositiesV4::setKortingTekst()
     * @uses PropositiesV4::setPrijs1ePeriodeExcl()
     * @uses PropositiesV4::setPrijs1ePeriodeIncl()
     * @uses PropositiesV4::setActieHerkomstcode()
     * @uses PropositiesV4::setActieHerkomstnaam()
     * @param int $actieNummer
     * @param string $actieCode
     * @param string $actieNaam
     * @param int $propositieNummer
     * @param string $propositieCode
     * @param string $propositieNaam
     * @param int $uitgaveNummer
     * @param string $uitgaveCode
     * @param string $uitgaveNaam
     * @param int $abonnementsoortNummer
     * @param string $abonnementsoortCode
     * @param string $abonnementsoortNaam
     * @param float $betaalwijze
     * @param float $abonnementsoortPrijsExclBtw
     * @param float $abonnementsoortPrijsInclBtw
     * @param int $pakketNummer
     * @param string $pakketCode
     * @param string $pakketNaam
     * @param float $pakketPrijsExclBtw
     * @param float $pakketPrijsInclBtw
     * @param \WebApiV4\StructType\PropositiePremiumsTabV4 $propositiePremiums
     * @param float $prijsPropositieInclBtw
     * @param string $kortingTekst
     * @param float $prijs1ePeriodeExcl
     * @param float $prijs1ePeriodeIncl
     * @param string $actieHerkomstcode
     * @param string $actieHerkomstnaam
     */
    public function __construct($actieNummer = null, $actieCode = null, $actieNaam = null, $propositieNummer = null, $propositieCode = null, $propositieNaam = null, $uitgaveNummer = null, $uitgaveCode = null, $uitgaveNaam = null, $abonnementsoortNummer = null, $abonnementsoortCode = null, $abonnementsoortNaam = null, $betaalwijze = null, $abonnementsoortPrijsExclBtw = null, $abonnementsoortPrijsInclBtw = null, $pakketNummer = null, $pakketCode = null, $pakketNaam = null, $pakketPrijsExclBtw = null, $pakketPrijsInclBtw = null, \WebApiV4\StructType\PropositiePremiumsTabV4 $propositiePremiums = null, $prijsPropositieInclBtw = null, $kortingTekst = null, $prijs1ePeriodeExcl = null, $prijs1ePeriodeIncl = null, $actieHerkomstcode = null, $actieHerkomstnaam = null)
    {
        $this
            ->setActieNummer($actieNummer)
            ->setActieCode($actieCode)
            ->setActieNaam($actieNaam)
            ->setPropositieNummer($propositieNummer)
            ->setPropositieCode($propositieCode)
            ->setPropositieNaam($propositieNaam)
            ->setUitgaveNummer($uitgaveNummer)
            ->setUitgaveCode($uitgaveCode)
            ->setUitgaveNaam($uitgaveNaam)
            ->setAbonnementsoortNummer($abonnementsoortNummer)
            ->setAbonnementsoortCode($abonnementsoortCode)
            ->setAbonnementsoortNaam($abonnementsoortNaam)
            ->setBetaalwijze($betaalwijze)
            ->setAbonnementsoortPrijsExclBtw($abonnementsoortPrijsExclBtw)
            ->setAbonnementsoortPrijsInclBtw($abonnementsoortPrijsInclBtw)
            ->setPakketNummer($pakketNummer)
            ->setPakketCode($pakketCode)
            ->setPakketNaam($pakketNaam)
            ->setPakketPrijsExclBtw($pakketPrijsExclBtw)
            ->setPakketPrijsInclBtw($pakketPrijsInclBtw)
            ->setPropositiePremiums($propositiePremiums)
            ->setPrijsPropositieInclBtw($prijsPropositieInclBtw)
            ->setKortingTekst($kortingTekst)
            ->setPrijs1ePeriodeExcl($prijs1ePeriodeExcl)
            ->setPrijs1ePeriodeIncl($prijs1ePeriodeIncl)
            ->setActieHerkomstcode($actieHerkomstcode)
            ->setActieHerkomstnaam($actieHerkomstnaam);
    }
    /**
     * Get actieNummer value
     * @return int
     */
    public function getActieNummer()
    {
        return $this->actieNummer;
    }
    /**
     * Set actieNummer value
     * @param int $actieNummer
     * @return \WebApiV4\StructType\PropositiesV4
     */
    public function setActieNummer($actieNummer = null)
    {
        // validation for constraint: int
        if (!is_null($actieNummer) && !(is_int($actieNummer) || ctype_digit($actieNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($actieNummer, true), gettype($actieNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($actieNummer) && mb_strlen(preg_replace('/(\D)/', '', $actieNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($actieNummer, true), mb_strlen(preg_replace('/(\D)/', '', $actieNummer))), __LINE__);
        }
        $this->actieNummer = $actieNummer;
        return $this;
    }
    /**
     * Get actieCode value
     * @return string
     */
    public function getActieCode()
    {
        return $this->actieCode;
    }
    /**
     * Set actieCode value
     * @param string $actieCode
     * @return \WebApiV4\StructType\PropositiesV4
     */
    public function setActieCode($actieCode = null)
    {
        // validation for constraint: string
        if (!is_null($actieCode) && !is_string($actieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actieCode, true), gettype($actieCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($actieCode) && mb_strlen($actieCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($actieCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($actieCode) && mb_strlen($actieCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($actieCode)), __LINE__);
        }
        $this->actieCode = $actieCode;
        return $this;
    }
    /**
     * Get actieNaam value
     * @return string
     */
    public function getActieNaam()
    {
        return $this->actieNaam;
    }
    /**
     * Set actieNaam value
     * @param string $actieNaam
     * @return \WebApiV4\StructType\PropositiesV4
     */
    public function setActieNaam($actieNaam = null)
    {
        // validation for constraint: string
        if (!is_null($actieNaam) && !is_string($actieNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actieNaam, true), gettype($actieNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($actieNaam) && mb_strlen($actieNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($actieNaam)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($actieNaam) && mb_strlen($actieNaam) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($actieNaam)), __LINE__);
        }
        $this->actieNaam = $actieNaam;
        return $this;
    }
    /**
     * Get propositieNummer value
     * @return int
     */
    public function getPropositieNummer()
    {
        return $this->propositieNummer;
    }
    /**
     * Set propositieNummer value
     * @param int $propositieNummer
     * @return \WebApiV4\StructType\PropositiesV4
     */
    public function setPropositieNummer($propositieNummer = null)
    {
        // validation for constraint: int
        if (!is_null($propositieNummer) && !(is_int($propositieNummer) || ctype_digit($propositieNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($propositieNummer, true), gettype($propositieNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($propositieNummer) && mb_strlen(preg_replace('/(\D)/', '', $propositieNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($propositieNummer, true), mb_strlen(preg_replace('/(\D)/', '', $propositieNummer))), __LINE__);
        }
        $this->propositieNummer = $propositieNummer;
        return $this;
    }
    /**
     * Get propositieCode value
     * @return string
     */
    public function getPropositieCode()
    {
        return $this->propositieCode;
    }
    /**
     * Set propositieCode value
     * @param string $propositieCode
     * @return \WebApiV4\StructType\PropositiesV4
     */
    public function setPropositieCode($propositieCode = null)
    {
        // validation for constraint: string
        if (!is_null($propositieCode) && !is_string($propositieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propositieCode, true), gettype($propositieCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($propositieCode) && mb_strlen($propositieCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($propositieCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($propositieCode) && mb_strlen($propositieCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($propositieCode)), __LINE__);
        }
        $this->propositieCode = $propositieCode;
        return $this;
    }
    /**
     * Get propositieNaam value
     * @return string
     */
    public function getPropositieNaam()
    {
        return $this->propositieNaam;
    }
    /**
     * Set propositieNaam value
     * @param string $propositieNaam
     * @return \WebApiV4\StructType\PropositiesV4
     */
    public function setPropositieNaam($propositieNaam = null)
    {
        // validation for constraint: string
        if (!is_null($propositieNaam) && !is_string($propositieNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propositieNaam, true), gettype($propositieNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($propositieNaam) && mb_strlen($propositieNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($propositieNaam)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($propositieNaam) && mb_strlen($propositieNaam) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($propositieNaam)), __LINE__);
        }
        $this->propositieNaam = $propositieNaam;
        return $this;
    }
    /**
     * Get uitgaveNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUitgaveNummer()
    {
        return isset($this->uitgaveNummer) ? $this->uitgaveNummer : null;
    }
    /**
     * Set uitgaveNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $uitgaveNummer
     * @return \WebApiV4\StructType\PropositiesV4
     */
    public function setUitgaveNummer($uitgaveNummer = null)
    {
        // validation for constraint: int
        if (!is_null($uitgaveNummer) && !(is_int($uitgaveNummer) || ctype_digit($uitgaveNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uitgaveNummer, true), gettype($uitgaveNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($uitgaveNummer) && mb_strlen(preg_replace('/(\D)/', '', $uitgaveNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($uitgaveNummer, true), mb_strlen(preg_replace('/(\D)/', '', $uitgaveNummer))), __LINE__);
        }
        if (is_null($uitgaveNummer) || (is_array($uitgaveNummer) && empty($uitgaveNummer))) {
            unset($this->uitgaveNummer);
        } else {
            $this->uitgaveNummer = $uitgaveNummer;
        }
        return $this;
    }
    /**
     * Get uitgaveCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUitgaveCode()
    {
        return isset($this->uitgaveCode) ? $this->uitgaveCode : null;
    }
    /**
     * Set uitgaveCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uitgaveCode
     * @return \WebApiV4\StructType\PropositiesV4
     */
    public function setUitgaveCode($uitgaveCode = null)
    {
        // validation for constraint: string
        if (!is_null($uitgaveCode) && !is_string($uitgaveCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uitgaveCode, true), gettype($uitgaveCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($uitgaveCode) && mb_strlen($uitgaveCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($uitgaveCode)), __LINE__);
        }
        if (is_null($uitgaveCode) || (is_array($uitgaveCode) && empty($uitgaveCode))) {
            unset($this->uitgaveCode);
        } else {
            $this->uitgaveCode = $uitgaveCode;
        }
        return $this;
    }
    /**
     * Get uitgaveNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUitgaveNaam()
    {
        return isset($this->uitgaveNaam) ? $this->uitgaveNaam : null;
    }
    /**
     * Set uitgaveNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uitgaveNaam
     * @return \WebApiV4\StructType\PropositiesV4
     */
    public function setUitgaveNaam($uitgaveNaam = null)
    {
        // validation for constraint: string
        if (!is_null($uitgaveNaam) && !is_string($uitgaveNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uitgaveNaam, true), gettype($uitgaveNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($uitgaveNaam) && mb_strlen($uitgaveNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($uitgaveNaam)), __LINE__);
        }
        if (is_null($uitgaveNaam) || (is_array($uitgaveNaam) && empty($uitgaveNaam))) {
            unset($this->uitgaveNaam);
        } else {
            $this->uitgaveNaam = $uitgaveNaam;
        }
        return $this;
    }
    /**
     * Get abonnementsoortNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAbonnementsoortNummer()
    {
        return isset($this->abonnementsoortNummer) ? $this->abonnementsoortNummer : null;
    }
    /**
     * Set abonnementsoortNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $abonnementsoortNummer
     * @return \WebApiV4\StructType\PropositiesV4
     */
    public function setAbonnementsoortNummer($abonnementsoortNummer = null)
    {
        // validation for constraint: int
        if (!is_null($abonnementsoortNummer) && !(is_int($abonnementsoortNummer) || ctype_digit($abonnementsoortNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($abonnementsoortNummer, true), gettype($abonnementsoortNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($abonnementsoortNummer) && mb_strlen(preg_replace('/(\D)/', '', $abonnementsoortNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($abonnementsoortNummer, true), mb_strlen(preg_replace('/(\D)/', '', $abonnementsoortNummer))), __LINE__);
        }
        if (is_null($abonnementsoortNummer) || (is_array($abonnementsoortNummer) && empty($abonnementsoortNummer))) {
            unset($this->abonnementsoortNummer);
        } else {
            $this->abonnementsoortNummer = $abonnementsoortNummer;
        }
        return $this;
    }
    /**
     * Get abonnementsoortCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAbonnementsoortCode()
    {
        return isset($this->abonnementsoortCode) ? $this->abonnementsoortCode : null;
    }
    /**
     * Set abonnementsoortCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $abonnementsoortCode
     * @return \WebApiV4\StructType\PropositiesV4
     */
    public function setAbonnementsoortCode($abonnementsoortCode = null)
    {
        // validation for constraint: string
        if (!is_null($abonnementsoortCode) && !is_string($abonnementsoortCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abonnementsoortCode, true), gettype($abonnementsoortCode)), __LINE__);
        }
        // validation for constraint: maxLength(30)
        if (!is_null($abonnementsoortCode) && mb_strlen($abonnementsoortCode) > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 30', mb_strlen($abonnementsoortCode)), __LINE__);
        }
        if (is_null($abonnementsoortCode) || (is_array($abonnementsoortCode) && empty($abonnementsoortCode))) {
            unset($this->abonnementsoortCode);
        } else {
            $this->abonnementsoortCode = $abonnementsoortCode;
        }
        return $this;
    }
    /**
     * Get abonnementsoortNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAbonnementsoortNaam()
    {
        return isset($this->abonnementsoortNaam) ? $this->abonnementsoortNaam : null;
    }
    /**
     * Set abonnementsoortNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $abonnementsoortNaam
     * @return \WebApiV4\StructType\PropositiesV4
     */
    public function setAbonnementsoortNaam($abonnementsoortNaam = null)
    {
        // validation for constraint: string
        if (!is_null($abonnementsoortNaam) && !is_string($abonnementsoortNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abonnementsoortNaam, true), gettype($abonnementsoortNaam)), __LINE__);
        }
        // validation for constraint: maxLength(500)
        if (!is_null($abonnementsoortNaam) && mb_strlen($abonnementsoortNaam) > 500) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 500', mb_strlen($abonnementsoortNaam)), __LINE__);
        }
        if (is_null($abonnementsoortNaam) || (is_array($abonnementsoortNaam) && empty($abonnementsoortNaam))) {
            unset($this->abonnementsoortNaam);
        } else {
            $this->abonnementsoortNaam = $abonnementsoortNaam;
        }
        return $this;
    }
    /**
     * Get betaalwijze value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBetaalwijze()
    {
        return isset($this->betaalwijze) ? $this->betaalwijze : null;
    }
    /**
     * Set betaalwijze value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $betaalwijze
     * @return \WebApiV4\StructType\PropositiesV4
     */
    public function setBetaalwijze($betaalwijze = null)
    {
        // validation for constraint: float
        if (!is_null($betaalwijze) && !(is_float($betaalwijze) || is_numeric($betaalwijze))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($betaalwijze, true), gettype($betaalwijze)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($betaalwijze) && mb_strlen(preg_replace('/(\D)/', '', $betaalwijze)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($betaalwijze, true), mb_strlen(preg_replace('/(\D)/', '', $betaalwijze))), __LINE__);
        }
        if (is_null($betaalwijze) || (is_array($betaalwijze) && empty($betaalwijze))) {
            unset($this->betaalwijze);
        } else {
            $this->betaalwijze = $betaalwijze;
        }
        return $this;
    }
    /**
     * Get abonnementsoortPrijsExclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAbonnementsoortPrijsExclBtw()
    {
        return isset($this->abonnementsoortPrijsExclBtw) ? $this->abonnementsoortPrijsExclBtw : null;
    }
    /**
     * Set abonnementsoortPrijsExclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $abonnementsoortPrijsExclBtw
     * @return \WebApiV4\StructType\PropositiesV4
     */
    public function setAbonnementsoortPrijsExclBtw($abonnementsoortPrijsExclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($abonnementsoortPrijsExclBtw) && !(is_float($abonnementsoortPrijsExclBtw) || is_numeric($abonnementsoortPrijsExclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($abonnementsoortPrijsExclBtw, true), gettype($abonnementsoortPrijsExclBtw)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($abonnementsoortPrijsExclBtw) && mb_strlen(mb_substr($abonnementsoortPrijsExclBtw, mb_strpos($abonnementsoortPrijsExclBtw, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($abonnementsoortPrijsExclBtw, true), mb_strlen(mb_substr($abonnementsoortPrijsExclBtw, mb_strpos($abonnementsoortPrijsExclBtw, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($abonnementsoortPrijsExclBtw) && mb_strlen(preg_replace('/(\D)/', '', $abonnementsoortPrijsExclBtw)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($abonnementsoortPrijsExclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $abonnementsoortPrijsExclBtw))), __LINE__);
        }
        if (is_null($abonnementsoortPrijsExclBtw) || (is_array($abonnementsoortPrijsExclBtw) && empty($abonnementsoortPrijsExclBtw))) {
            unset($this->abonnementsoortPrijsExclBtw);
        } else {
            $this->abonnementsoortPrijsExclBtw = $abonnementsoortPrijsExclBtw;
        }
        return $this;
    }
    /**
     * Get abonnementsoortPrijsInclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAbonnementsoortPrijsInclBtw()
    {
        return isset($this->abonnementsoortPrijsInclBtw) ? $this->abonnementsoortPrijsInclBtw : null;
    }
    /**
     * Set abonnementsoortPrijsInclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $abonnementsoortPrijsInclBtw
     * @return \WebApiV4\StructType\PropositiesV4
     */
    public function setAbonnementsoortPrijsInclBtw($abonnementsoortPrijsInclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($abonnementsoortPrijsInclBtw) && !(is_float($abonnementsoortPrijsInclBtw) || is_numeric($abonnementsoortPrijsInclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($abonnementsoortPrijsInclBtw, true), gettype($abonnementsoortPrijsInclBtw)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($abonnementsoortPrijsInclBtw) && mb_strlen(mb_substr($abonnementsoortPrijsInclBtw, mb_strpos($abonnementsoortPrijsInclBtw, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($abonnementsoortPrijsInclBtw, true), mb_strlen(mb_substr($abonnementsoortPrijsInclBtw, mb_strpos($abonnementsoortPrijsInclBtw, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($abonnementsoortPrijsInclBtw) && mb_strlen(preg_replace('/(\D)/', '', $abonnementsoortPrijsInclBtw)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($abonnementsoortPrijsInclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $abonnementsoortPrijsInclBtw))), __LINE__);
        }
        if (is_null($abonnementsoortPrijsInclBtw) || (is_array($abonnementsoortPrijsInclBtw) && empty($abonnementsoortPrijsInclBtw))) {
            unset($this->abonnementsoortPrijsInclBtw);
        } else {
            $this->abonnementsoortPrijsInclBtw = $abonnementsoortPrijsInclBtw;
        }
        return $this;
    }
    /**
     * Get pakketNummer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPakketNummer()
    {
        return isset($this->pakketNummer) ? $this->pakketNummer : null;
    }
    /**
     * Set pakketNummer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pakketNummer
     * @return \WebApiV4\StructType\PropositiesV4
     */
    public function setPakketNummer($pakketNummer = null)
    {
        // validation for constraint: int
        if (!is_null($pakketNummer) && !(is_int($pakketNummer) || ctype_digit($pakketNummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pakketNummer, true), gettype($pakketNummer)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($pakketNummer) && mb_strlen(preg_replace('/(\D)/', '', $pakketNummer)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($pakketNummer, true), mb_strlen(preg_replace('/(\D)/', '', $pakketNummer))), __LINE__);
        }
        if (is_null($pakketNummer) || (is_array($pakketNummer) && empty($pakketNummer))) {
            unset($this->pakketNummer);
        } else {
            $this->pakketNummer = $pakketNummer;
        }
        return $this;
    }
    /**
     * Get pakketCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPakketCode()
    {
        return isset($this->pakketCode) ? $this->pakketCode : null;
    }
    /**
     * Set pakketCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pakketCode
     * @return \WebApiV4\StructType\PropositiesV4
     */
    public function setPakketCode($pakketCode = null)
    {
        // validation for constraint: string
        if (!is_null($pakketCode) && !is_string($pakketCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pakketCode, true), gettype($pakketCode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($pakketCode) && mb_strlen($pakketCode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($pakketCode)), __LINE__);
        }
        if (is_null($pakketCode) || (is_array($pakketCode) && empty($pakketCode))) {
            unset($this->pakketCode);
        } else {
            $this->pakketCode = $pakketCode;
        }
        return $this;
    }
    /**
     * Get pakketNaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPakketNaam()
    {
        return isset($this->pakketNaam) ? $this->pakketNaam : null;
    }
    /**
     * Set pakketNaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pakketNaam
     * @return \WebApiV4\StructType\PropositiesV4
     */
    public function setPakketNaam($pakketNaam = null)
    {
        // validation for constraint: string
        if (!is_null($pakketNaam) && !is_string($pakketNaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pakketNaam, true), gettype($pakketNaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($pakketNaam) && mb_strlen($pakketNaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($pakketNaam)), __LINE__);
        }
        if (is_null($pakketNaam) || (is_array($pakketNaam) && empty($pakketNaam))) {
            unset($this->pakketNaam);
        } else {
            $this->pakketNaam = $pakketNaam;
        }
        return $this;
    }
    /**
     * Get pakketPrijsExclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPakketPrijsExclBtw()
    {
        return isset($this->pakketPrijsExclBtw) ? $this->pakketPrijsExclBtw : null;
    }
    /**
     * Set pakketPrijsExclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pakketPrijsExclBtw
     * @return \WebApiV4\StructType\PropositiesV4
     */
    public function setPakketPrijsExclBtw($pakketPrijsExclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($pakketPrijsExclBtw) && !(is_float($pakketPrijsExclBtw) || is_numeric($pakketPrijsExclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pakketPrijsExclBtw, true), gettype($pakketPrijsExclBtw)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($pakketPrijsExclBtw) && mb_strlen(mb_substr($pakketPrijsExclBtw, mb_strpos($pakketPrijsExclBtw, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($pakketPrijsExclBtw, true), mb_strlen(mb_substr($pakketPrijsExclBtw, mb_strpos($pakketPrijsExclBtw, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($pakketPrijsExclBtw) && mb_strlen(preg_replace('/(\D)/', '', $pakketPrijsExclBtw)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($pakketPrijsExclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $pakketPrijsExclBtw))), __LINE__);
        }
        if (is_null($pakketPrijsExclBtw) || (is_array($pakketPrijsExclBtw) && empty($pakketPrijsExclBtw))) {
            unset($this->pakketPrijsExclBtw);
        } else {
            $this->pakketPrijsExclBtw = $pakketPrijsExclBtw;
        }
        return $this;
    }
    /**
     * Get pakketPrijsInclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPakketPrijsInclBtw()
    {
        return isset($this->pakketPrijsInclBtw) ? $this->pakketPrijsInclBtw : null;
    }
    /**
     * Set pakketPrijsInclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pakketPrijsInclBtw
     * @return \WebApiV4\StructType\PropositiesV4
     */
    public function setPakketPrijsInclBtw($pakketPrijsInclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($pakketPrijsInclBtw) && !(is_float($pakketPrijsInclBtw) || is_numeric($pakketPrijsInclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pakketPrijsInclBtw, true), gettype($pakketPrijsInclBtw)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($pakketPrijsInclBtw) && mb_strlen(mb_substr($pakketPrijsInclBtw, mb_strpos($pakketPrijsInclBtw, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($pakketPrijsInclBtw, true), mb_strlen(mb_substr($pakketPrijsInclBtw, mb_strpos($pakketPrijsInclBtw, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($pakketPrijsInclBtw) && mb_strlen(preg_replace('/(\D)/', '', $pakketPrijsInclBtw)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($pakketPrijsInclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $pakketPrijsInclBtw))), __LINE__);
        }
        if (is_null($pakketPrijsInclBtw) || (is_array($pakketPrijsInclBtw) && empty($pakketPrijsInclBtw))) {
            unset($this->pakketPrijsInclBtw);
        } else {
            $this->pakketPrijsInclBtw = $pakketPrijsInclBtw;
        }
        return $this;
    }
    /**
     * Get propositiePremiums value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \WebApiV4\StructType\PropositiePremiumsTabV4|null
     */
    public function getPropositiePremiums()
    {
        return isset($this->propositiePremiums) ? $this->propositiePremiums : null;
    }
    /**
     * Set propositiePremiums value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \WebApiV4\StructType\PropositiePremiumsTabV4 $propositiePremiums
     * @return \WebApiV4\StructType\PropositiesV4
     */
    public function setPropositiePremiums(\WebApiV4\StructType\PropositiePremiumsTabV4 $propositiePremiums = null)
    {
        if (is_null($propositiePremiums) || (is_array($propositiePremiums) && empty($propositiePremiums))) {
            unset($this->propositiePremiums);
        } else {
            $this->propositiePremiums = $propositiePremiums;
        }
        return $this;
    }
    /**
     * Get prijsPropositieInclBtw value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrijsPropositieInclBtw()
    {
        return isset($this->prijsPropositieInclBtw) ? $this->prijsPropositieInclBtw : null;
    }
    /**
     * Set prijsPropositieInclBtw value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prijsPropositieInclBtw
     * @return \WebApiV4\StructType\PropositiesV4
     */
    public function setPrijsPropositieInclBtw($prijsPropositieInclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($prijsPropositieInclBtw) && !(is_float($prijsPropositieInclBtw) || is_numeric($prijsPropositieInclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prijsPropositieInclBtw, true), gettype($prijsPropositieInclBtw)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($prijsPropositieInclBtw) && mb_strlen(mb_substr($prijsPropositieInclBtw, mb_strpos($prijsPropositieInclBtw, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($prijsPropositieInclBtw, true), mb_strlen(mb_substr($prijsPropositieInclBtw, mb_strpos($prijsPropositieInclBtw, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($prijsPropositieInclBtw) && mb_strlen(preg_replace('/(\D)/', '', $prijsPropositieInclBtw)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($prijsPropositieInclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $prijsPropositieInclBtw))), __LINE__);
        }
        if (is_null($prijsPropositieInclBtw) || (is_array($prijsPropositieInclBtw) && empty($prijsPropositieInclBtw))) {
            unset($this->prijsPropositieInclBtw);
        } else {
            $this->prijsPropositieInclBtw = $prijsPropositieInclBtw;
        }
        return $this;
    }
    /**
     * Get kortingTekst value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKortingTekst()
    {
        return isset($this->kortingTekst) ? $this->kortingTekst : null;
    }
    /**
     * Set kortingTekst value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kortingTekst
     * @return \WebApiV4\StructType\PropositiesV4
     */
    public function setKortingTekst($kortingTekst = null)
    {
        // validation for constraint: string
        if (!is_null($kortingTekst) && !is_string($kortingTekst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kortingTekst, true), gettype($kortingTekst)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($kortingTekst) && mb_strlen($kortingTekst) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($kortingTekst)), __LINE__);
        }
        if (is_null($kortingTekst) || (is_array($kortingTekst) && empty($kortingTekst))) {
            unset($this->kortingTekst);
        } else {
            $this->kortingTekst = $kortingTekst;
        }
        return $this;
    }
    /**
     * Get prijs1ePeriodeExcl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrijs1ePeriodeExcl()
    {
        return isset($this->prijs1ePeriodeExcl) ? $this->prijs1ePeriodeExcl : null;
    }
    /**
     * Set prijs1ePeriodeExcl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prijs1ePeriodeExcl
     * @return \WebApiV4\StructType\PropositiesV4
     */
    public function setPrijs1ePeriodeExcl($prijs1ePeriodeExcl = null)
    {
        // validation for constraint: float
        if (!is_null($prijs1ePeriodeExcl) && !(is_float($prijs1ePeriodeExcl) || is_numeric($prijs1ePeriodeExcl))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prijs1ePeriodeExcl, true), gettype($prijs1ePeriodeExcl)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($prijs1ePeriodeExcl) && mb_strlen(preg_replace('/(\D)/', '', $prijs1ePeriodeExcl)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($prijs1ePeriodeExcl, true), mb_strlen(preg_replace('/(\D)/', '', $prijs1ePeriodeExcl))), __LINE__);
        }
        if (is_null($prijs1ePeriodeExcl) || (is_array($prijs1ePeriodeExcl) && empty($prijs1ePeriodeExcl))) {
            unset($this->prijs1ePeriodeExcl);
        } else {
            $this->prijs1ePeriodeExcl = $prijs1ePeriodeExcl;
        }
        return $this;
    }
    /**
     * Get prijs1ePeriodeIncl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrijs1ePeriodeIncl()
    {
        return isset($this->prijs1ePeriodeIncl) ? $this->prijs1ePeriodeIncl : null;
    }
    /**
     * Set prijs1ePeriodeIncl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $prijs1ePeriodeIncl
     * @return \WebApiV4\StructType\PropositiesV4
     */
    public function setPrijs1ePeriodeIncl($prijs1ePeriodeIncl = null)
    {
        // validation for constraint: float
        if (!is_null($prijs1ePeriodeIncl) && !(is_float($prijs1ePeriodeIncl) || is_numeric($prijs1ePeriodeIncl))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prijs1ePeriodeIncl, true), gettype($prijs1ePeriodeIncl)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($prijs1ePeriodeIncl) && mb_strlen(mb_substr($prijs1ePeriodeIncl, mb_strpos($prijs1ePeriodeIncl, '.') + 1)) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($prijs1ePeriodeIncl, true), mb_strlen(mb_substr($prijs1ePeriodeIncl, mb_strpos($prijs1ePeriodeIncl, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(17)
        if (!is_null($prijs1ePeriodeIncl) && mb_strlen(preg_replace('/(\D)/', '', $prijs1ePeriodeIncl)) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 17 digits, "%d" given', var_export($prijs1ePeriodeIncl, true), mb_strlen(preg_replace('/(\D)/', '', $prijs1ePeriodeIncl))), __LINE__);
        }
        if (is_null($prijs1ePeriodeIncl) || (is_array($prijs1ePeriodeIncl) && empty($prijs1ePeriodeIncl))) {
            unset($this->prijs1ePeriodeIncl);
        } else {
            $this->prijs1ePeriodeIncl = $prijs1ePeriodeIncl;
        }
        return $this;
    }
    /**
     * Get actieHerkomstcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActieHerkomstcode()
    {
        return isset($this->actieHerkomstcode) ? $this->actieHerkomstcode : null;
    }
    /**
     * Set actieHerkomstcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actieHerkomstcode
     * @return \WebApiV4\StructType\PropositiesV4
     */
    public function setActieHerkomstcode($actieHerkomstcode = null)
    {
        // validation for constraint: string
        if (!is_null($actieHerkomstcode) && !is_string($actieHerkomstcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actieHerkomstcode, true), gettype($actieHerkomstcode)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($actieHerkomstcode) && mb_strlen($actieHerkomstcode) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($actieHerkomstcode)), __LINE__);
        }
        if (is_null($actieHerkomstcode) || (is_array($actieHerkomstcode) && empty($actieHerkomstcode))) {
            unset($this->actieHerkomstcode);
        } else {
            $this->actieHerkomstcode = $actieHerkomstcode;
        }
        return $this;
    }
    /**
     * Get actieHerkomstnaam value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActieHerkomstnaam()
    {
        return isset($this->actieHerkomstnaam) ? $this->actieHerkomstnaam : null;
    }
    /**
     * Set actieHerkomstnaam value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actieHerkomstnaam
     * @return \WebApiV4\StructType\PropositiesV4
     */
    public function setActieHerkomstnaam($actieHerkomstnaam = null)
    {
        // validation for constraint: string
        if (!is_null($actieHerkomstnaam) && !is_string($actieHerkomstnaam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actieHerkomstnaam, true), gettype($actieHerkomstnaam)), __LINE__);
        }
        // validation for constraint: maxLength(120)
        if (!is_null($actieHerkomstnaam) && mb_strlen($actieHerkomstnaam) > 120) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 120', mb_strlen($actieHerkomstnaam)), __LINE__);
        }
        if (is_null($actieHerkomstnaam) || (is_array($actieHerkomstnaam) && empty($actieHerkomstnaam))) {
            unset($this->actieHerkomstnaam);
        } else {
            $this->actieHerkomstnaam = $actieHerkomstnaam;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\PropositiesV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
