<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getPropositieInfoRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Geeft informatie terug over een propositie voor de gegeven actieCode</p> <p>In de default implementatie worden alleen gegevens terugegeven voor abonnementsoorten die bij de Actieve Stamgegevens op actief zijn gezet.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class GetPropositieInfoRequest extends AbstractStructBase
{
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The actieCode
     * Meta informations extracted from the WSDL
     * - documentation: Actiecode. Moet bestaan in de actietabel
     * - base: xsd:string
     * - maxLength: 15
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $actieCode;
    /**
     * The uitgaveCode
     * Meta informations extracted from the WSDL
     * - documentation: Uitgave code. Moet bestaan in de uitgaventabel. Indien deze is meegegeven worden alleen de proposities van de opgegeven uitgave teruggegeven.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $uitgaveCode;
    /**
     * The landCode
     * Meta informations extracted from the WSDL
     * - documentation: Landcode. Moet bestaan in de landentabel. Indien meegegeven wordt in het return object de prijs voor het opgegeven land teruggegeven.
     * - base: xsd:string
     * - maxLength: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $landCode;
    /**
     * The negeerActStamgegevensInt
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie negeer actieve stamgegevens. false (Default) = Hou rekening met inrichting actieve stamgegevens. true = Negeer actieve stamgegevens.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $negeerActStamgegevensInt;
    /**
     * Constructor method for getPropositieInfoRequest
     * @uses GetPropositieInfoRequest::setRequestTag()
     * @uses GetPropositieInfoRequest::setActieCode()
     * @uses GetPropositieInfoRequest::setUitgaveCode()
     * @uses GetPropositieInfoRequest::setLandCode()
     * @uses GetPropositieInfoRequest::setNegeerActStamgegevensInt()
     * @param string $requestTag
     * @param string $actieCode
     * @param string $uitgaveCode
     * @param string $landCode
     * @param bool $negeerActStamgegevensInt
     */
    public function __construct($requestTag = null, $actieCode = null, $uitgaveCode = null, $landCode = null, $negeerActStamgegevensInt = null)
    {
        $this
            ->setRequestTag($requestTag)
            ->setActieCode($actieCode)
            ->setUitgaveCode($uitgaveCode)
            ->setLandCode($landCode)
            ->setNegeerActStamgegevensInt($negeerActStamgegevensInt);
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \WebApiV4\StructType\GetPropositieInfoRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get actieCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActieCode()
    {
        return isset($this->actieCode) ? $this->actieCode : null;
    }
    /**
     * Set actieCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actieCode
     * @return \WebApiV4\StructType\GetPropositieInfoRequest
     */
    public function setActieCode($actieCode = null)
    {
        // validation for constraint: string
        if (!is_null($actieCode) && !is_string($actieCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actieCode, true), gettype($actieCode)), __LINE__);
        }
        // validation for constraint: maxLength(15)
        if (!is_null($actieCode) && mb_strlen($actieCode) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 15', mb_strlen($actieCode)), __LINE__);
        }
        if (is_null($actieCode) || (is_array($actieCode) && empty($actieCode))) {
            unset($this->actieCode);
        } else {
            $this->actieCode = $actieCode;
        }
        return $this;
    }
    /**
     * Get uitgaveCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUitgaveCode()
    {
        return isset($this->uitgaveCode) ? $this->uitgaveCode : null;
    }
    /**
     * Set uitgaveCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uitgaveCode
     * @return \WebApiV4\StructType\GetPropositieInfoRequest
     */
    public function setUitgaveCode($uitgaveCode = null)
    {
        // validation for constraint: string
        if (!is_null($uitgaveCode) && !is_string($uitgaveCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uitgaveCode, true), gettype($uitgaveCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($uitgaveCode) && mb_strlen($uitgaveCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($uitgaveCode)), __LINE__);
        }
        if (is_null($uitgaveCode) || (is_array($uitgaveCode) && empty($uitgaveCode))) {
            unset($this->uitgaveCode);
        } else {
            $this->uitgaveCode = $uitgaveCode;
        }
        return $this;
    }
    /**
     * Get landCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLandCode()
    {
        return isset($this->landCode) ? $this->landCode : null;
    }
    /**
     * Set landCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $landCode
     * @return \WebApiV4\StructType\GetPropositieInfoRequest
     */
    public function setLandCode($landCode = null)
    {
        // validation for constraint: string
        if (!is_null($landCode) && !is_string($landCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($landCode, true), gettype($landCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($landCode) && mb_strlen($landCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($landCode)), __LINE__);
        }
        if (is_null($landCode) || (is_array($landCode) && empty($landCode))) {
            unset($this->landCode);
        } else {
            $this->landCode = $landCode;
        }
        return $this;
    }
    /**
     * Get negeerActStamgegevensInt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNegeerActStamgegevensInt()
    {
        return isset($this->negeerActStamgegevensInt) ? $this->negeerActStamgegevensInt : null;
    }
    /**
     * Set negeerActStamgegevensInt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $negeerActStamgegevensInt
     * @return \WebApiV4\StructType\GetPropositieInfoRequest
     */
    public function setNegeerActStamgegevensInt($negeerActStamgegevensInt = null)
    {
        // validation for constraint: boolean
        if (!is_null($negeerActStamgegevensInt) && !is_bool($negeerActStamgegevensInt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($negeerActStamgegevensInt, true), gettype($negeerActStamgegevensInt)), __LINE__);
        }
        if (is_null($negeerActStamgegevensInt) || (is_array($negeerActStamgegevensInt) && empty($negeerActStamgegevensInt))) {
            unset($this->negeerActStamgegevensInt);
        } else {
            $this->negeerActStamgegevensInt = $negeerActStamgegevensInt;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\GetPropositieInfoRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
