<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getKenmerkInfoRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Geeft de kenmerken terug die gekoppeld zijn aan een bepaalde relatie.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class GetKenmerkInfoRequest extends AbstractStructBase
{
    /**
     * The relNo
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer waarvan de kenmerken teruggegeven moet worden.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relNo;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The kenmerkGroepCode
     * Meta informations extracted from the WSDL
     * - documentation: Indien gevuld, worden alleen de kenmerken van de gegeven relatie in deze gegeven kenmerkgroep teruggegeven.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $kenmerkGroepCode;
    /**
     * Constructor method for getKenmerkInfoRequest
     * @uses GetKenmerkInfoRequest::setRelNo()
     * @uses GetKenmerkInfoRequest::setRequestTag()
     * @uses GetKenmerkInfoRequest::setKenmerkGroepCode()
     * @param int $relNo
     * @param string $requestTag
     * @param string $kenmerkGroepCode
     */
    public function __construct($relNo = null, $requestTag = null, $kenmerkGroepCode = null)
    {
        $this
            ->setRelNo($relNo)
            ->setRequestTag($requestTag)
            ->setKenmerkGroepCode($kenmerkGroepCode);
    }
    /**
     * Get relNo value
     * @return int
     */
    public function getRelNo()
    {
        return $this->relNo;
    }
    /**
     * Set relNo value
     * @param int $relNo
     * @return \WebApiV4\StructType\GetKenmerkInfoRequest
     */
    public function setRelNo($relNo = null)
    {
        // validation for constraint: int
        if (!is_null($relNo) && !(is_int($relNo) || ctype_digit($relNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNo, true), gettype($relNo)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNo) && mb_strlen(preg_replace('/(\D)/', '', $relNo)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNo, true), mb_strlen(preg_replace('/(\D)/', '', $relNo))), __LINE__);
        }
        $this->relNo = $relNo;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \WebApiV4\StructType\GetKenmerkInfoRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get kenmerkGroepCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKenmerkGroepCode()
    {
        return isset($this->kenmerkGroepCode) ? $this->kenmerkGroepCode : null;
    }
    /**
     * Set kenmerkGroepCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kenmerkGroepCode
     * @return \WebApiV4\StructType\GetKenmerkInfoRequest
     */
    public function setKenmerkGroepCode($kenmerkGroepCode = null)
    {
        // validation for constraint: string
        if (!is_null($kenmerkGroepCode) && !is_string($kenmerkGroepCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kenmerkGroepCode, true), gettype($kenmerkGroepCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($kenmerkGroepCode) && mb_strlen($kenmerkGroepCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($kenmerkGroepCode)), __LINE__);
        }
        if (is_null($kenmerkGroepCode) || (is_array($kenmerkGroepCode) && empty($kenmerkGroepCode))) {
            unset($this->kenmerkGroepCode);
        } else {
            $this->kenmerkGroepCode = $kenmerkGroepCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\GetKenmerkInfoRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
