<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FactSamenvatV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Samengevatte gegevens van een factuur.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class FactSamenvatV4 extends AbstractStructBase
{
    /**
     * The factuurNo
     * Meta informations extracted from the WSDL
     * - documentation: Factuurnummer.
     * - base: xsd:string
     * - maxLength: 17
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $factuurNo;
    /**
     * The factuurDatum
     * Meta informations extracted from the WSDL
     * - documentation: Factuurdatum.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $factuurDatum;
    /**
     * The vervalDatum
     * Meta informations extracted from the WSDL
     * - documentation: Vervaldatum.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $vervalDatum;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - documentation: [0,1,2,3,4,5] Status van de factuur: 0 = Voldaan, 1 = Niet voldaan, 2 = Vervallen, 3 = Naar incassobureau, 4 = Automatische incasso, 5 = Creditcard incasso.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $status;
    /**
     * The totaalExclBtw
     * Meta informations extracted from the WSDL
     * - documentation: Totaal bedrag exclusief BTW.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $totaalExclBtw;
    /**
     * The totaalInclBtw
     * Meta informations extracted from the WSDL
     * - documentation: Totaal bedrag inclusief BTW.
     * - base: xsd:decimal
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 38
     * @var float
     */
    public $totaalInclBtw;
    /**
     * The subtotaalInfo
     * Meta informations extracted from the WSDL
     * - documentation: Samengevatte factuur subtotaal info.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \WebApiV4\StructType\FactSamenvatSubtotInfoV4
     */
    public $subtotaalInfo;
    /**
     * The btwInfo
     * Meta informations extracted from the WSDL
     * - documentation: BTW gegevens van de factuur.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var \WebApiV4\StructType\FactSamenvatBtwInfoV4
     */
    public $btwInfo;
    /**
     * Constructor method for FactSamenvatV4
     * @uses FactSamenvatV4::setFactuurNo()
     * @uses FactSamenvatV4::setFactuurDatum()
     * @uses FactSamenvatV4::setVervalDatum()
     * @uses FactSamenvatV4::setStatus()
     * @uses FactSamenvatV4::setTotaalExclBtw()
     * @uses FactSamenvatV4::setTotaalInclBtw()
     * @uses FactSamenvatV4::setSubtotaalInfo()
     * @uses FactSamenvatV4::setBtwInfo()
     * @param string $factuurNo
     * @param string $factuurDatum
     * @param string $vervalDatum
     * @param float $status
     * @param float $totaalExclBtw
     * @param float $totaalInclBtw
     * @param \WebApiV4\StructType\FactSamenvatSubtotInfoV4 $subtotaalInfo
     * @param \WebApiV4\StructType\FactSamenvatBtwInfoV4 $btwInfo
     */
    public function __construct($factuurNo = null, $factuurDatum = null, $vervalDatum = null, $status = null, $totaalExclBtw = null, $totaalInclBtw = null, \WebApiV4\StructType\FactSamenvatSubtotInfoV4 $subtotaalInfo = null, \WebApiV4\StructType\FactSamenvatBtwInfoV4 $btwInfo = null)
    {
        $this
            ->setFactuurNo($factuurNo)
            ->setFactuurDatum($factuurDatum)
            ->setVervalDatum($vervalDatum)
            ->setStatus($status)
            ->setTotaalExclBtw($totaalExclBtw)
            ->setTotaalInclBtw($totaalInclBtw)
            ->setSubtotaalInfo($subtotaalInfo)
            ->setBtwInfo($btwInfo);
    }
    /**
     * Get factuurNo value
     * @return string
     */
    public function getFactuurNo()
    {
        return $this->factuurNo;
    }
    /**
     * Set factuurNo value
     * @param string $factuurNo
     * @return \WebApiV4\StructType\FactSamenvatV4
     */
    public function setFactuurNo($factuurNo = null)
    {
        // validation for constraint: string
        if (!is_null($factuurNo) && !is_string($factuurNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($factuurNo, true), gettype($factuurNo)), __LINE__);
        }
        // validation for constraint: maxLength(17)
        if (!is_null($factuurNo) && mb_strlen($factuurNo) > 17) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 17', mb_strlen($factuurNo)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($factuurNo) && mb_strlen($factuurNo) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($factuurNo)), __LINE__);
        }
        $this->factuurNo = $factuurNo;
        return $this;
    }
    /**
     * Get factuurDatum value
     * @return string
     */
    public function getFactuurDatum()
    {
        return $this->factuurDatum;
    }
    /**
     * Set factuurDatum value
     * @param string $factuurDatum
     * @return \WebApiV4\StructType\FactSamenvatV4
     */
    public function setFactuurDatum($factuurDatum = null)
    {
        // validation for constraint: string
        if (!is_null($factuurDatum) && !is_string($factuurDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($factuurDatum, true), gettype($factuurDatum)), __LINE__);
        }
        $this->factuurDatum = $factuurDatum;
        return $this;
    }
    /**
     * Get vervalDatum value
     * @return string
     */
    public function getVervalDatum()
    {
        return $this->vervalDatum;
    }
    /**
     * Set vervalDatum value
     * @param string $vervalDatum
     * @return \WebApiV4\StructType\FactSamenvatV4
     */
    public function setVervalDatum($vervalDatum = null)
    {
        // validation for constraint: string
        if (!is_null($vervalDatum) && !is_string($vervalDatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vervalDatum, true), gettype($vervalDatum)), __LINE__);
        }
        $this->vervalDatum = $vervalDatum;
        return $this;
    }
    /**
     * Get status value
     * @return float
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param float $status
     * @return \WebApiV4\StructType\FactSamenvatV4
     */
    public function setStatus($status = null)
    {
        // validation for constraint: float
        if (!is_null($status) && !(is_float($status) || is_numeric($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($status) && mb_strlen(preg_replace('/(\D)/', '', $status)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($status, true), mb_strlen(preg_replace('/(\D)/', '', $status))), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get totaalExclBtw value
     * @return float
     */
    public function getTotaalExclBtw()
    {
        return $this->totaalExclBtw;
    }
    /**
     * Set totaalExclBtw value
     * @param float $totaalExclBtw
     * @return \WebApiV4\StructType\FactSamenvatV4
     */
    public function setTotaalExclBtw($totaalExclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($totaalExclBtw) && !(is_float($totaalExclBtw) || is_numeric($totaalExclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totaalExclBtw, true), gettype($totaalExclBtw)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($totaalExclBtw) && mb_strlen(preg_replace('/(\D)/', '', $totaalExclBtw)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($totaalExclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $totaalExclBtw))), __LINE__);
        }
        $this->totaalExclBtw = $totaalExclBtw;
        return $this;
    }
    /**
     * Get totaalInclBtw value
     * @return float
     */
    public function getTotaalInclBtw()
    {
        return $this->totaalInclBtw;
    }
    /**
     * Set totaalInclBtw value
     * @param float $totaalInclBtw
     * @return \WebApiV4\StructType\FactSamenvatV4
     */
    public function setTotaalInclBtw($totaalInclBtw = null)
    {
        // validation for constraint: float
        if (!is_null($totaalInclBtw) && !(is_float($totaalInclBtw) || is_numeric($totaalInclBtw))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totaalInclBtw, true), gettype($totaalInclBtw)), __LINE__);
        }
        // validation for constraint: totalDigits(38)
        if (!is_null($totaalInclBtw) && mb_strlen(preg_replace('/(\D)/', '', $totaalInclBtw)) > 38) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 38 digits, "%d" given', var_export($totaalInclBtw, true), mb_strlen(preg_replace('/(\D)/', '', $totaalInclBtw))), __LINE__);
        }
        $this->totaalInclBtw = $totaalInclBtw;
        return $this;
    }
    /**
     * Get subtotaalInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \WebApiV4\StructType\FactSamenvatSubtotInfoV4|null
     */
    public function getSubtotaalInfo()
    {
        return isset($this->subtotaalInfo) ? $this->subtotaalInfo : null;
    }
    /**
     * Set subtotaalInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \WebApiV4\StructType\FactSamenvatSubtotInfoV4 $subtotaalInfo
     * @return \WebApiV4\StructType\FactSamenvatV4
     */
    public function setSubtotaalInfo(\WebApiV4\StructType\FactSamenvatSubtotInfoV4 $subtotaalInfo = null)
    {
        if (is_null($subtotaalInfo) || (is_array($subtotaalInfo) && empty($subtotaalInfo))) {
            unset($this->subtotaalInfo);
        } else {
            $this->subtotaalInfo = $subtotaalInfo;
        }
        return $this;
    }
    /**
     * Get btwInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \WebApiV4\StructType\FactSamenvatBtwInfoV4|null
     */
    public function getBtwInfo()
    {
        return isset($this->btwInfo) ? $this->btwInfo : null;
    }
    /**
     * Set btwInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \WebApiV4\StructType\FactSamenvatBtwInfoV4 $btwInfo
     * @return \WebApiV4\StructType\FactSamenvatV4
     */
    public function setBtwInfo(\WebApiV4\StructType\FactSamenvatBtwInfoV4 $btwInfo = null)
    {
        if (is_null($btwInfo) || (is_array($btwInfo) && empty($btwInfo))) {
            unset($this->btwInfo);
        } else {
            $this->btwInfo = $btwInfo;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\FactSamenvatV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
