<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditieInfoV4 StructType
 * Meta informations extracted from the WSDL
 * - documentation: Lijst met edities
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class EditieInfoV4 extends AbstractStructBase
{
    /**
     * The editie
     * Meta informations extracted from the WSDL
     * - documentation: Lijst met edities.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: false
     * @var \WebApiV4\StructType\EditieV4[]
     */
    public $editie;
    /**
     * Constructor method for EditieInfoV4
     * @uses EditieInfoV4::setEditie()
     * @param \WebApiV4\StructType\EditieV4[] $editie
     */
    public function __construct(array $editie = array())
    {
        $this
            ->setEditie($editie);
    }
    /**
     * Get editie value
     * @return \WebApiV4\StructType\EditieV4[]|null
     */
    public function getEditie()
    {
        return $this->editie;
    }
    /**
     * This method is responsible for validating the values passed to the setEditie method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEditie method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEditieForArrayConstraintsFromSetEditie(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $editieInfoV4EditieItem) {
            // validation for constraint: itemType
            if (!$editieInfoV4EditieItem instanceof \WebApiV4\StructType\EditieV4) {
                $invalidValues[] = is_object($editieInfoV4EditieItem) ? get_class($editieInfoV4EditieItem) : sprintf('%s(%s)', gettype($editieInfoV4EditieItem), var_export($editieInfoV4EditieItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The editie property can only contain items of type \WebApiV4\StructType\EditieV4, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set editie value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\EditieV4[] $editie
     * @return \WebApiV4\StructType\EditieInfoV4
     */
    public function setEditie(array $editie = array())
    {
        // validation for constraint: array
        if ('' !== ($editieArrayErrorMessage = self::validateEditieForArrayConstraintsFromSetEditie($editie))) {
            throw new \InvalidArgumentException($editieArrayErrorMessage, __LINE__);
        }
        $this->editie = $editie;
        return $this;
    }
    /**
     * Add item to editie value
     * @throws \InvalidArgumentException
     * @param \WebApiV4\StructType\EditieV4 $item
     * @return \WebApiV4\StructType\EditieInfoV4
     */
    public function addToEditie(\WebApiV4\StructType\EditieV4 $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \WebApiV4\StructType\EditieV4) {
            throw new \InvalidArgumentException(sprintf('The editie property can only contain items of type \WebApiV4\StructType\EditieV4, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->editie[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\EditieInfoV4
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
