<?php

namespace WebApiV4\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createVerbandR1noR2nawRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Maakt een relatieverband tussen twee relaties aan. </p> <p>Een ingelogde gebruiker (het relatienummer is bekend) wil als relatie 1 een verband leggen met een nieuwe klant. </p> <p>Voor het meegegeven relatienummer van relatie 1 wordt
 * gecontroleerd of deze bij een verwijderde relatie hoort. Als dat het geval is (mogelijk door samengevoegde doublures) wordt het relatienummer waaraan de verwijderde relatie gekoppeld is gebruikt en geretourneerd. Op basis van de meegegeven
 * klantgegevens van relatie 2 wordt bepaald of de klant misschien al bekend is. Is er 1 match dan zal het de bestaande klant gebruikt worden. Zijn er meerdere mogelijkheden, dan zal dit teruggekoppeld worden. Betreft het een onbekende klant, dan zal
 * een nieuwe klant aangemaakt worden. Het uiteindelijk gebruikte relatienummer wordt geretourneerd met een indicatie of het een nieuwe of reeds bestaande klant betreft.
 * @subpackage Structs
 * @date 20190723
 * @package WebApiV4
 */
class CreateVerbandR1noR2nawRequest extends AbstractStructBase
{
    /**
     * The relNoRel1
     * Meta informations extracted from the WSDL
     * - documentation: Relatienummer van Relatie 1.
     * - base: xsd:integer
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * - totalDigits: 15
     * @var int
     */
    public $relNoRel1;
    /**
     * The persoonsObjectRel2
     * Meta informations extracted from the WSDL
     * - documentation: Persoonsgegevens voor Relatie 2.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \WebApiV4\StructType\PersoonsObjectV4
     */
    public $persoonsObjectRel2;
    /**
     * The adresObjectRel2
     * Meta informations extracted from the WSDL
     * - documentation: Adresgegevens voor Relatie 2.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var \WebApiV4\StructType\AdresObjectV4
     */
    public $adresObjectRel2;
    /**
     * The verbandCode
     * Meta informations extracted from the WSDL
     * - documentation: Code van het te leggen verband. Moet een bestaande code zijn.
     * - base: xsd:string
     * - maxLength: 12
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $verbandCode;
    /**
     * The requestTag
     * Meta informations extracted from the WSDL
     * - documentation: Vrij veld voor aanroepende partij. De inhoud van dit veld wordt altijd identiek teruggestuurd.
     * - base: xsd:string
     * - maxLength: 4000
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $requestTag;
    /**
     * The canCreate
     * Meta informations extracted from the WSDL
     * - documentation: Indicatie of operatie in de testmodus wordt aangeroepen (er wordt dus geen verband aangemaakt) false (Default) = aanmaken, true = testmodus niet aanmaken.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canCreate;
    /**
     * Constructor method for createVerbandR1noR2nawRequest
     * @uses CreateVerbandR1noR2nawRequest::setRelNoRel1()
     * @uses CreateVerbandR1noR2nawRequest::setPersoonsObjectRel2()
     * @uses CreateVerbandR1noR2nawRequest::setAdresObjectRel2()
     * @uses CreateVerbandR1noR2nawRequest::setVerbandCode()
     * @uses CreateVerbandR1noR2nawRequest::setRequestTag()
     * @uses CreateVerbandR1noR2nawRequest::setCanCreate()
     * @param int $relNoRel1
     * @param \WebApiV4\StructType\PersoonsObjectV4 $persoonsObjectRel2
     * @param \WebApiV4\StructType\AdresObjectV4 $adresObjectRel2
     * @param string $verbandCode
     * @param string $requestTag
     * @param bool $canCreate
     */
    public function __construct($relNoRel1 = null, \WebApiV4\StructType\PersoonsObjectV4 $persoonsObjectRel2 = null, \WebApiV4\StructType\AdresObjectV4 $adresObjectRel2 = null, $verbandCode = null, $requestTag = null, $canCreate = null)
    {
        $this
            ->setRelNoRel1($relNoRel1)
            ->setPersoonsObjectRel2($persoonsObjectRel2)
            ->setAdresObjectRel2($adresObjectRel2)
            ->setVerbandCode($verbandCode)
            ->setRequestTag($requestTag)
            ->setCanCreate($canCreate);
    }
    /**
     * Get relNoRel1 value
     * @return int
     */
    public function getRelNoRel1()
    {
        return $this->relNoRel1;
    }
    /**
     * Set relNoRel1 value
     * @param int $relNoRel1
     * @return \WebApiV4\StructType\CreateVerbandR1noR2nawRequest
     */
    public function setRelNoRel1($relNoRel1 = null)
    {
        // validation for constraint: int
        if (!is_null($relNoRel1) && !(is_int($relNoRel1) || ctype_digit($relNoRel1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($relNoRel1, true), gettype($relNoRel1)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($relNoRel1) && mb_strlen(preg_replace('/(\D)/', '', $relNoRel1)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($relNoRel1, true), mb_strlen(preg_replace('/(\D)/', '', $relNoRel1))), __LINE__);
        }
        $this->relNoRel1 = $relNoRel1;
        return $this;
    }
    /**
     * Get persoonsObjectRel2 value
     * @return \WebApiV4\StructType\PersoonsObjectV4
     */
    public function getPersoonsObjectRel2()
    {
        return $this->persoonsObjectRel2;
    }
    /**
     * Set persoonsObjectRel2 value
     * @param \WebApiV4\StructType\PersoonsObjectV4 $persoonsObjectRel2
     * @return \WebApiV4\StructType\CreateVerbandR1noR2nawRequest
     */
    public function setPersoonsObjectRel2(\WebApiV4\StructType\PersoonsObjectV4 $persoonsObjectRel2 = null)
    {
        $this->persoonsObjectRel2 = $persoonsObjectRel2;
        return $this;
    }
    /**
     * Get adresObjectRel2 value
     * @return \WebApiV4\StructType\AdresObjectV4
     */
    public function getAdresObjectRel2()
    {
        return $this->adresObjectRel2;
    }
    /**
     * Set adresObjectRel2 value
     * @param \WebApiV4\StructType\AdresObjectV4 $adresObjectRel2
     * @return \WebApiV4\StructType\CreateVerbandR1noR2nawRequest
     */
    public function setAdresObjectRel2(\WebApiV4\StructType\AdresObjectV4 $adresObjectRel2 = null)
    {
        $this->adresObjectRel2 = $adresObjectRel2;
        return $this;
    }
    /**
     * Get verbandCode value
     * @return string
     */
    public function getVerbandCode()
    {
        return $this->verbandCode;
    }
    /**
     * Set verbandCode value
     * @param string $verbandCode
     * @return \WebApiV4\StructType\CreateVerbandR1noR2nawRequest
     */
    public function setVerbandCode($verbandCode = null)
    {
        // validation for constraint: string
        if (!is_null($verbandCode) && !is_string($verbandCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($verbandCode, true), gettype($verbandCode)), __LINE__);
        }
        // validation for constraint: maxLength(12)
        if (!is_null($verbandCode) && mb_strlen($verbandCode) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 12', mb_strlen($verbandCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($verbandCode) && mb_strlen($verbandCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($verbandCode)), __LINE__);
        }
        $this->verbandCode = $verbandCode;
        return $this;
    }
    /**
     * Get requestTag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestTag()
    {
        return isset($this->requestTag) ? $this->requestTag : null;
    }
    /**
     * Set requestTag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestTag
     * @return \WebApiV4\StructType\CreateVerbandR1noR2nawRequest
     */
    public function setRequestTag($requestTag = null)
    {
        // validation for constraint: string
        if (!is_null($requestTag) && !is_string($requestTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestTag, true), gettype($requestTag)), __LINE__);
        }
        // validation for constraint: maxLength(4000)
        if (!is_null($requestTag) && mb_strlen($requestTag) > 4000) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4000', mb_strlen($requestTag)), __LINE__);
        }
        if (is_null($requestTag) || (is_array($requestTag) && empty($requestTag))) {
            unset($this->requestTag);
        } else {
            $this->requestTag = $requestTag;
        }
        return $this;
    }
    /**
     * Get canCreate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanCreate()
    {
        return isset($this->canCreate) ? $this->canCreate : null;
    }
    /**
     * Set canCreate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canCreate
     * @return \WebApiV4\StructType\CreateVerbandR1noR2nawRequest
     */
    public function setCanCreate($canCreate = null)
    {
        // validation for constraint: boolean
        if (!is_null($canCreate) && !is_bool($canCreate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canCreate, true), gettype($canCreate)), __LINE__);
        }
        if (is_null($canCreate) || (is_array($canCreate) && empty($canCreate))) {
            unset($this->canCreate);
        } else {
            $this->canCreate = $canCreate;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \WebApiV4\StructType\CreateVerbandR1noR2nawRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
